/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.Set;

public class CmAuthorizationService {
    private static final String SYS_CONFIG_SSO_GROUP_NAME = "SystemConfiguration.Administrators";
    private static final String CA_ADMINS_GROUP_NAME = "CAAdmins";

    public boolean isCurrentUserAuthorized() {
        Set ssoGroups = SsoUtil.getGroups();
        if (ssoGroups == null || ssoGroups.isEmpty()) {
            return false;
        }
        for (String ssoGroup : ssoGroups) {
            int delimiterIndex = ssoGroup.indexOf("\\");
            String groupSimpleName = delimiterIndex != -1 ? ssoGroup.substring(delimiterIndex + 1) : ssoGroup;
            if (!SYS_CONFIG_SSO_GROUP_NAME.equalsIgnoreCase(groupSimpleName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCaAdminsUser() {
        Set ssoGroups = SsoUtil.getGroups();
        if (ssoGroups == null || ssoGroups.isEmpty()) {
            return false;
        }
        for (String ssoGroup : ssoGroups) {
            int delimiterIndex = ssoGroup.indexOf("\\");
            String groupSimpleName = delimiterIndex != -1 ? ssoGroup.substring(delimiterIndex + 1) : ssoGroup;
            if (!CA_ADMINS_GROUP_NAME.equalsIgnoreCase(groupSimpleName)) continue;
            return true;
        }
        return false;
    }
}

