/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vise.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class InternalServiceInfo {
    private int _cachedHashCode = -1;
    private final ServiceInfo _scaServiceInfo;
    private final String _serverHostname;
    private final ServiceTypes.Info _vmonServiceInfo;
    private final String _vmonServiceId;

    public InternalServiceInfo(ServiceInfo scaServiceInfo, String vmonServiceId, ServiceTypes.Info vmonServiceInfo, String serverHostname) {
        assert (scaServiceInfo != null ^ (vmonServiceInfo != null && vmonServiceId != null));
        assert (serverHostname != null);
        this._scaServiceInfo = scaServiceInfo;
        this._vmonServiceId = vmonServiceId;
        this._vmonServiceInfo = vmonServiceInfo;
        this._serverHostname = serverHostname;
    }

    public ServiceInfo getScaServiceInfo() {
        return this._scaServiceInfo;
    }

    public ServiceTypes.Info getVmonServiceInfo() {
        return this._vmonServiceInfo;
    }

    public String getServiceId() {
        return this._vmonServiceId != null ? this._vmonServiceId : this._scaServiceInfo.serviceId;
    }

    public String getServerHostname() {
        return this._serverHostname;
    }

    public int hashCode() {
        if (this._cachedHashCode == -1) {
            int result = 17;
            result = 31 * result + ObjectUtil.getHashCode((Object)this.getServiceId());
            this._cachedHashCode = result = 31 * result + ObjectUtil.getHashCode((Object)this._serverHostname);
        }
        return this._cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalServiceInfo other = (InternalServiceInfo)obj;
        return ObjectUtil.objectsEqual((Object)this._serverHostname, (Object)other._serverHostname) && ObjectUtil.objectsEqual((Object)this.getServiceId(), (Object)other.getServiceId());
    }

    public static Map<String, Collection<String>> mapServiceIdsByServer(InternalServiceInfo[] services) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (InternalServiceInfo service : services) {
            if (!result.containsKey(service.getServerHostname())) {
                result.put(service.getServerHostname(), new ArrayList());
            }
            ((Collection)result.get(service.getServerHostname())).add(service.getServiceId());
        }
        return result;
    }
}

