/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PropertyCache<T> {
    public static final String SINGLETON_PROPERTY = "__singleton";
    private static final int DEFAULT_EXPIRATION_TIMEOUT_SECONDS = 2;
    private final int _expirationTimeoutSeconds;

    public PropertyCache() {
        this(2);
    }

    public PropertyCache(int timeoutS) {
        this._expirationTimeoutSeconds = timeoutS;
    }

    public Object[] getProperty(T[] objects, String propertyName) {
        HashMap<T, ExpirableData> cache = this.getMapForProperty(propertyName);
        if (cache.isEmpty()) {
            return null;
        }
        Object[] result = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = this.getPropertyFromMap(cache, objects[i]);
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public <C> C getProperty(T object, String propertyName) {
        HashMap<T, ExpirableData> cache = this.getMapForProperty(propertyName);
        return this.getPropertyFromMap(cache, object);
    }

    public void clear() {
        this.getRootMap().clear();
    }

    public void setProperty(T[] objects, String propertyName, Object[] values) {
        assert (objects.length == values.length);
        HashMap<T, ExpirableData> cache = this.getMapForProperty(propertyName);
        for (int i = 0; i < objects.length; ++i) {
            this.setPropertyOnMap(cache, objects[i], values[i], this._expirationTimeoutSeconds);
        }
    }

    public void setProperty(T object, String propertyName, Object value) {
        HashMap<T, ExpirableData> cache = this.getMapForProperty(propertyName);
        this.setPropertyOnMap(cache, object, value, this._expirationTimeoutSeconds);
    }

    private HashMap<T, ExpirableData> getMapForProperty(String propertyName) {
        ConcurrentHashMap<String, HashMap<T, ExpirableData>> rootMap = this.getRootMap();
        if (!rootMap.containsKey(propertyName)) {
            rootMap.putIfAbsent(propertyName, new HashMap());
        }
        return rootMap.get(propertyName);
    }

    private <C> C getPropertyFromMap(HashMap<T, ExpirableData> map, T key) {
        if (!map.containsKey(key)) {
            return null;
        }
        ExpirableData cacheEntry = map.get(key);
        if (!cacheEntry.hasNotExpired()) {
            return null;
        }
        return (C)cacheEntry.data;
    }

    protected abstract ConcurrentHashMap<String, HashMap<T, ExpirableData>> getRootMap();

    private void setPropertyOnMap(HashMap<T, ExpirableData> map, T key, Object value, int validityS) {
        map.put(key, new ExpirableData(validityS, value));
    }

    protected static class ExpirableData {
        final long expirationTimestamp;
        final Object data;

        ExpirableData(int validitySeconds, Object d) {
            this.expirationTimestamp = System.nanoTime() + 1000000000L * (long)validitySeconds;
            this.data = d;
        }

        boolean hasNotExpired() {
            return System.nanoTime() < this.expirationTimestamp;
        }
    }
}

