/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.devsetup.registration;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;

public class ServerRegistration {
    private static final String WINDOWS_CFG_DIR = "C:/ProgramData/VMware/vCenterServer/cfg";
    private static final String MAC_CFG_DIR = "/var/lib/vmware/vsphere-client";
    private static final String TEMPORARY_DIR = "temp";
    private static boolean _verbose = false;

    public static void main(String[] args) {
        Options options = ServerRegistration.createOptions();
        String user = "root";
        String password = null;
        String host = null;
        int port = 22;
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        try {
            String vmwareCfgFolder;
            block9: {
                commandLine = parser.parse(options, args, true);
                _verbose = commandLine.hasOption("v");
                user = commandLine.getOptionValue("u");
                user = user != null ? user : "root";
                password = commandLine.getOptionValue("pw");
                host = commandLine.getOptionValue("vcip");
                try {
                    String portStr = commandLine.getOptionValue("p");
                    port = portStr != null ? Integer.parseInt(portStr) : 22;
                }
                catch (NumberFormatException e) {
                    if (!_verbose) break block9;
                    e.printStackTrace();
                }
            }
            if (commandLine.hasOption("cfg")) {
                vmwareCfgFolder = commandLine.getOptionValue("cfg");
            } else {
                vmwareCfgFolder = System.getenv("VMWARE_CFG_DIR");
                if (vmwareCfgFolder == null) {
                    boolean isMacOS = System.getProperty("os.name").toLowerCase().contains("mac os");
                    vmwareCfgFolder = WINDOWS_CFG_DIR;
                    if (isMacOS) {
                        vmwareCfgFolder = MAC_CFG_DIR;
                    }
                }
            }
            if (_verbose) {
                System.out.println("VMWARE_CFG_DIR is chosen to be: " + vmwareCfgFolder);
            }
            ServerRegistration.setupConfiguration(host, port, user, password, vmwareCfgFolder);
        }
        catch (ParseException e) {
            ServerRegistration.printHelp(options, e.getMessage());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder("vcip").longOpt("vCenterIP").hasArg().argName("vc server ip").desc("vCenter server IP address").required().build());
        options.addOption(Option.builder("pw").longOpt("password").hasArg().argName("SSH Password").desc("vCenter server ssh password").required().build());
        options.addOption(Option.builder("u").longOpt("user").hasArg().argName("SSH User").desc("vCenter server ssh user, by default 'root'").required(false).build());
        options.addOption(Option.builder("p").longOpt("port").hasArg().argName("vc server ssh port").desc("vCenter server ssh port, by default 22").required(false).build());
        options.addOption(Option.builder("v").longOpt("verbose").argName("verbose error message").desc("Print stack trace in case of an exception").required(false).build());
        options.addOption(Option.builder("cfg").hasArg().argName("path to the configuration folder").desc("Used to specify the folder where to setup the VC files").required(false).build());
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupConfiguration(String host, int port, String user, String password, String vmwareCfgFolder) {
        Session session = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(user, host, port);
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            ServerRegistration.generateConfigFiles(session, vmwareCfgFolder);
            ServerRegistration.downloadConfigFilesInDir(session, TEMPORARY_DIR);
            try {
                ServerRegistration.deleteOldFiles(vmwareCfgFolder);
                ServerRegistration.copyOrderedConfigFilesInCfg(TEMPORARY_DIR, vmwareCfgFolder);
            }
            finally {
                ServerRegistration.deleteFile(TEMPORARY_DIR);
            }
            ServerRegistration.editTomcatConfig(vmwareCfgFolder);
        }
        catch (JSchException | SftpException e) {
            System.err.println("Has connection problem with vCenter server IP: " + host + ". Please check vCenter server and authentication.\n " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConfigFiles(Session session, String vmwareCfgFolder) throws JSchException, IOException {
        Channel channelExec = null;
        try {
            String line;
            int exitStatus = -1;
            File commandFile = new File("dev-setup.sh");
            Path path = Paths.get(commandFile.getPath(), new String[0]);
            byte[] data = Files.readAllBytes(path);
            byte[] allCommands = new byte[]{};
            byte[] command = ("export KEYSTORE=" + vmwareCfgFolder.replace("\\", "/") + "/store.jks; ").getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(command.length + data.length);
            byteBuffer.put(command);
            byteBuffer.put(data);
            allCommands = byteBuffer.array();
            channelExec = session.openChannel("exec");
            ((ChannelExec)channelExec).setCommand(allCommands);
            channelExec.setInputStream(null);
            ((ChannelExec)channelExec).setErrStream(System.err);
            InputStream in = channelExec.getInputStream();
            channelExec.connect();
            while (true) {
                if (channelExec.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            exitStatus = channelExec.getExitStatus();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer result = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
            System.out.println(result);
            if (exitStatus != 0) {
                System.err.println("Found error when generate store.jks, webclient.properties and ds.properties files. ");
                System.exit(-1);
            }
        }
        finally {
            if (channelExec != null) {
                channelExec.disconnect();
            }
        }
    }

    private static void downloadConfigFilesInDir(Session session, String dir) throws JSchException, IOException, SftpException {
        ChannelSftp downloadChannel = null;
        try {
            downloadChannel = (ChannelSftp)session.openChannel("sftp");
            downloadChannel.connect();
            ServerRegistration.downloadFile(downloadChannel, dir, "ds.properties");
            ServerRegistration.downloadFile(downloadChannel, dir, "webclient.properties");
            ServerRegistration.downloadFile(downloadChannel, dir, "store.jks");
        }
        finally {
            if (downloadChannel != null) {
                downloadChannel.disconnect();
            }
        }
    }

    private static void downloadFile(ChannelSftp downloadChannel, String path, String filename) throws SftpException, IOException {
        FileOutputStream fos = null;
        try {
            File folder = new File(path);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            fos = new FileOutputStream(new File(path + File.separator + filename));
            downloadChannel.get(filename, fos);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            block13: {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioe) {
                    if (!_verbose) break block13;
                    ioe.printStackTrace();
                }
            }
        }
        if (_verbose) {
            System.out.println("Downloaded file: \"" + filename + "\" in \"" + path + "\"");
        }
    }

    private static void deleteOldFiles(String vmwareCfgFolder) {
        if (_verbose) {
            System.out.println("Delete old files.");
        }
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(vmwareCfgFolder, "store.jks"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(vmwareCfgFolder, "vsphere-webclient.p12"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(vmwareCfgFolder, "vsphere-webclient-cert.txt"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(vmwareCfgFolder, "vsphere-webclient-key.txt"));
        ServerRegistration.deleteFile(ServerRegistration.joinPaths(vmwareCfgFolder, "vsphere-client" + File.separator + "cmCatalog"));
    }

    private static void copyOrderedConfigFilesInCfg(String temp, String vmwareCfgFolder) throws IOException {
        String dsPropertiesFolder = vmwareCfgFolder + File.separator + "vsphere-client" + File.separator + "config";
        String webclientFolder = vmwareCfgFolder + File.separator + "vsphere-client";
        FileUtils.copyFileToDirectory(new File(temp, "ds.properties"), new File(dsPropertiesFolder));
        FileUtils.copyFileToDirectory(new File(temp, "webclient.properties"), new File(webclientFolder));
        FileUtils.copyFileToDirectory(new File(temp, "store.jks"), new File(vmwareCfgFolder));
    }

    private static void deleteFile(String path) {
        block3: {
            File file = new File(path);
            try {
                FileUtils.forceDelete(file);
                if (_verbose) {
                    System.out.println("File: " + path + " was deleted.");
                }
            }
            catch (IOException e) {
                if (!_verbose) break block3;
                e.printStackTrace();
            }
        }
    }

    private static void editTomcatConfig(String vmwareCfgFolder) throws IOException {
        Path virgoConfigPath = Paths.get(System.getenv("VSPHERE_SDK_HOME"), "vsphere-ui", "server", "conf", "server.xml");
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(virgoConfigPath), charset);
        String[] contentParts = content.split("port=\"\\$\\{https\\.port}\"");
        String changedLastPart = contentParts[contentParts.length - 1].replaceFirst("compression=\"on\"", "compression=\"off\"");
        content = content.replace(contentParts[contentParts.length - 1], changedLastPart);
        content = content.replaceFirst("certificateKeystoreFile=\".*store[.]jks\"", "certificateKeystoreFile=\"" + vmwareCfgFolder.replace("\\", "/") + "/store.jks\"");
        Files.write(virgoConfigPath, content.getBytes(charset), new OpenOption[0]);
    }

    private static void printHelp(Options options, String footer) {
        new HelpFormatter().printHelp("server-registration", "Register client to vCenter server", options, "\n" + footer, true);
    }

    private static String joinPaths(String path1, String path2) {
        String fileFormat = "%s" + File.separator + "%s";
        return String.format(fileFormat, path1, path2);
    }
}

