/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.devcenter.http;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.security.SessionSecurityContext;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.vim.lookup.UriBasedEndpointRetriever;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.h5.devcenter.http.HttpClientBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;

public class ApiexplorerRequestHandler
implements HttpRequestHandler {
    private static final Logger _logger = LoggerFactory.getLogger(ApiexplorerRequestHandler.class);
    private static final String ENDPOINT_HEADER = "vapi-endpoint";
    private static final String APIEXPLORER_PATH = "/apiexplorer";
    private static final String REST_PATH = "/rest";
    private static final String SESSION_ID_HEADER = "vmware-api-session-id";
    private final UriBasedEndpointRetriever _endpointRetriever;
    private final VapiConnectionManagerRegistry<String> _connectionRegistry;
    private HttpClientBuilderFactory _clientBuilderFactory;
    private Map<String, URI> _endpointsByHost;

    public ApiexplorerRequestHandler(UriBasedEndpointRetriever endpointRetriever, VapiConnectionManagerRegistry<String> connectionRegistry, HttpClientBuilderFactory clientBuilderFactory) {
        this._endpointRetriever = endpointRetriever;
        this._connectionRegistry = connectionRegistry;
        this._clientBuilderFactory = clientBuilderFactory;
        this._endpointsByHost = null;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI uri = this.resolveUri(request);
        BasicHttpEntityEnclosingRequest proxyRequest = new BasicHttpEntityEnclosingRequest(request.getMethod(), uri.toString());
        proxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getInputStream(), ApiexplorerRequestHandler.getContentLength(request)));
        StubConfiguration stubConfig = null;
        if (uri.getPath().startsWith(REST_PATH)) {
            stubConfig = this._connectionRegistry.getConnectionManager((Object)uri.getHost()).getStubConfig();
            ExecutionContext.SecurityContext securityContext = stubConfig.getSecurityContext();
            char[] sessionId = ((SessionSecurityContext)securityContext).getSessionId();
            proxyRequest.setHeader(SESSION_ID_HEADER, String.valueOf(sessionId));
        }
        this.copyRequestHeaders(request, (HttpRequest)proxyRequest);
        HttpResponse proxyResponse = this.doExecute((HttpRequest)proxyRequest, uri);
        int statusCode = proxyResponse.getStatusLine().getStatusCode();
        if (statusCode == 401 && stubConfig != null) {
            Unauthenticated error = new Unauthenticated();
            ExecutionContext executionContext = new ExecutionContext(stubConfig.getSecurityContext());
            RetryPolicy.RetryContext retryContext = new RetryPolicy.RetryContext("ApiexplorerRequestHandlerExecution", uri.toString(), executionContext, new StructValue(""));
            stubConfig.getRetryPolicy().onInvocationError((RuntimeException)error, retryContext, 1);
        }
        response.setStatus(statusCode);
        this.copyResponseHeaders(proxyResponse, response);
        this.copyResponseEntity(proxyResponse, response);
        EntityUtils.consumeQuietly((HttpEntity)proxyResponse.getEntity());
    }

    private URI resolveUri(HttpServletRequest request) throws ServletException {
        URI uri;
        String endpoingHost;
        URI endpointUri;
        if (this._endpointsByHost == null) {
            this.retrieveEndpoints();
        }
        if ((endpointUri = this._endpointsByHost.get(endpoingHost = request.getHeader(ENDPOINT_HEADER))) == null) {
            throw new ServletException("Unknown endpoint " + endpoingHost);
        }
        String normalizedPath = FilenameUtils.normalize((String)request.getPathInfo(), (boolean)true);
        if (!normalizedPath.startsWith(APIEXPLORER_PATH) && !normalizedPath.startsWith(REST_PATH)) {
            throw new ServletException("Target path not recognized " + normalizedPath);
        }
        try {
            uri = new URI(endpointUri.getScheme(), null, endpointUri.getHost(), endpointUri.getPort(), normalizedPath, request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            _logger.error("URISyntaxException: ", (Throwable)e);
            throw new ServletException("URISyntaxException");
        }
        return uri;
    }

    private void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getHeaders("Content-Type")) {
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    private void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration headers = servletRequest.getHeaders("Content-Type");
        while (headers.hasMoreElements()) {
            String headerValue = (String)headers.nextElement();
            proxyRequest.addHeader("Content-Type", headerValue);
        }
    }

    private static long getContentLength(HttpServletRequest request) {
        String contentLengthHeader = request.getHeader("Content-Length");
        try {
            return Long.parseLong(contentLengthHeader);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            try (ServletOutputStream servletOutputStream = servletResponse.getOutputStream();){
                entity.writeTo((OutputStream)servletOutputStream);
            }
        }
    }

    private HttpResponse doExecute(HttpRequest proxyRequest, URI uri) throws IOException {
        CloseableHttpClient proxyClient = this._clientBuilderFactory.getHttpClientBuilder().build();
        return proxyClient.execute(new HttpHost(uri.getHost(), uri.getPort(), "https"), proxyRequest);
    }

    private void retrieveEndpoints() {
        Map endpointsByUri = this._endpointRetriever.getEndpoints();
        HashMap<String, URI> endpointsByHost = new HashMap<String, URI>(endpointsByUri.size());
        for (URI epUri : endpointsByUri.keySet()) {
            endpointsByHost.put(epUri.getHost(), epUri);
        }
        this._endpointsByHost = endpointsByHost;
    }
}

