/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.DatastoreHostsData;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.HostNameData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.SubEntityNameInstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatastoreHostsMetricIdProvider
implements MetricIdProvider {
    private final QueryBindingService _queryBindingService;

    public DatastoreHostsMetricIdProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @Override
    public MetricIdData getMetricIdData(ManagedObjectReference object, List<PerformanceCounter> queriedCounters) {
        DatastoreHostsData dsData = (DatastoreHostsData)this._queryBindingService.prepare(DatastoreHostsData.class).fetch((Object)object);
        HashMap<ManagedObjectReference, String> objectNames = new HashMap<ManagedObjectReference, String>(dsData.hosts.length);
        for (HostNameData hostNameData : dsData.hosts) {
            objectNames.put((ManagedObjectReference)hostNameData.provider, hostNameData.name);
        }
        ArrayList<String> relatedDeviceIds = new ArrayList<String>();
        relatedDeviceIds.add(dsData.getDatastoreVolumeUuid());
        relatedDeviceIds.addAll(dsData.getVmfsDiskNames());
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = this.getQueriedMetrics(objectNames, queriedCounters, relatedDeviceIds);
        result.nameTranslator = new SubEntityNameInstanceNameTranslator(objectNames);
        return result;
    }

    private Map<ManagedObjectReference, List<PerformanceManager.MetricId>> getQueriedMetrics(Map<ManagedObjectReference, String> subEntities, List<PerformanceCounter> allCounters, List<String> allInstances) {
        HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>> queriedMetricIdsByObject = new HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>>(subEntities.size());
        for (ManagedObjectReference subEntity : subEntities.keySet()) {
            ArrayList<PerformanceManager.MetricId> queriedMetrics = new ArrayList<PerformanceManager.MetricId>(allCounters.size());
            for (PerformanceCounter counter : allCounters) {
                for (String instance : allInstances) {
                    PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
                    metricId.counterId = counter.id;
                    metricId.instance = instance;
                    queriedMetrics.add(metricId);
                }
            }
            queriedMetricIdsByObject.put(subEntity, queriedMetrics);
        }
        return queriedMetricIdsByObject;
    }
}

