/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.SiocDatastoreInfoData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.PredefinedInstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class SiocMetricIdProvider
implements MetricIdProvider {
    private static final Log _logger = LogFactory.getLog(SiocMetricIdProvider.class);

    SiocMetricIdProvider() {
    }

    protected MetricIdData getMetricIdData(SiocDatastoreInfoData[] datastores, List<PerformanceCounter> queriedCounters) {
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = this.getQueriedMetrics(datastores, queriedCounters);
        HashMap<String, String> instanceNames = new HashMap<String, String>(datastores.length);
        for (SiocDatastoreInfoData datastore : datastores) {
            instanceNames.put(datastore.getDatastoreVolumeUuid(), datastore.name);
        }
        HashMap<ManagedObjectReference, Map<String, String>> nameTranslatorMap = new HashMap<ManagedObjectReference, Map<String, String>>(result.queriedMetricIds.size());
        for (ManagedObjectReference host : result.queriedMetricIds.keySet()) {
            nameTranslatorMap.put(host, instanceNames);
        }
        result.nameTranslator = new PredefinedInstanceNameTranslator(nameTranslatorMap);
        return result;
    }

    private Map<ManagedObjectReference, List<PerformanceManager.MetricId>> getQueriedMetrics(SiocDatastoreInfoData[] datastores, List<PerformanceCounter> allCounters) {
        Map<String, ManagedObjectReference> hostsByDatastore = this.getHostsByDatastore(datastores);
        HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>> result = new HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>>();
        for (PerformanceCounter counter : allCounters) {
            for (String instance : hostsByDatastore.keySet()) {
                PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
                metricId.counterId = counter.id;
                metricId.instance = instance;
                ManagedObjectReference host = hostsByDatastore.get(instance);
                ArrayList<PerformanceManager.MetricId> queriedMetricsForHost = (ArrayList<PerformanceManager.MetricId>)result.get(host);
                if (queriedMetricsForHost == null) {
                    queriedMetricsForHost = new ArrayList<PerformanceManager.MetricId>();
                    result.put(host, queriedMetricsForHost);
                }
                queriedMetricsForHost.add(metricId);
            }
        }
        return result;
    }

    private Map<String, ManagedObjectReference> getHostsByDatastore(SiocDatastoreInfoData[] datastores) {
        HashMap<String, ManagedObjectReference> result = new HashMap<String, ManagedObjectReference>(datastores.length);
        for (SiocDatastoreInfoData dsInfo : datastores) {
            if (ArrayUtil.isNullOrEmpty((Object[])dsInfo.hosts)) {
                _logger.error((Object)("No hosts for datastore " + dsInfo.name));
                break;
            }
            result.put(dsInfo.getDatastoreVolumeUuid(), dsInfo.hosts[0]);
        }
        return result;
    }
}

