/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceTimeIntervalRetriever;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasePerformanceStats {
    static final String ANY_RELATED_DEVICE_ID = "*";
    static final String HOST_REFERENCE = "";
    private static final String STATS_UNIT_PERCENT = "percent";
    private static final int VALUE_MAX_DECIMAL_POSITIONS = 3;
    private static final int DAY_IN_SECONDS = 86400;
    private static final int SECOND_IN_MILLISECONDS = 1000;
    private static final long DEFAULT_INTERVALS_COUNT = 24L;
    private static final Log _logger = LogFactory.getLog(BasePerformanceStats.class);
    PerformanceInfoQuerySpec originalParams;
    PerformanceManager perfManager;
    List<ManagedObjectReference> moRefs;
    PerformanceCounterProvider counterProvider;
    private HistoricalInterval[] _historicalInterval;

    BasePerformanceStats(List<ManagedObjectReference> moRefs, PerformanceInfoQuerySpec params, PerformanceManager perfMgr, HistoricalInterval[] historicalIntervals, PerformanceCounterProvider counterProvider) {
        this.moRefs = moRefs;
        this.perfManager = perfMgr;
        this._historicalInterval = historicalIntervals;
        this.originalParams = params;
        this.counterProvider = counterProvider;
    }

    public List<PerformanceCounterStats> getStats() {
        Map<ManagedObjectReference, PerformanceManager.QuerySpec> querySpecs = this.prepareQuerySpec();
        List<PerformanceCounterStats> result = this.executeQuery(querySpecs);
        result = this.completeStats(result, querySpecs);
        return result;
    }

    protected abstract Map<ManagedObjectReference, PerformanceManager.QuerySpec> prepareQuerySpec();

    protected abstract List<PerformanceCounterStats> executeQuery(Map<ManagedObjectReference, PerformanceManager.QuerySpec> var1);

    boolean hasMetricIdsItems() {
        return !this.isNullOrEmpty(this.originalParams.metricIds);
    }

    boolean hasCoutnerIdsItems() {
        return !this.isNullOrEmpty(this.originalParams.counterIds);
    }

    PerformanceManager.QuerySpec initBaseQuerySpec(ManagedObjectReference entity) {
        Integer sampleInterval;
        PerformanceManager.QuerySpec querySpec = new PerformanceManager.QuerySpec();
        querySpec.entity = entity;
        if (this.originalParams.format != null) {
            querySpec.setFormat(this.originalParams.format.name());
        }
        PerformanceManager.ProviderSummary summary = PerformanceCounterCollector.getProviderSummary(entity);
        if (this.originalParams.interval == PerformanceMetricTimeIntervals.REALTIME) {
            querySpec.startTime = null;
            querySpec.endTime = null;
            querySpec.intervalId = summary.refreshRate;
            return querySpec;
        }
        HistoricalInterval[] historicalIntervals = this.getHistoricalInterval();
        PerformanceTimeIntervalRetriever intervalRetriever = new PerformanceTimeIntervalRetriever(historicalIntervals, this.originalParams, summary);
        if (intervalRetriever.getStartDate() != null) {
            querySpec.startTime = Calendar.getInstance();
            querySpec.startTime.setTime(intervalRetriever.getStartDate());
        }
        if (intervalRetriever.getEndDate() != null) {
            querySpec.endTime = Calendar.getInstance();
            querySpec.endTime.setTime(intervalRetriever.getEndDate());
        }
        if ((sampleInterval = intervalRetriever.getSampleInterval()) != null && sampleInterval != -1) {
            querySpec.intervalId = intervalRetriever.getSampleInterval();
        }
        return querySpec;
    }

    PerformanceMetricStatValue[] createPerfMetricStatsValues(Date[] samples, long[] metricSeries, String valueStatsUnitKey, boolean isUptimeMetric) {
        int metricSeriesLength;
        ArrayList<PerformanceMetricStatValue> metricStatValues = new ArrayList<PerformanceMetricStatValue>();
        int n = metricSeriesLength = metricSeries != null ? metricSeries.length : 0;
        if (samples.length == metricSeriesLength) {
            for (int i = 0; i < samples.length; ++i) {
                float formattedValue = this.formatMetricValue(metricSeries[i], valueStatsUnitKey, isUptimeMetric);
                PerformanceMetricStatValue metric = BasePerformanceStats.statValue(samples[i], formattedValue);
                metricStatValues.add(metric);
            }
        }
        return metricStatValues.toArray(new PerformanceMetricStatValue[0]);
    }

    private float formatMetricValue(long value, String valueStatsUnitKey, boolean isUptimeMetric) {
        double unformattedResult = value;
        if (STATS_UNIT_PERCENT.equals(valueStatsUnitKey)) {
            unformattedResult = (double)value / 100.0;
        }
        if (isUptimeMetric) {
            unformattedResult = (double)value / 86400.0;
        }
        BigDecimal bd = new BigDecimal(unformattedResult);
        bd.setScale(3, 4);
        float result = bd.floatValue();
        return result;
    }

    private HistoricalInterval[] getHistoricalInterval() {
        if (this._historicalInterval == null) {
            this._historicalInterval = this.perfManager.getHistoricalInterval();
        }
        return this._historicalInterval;
    }

    private List<PerformanceCounterStats> completeStats(List<PerformanceCounterStats> retrievedCounterStats, Map<ManagedObjectReference, PerformanceManager.QuerySpec> querySpecs) {
        for (PerformanceCounterStats singleCounterStats : retrievedCounterStats) {
            PerformanceManager.QuerySpec querySpec = querySpecs.get(singleCounterStats.entity);
            singleCounterStats.interval = this.calculateSampleInterval(singleCounterStats.statistics, querySpec);
            if (singleCounterStats.interval == null) continue;
            singleCounterStats.statistics = this.populateMissingSamples(singleCounterStats.statistics, querySpec, singleCounterStats.interval);
        }
        return retrievedCounterStats;
    }

    private PerformanceMetricStatValue[] populateMissingSamples(PerformanceMetricStatValue[] samples, PerformanceManager.QuerySpec querySpec, long interval) {
        if (this.isNullOrEmpty(samples) || querySpec == null || querySpec.getStartTime() == null || querySpec.getEndTime() == null) {
            return samples;
        }
        ArrayList<PerformanceMetricStatValue> result = new ArrayList<PerformanceMetricStatValue>();
        long queryStartTime = querySpec.getStartTime().getTimeInMillis();
        long queryEndTime = querySpec.getEndTime().getTimeInMillis();
        long firstSampleTime = samples[0].timestamp.getTime();
        for (long timeBeforeFirstSample = firstSampleTime - interval; timeBeforeFirstSample > queryStartTime; timeBeforeFirstSample -= interval) {
            PerformanceMetricStatValue emptyValue = BasePerformanceStats.emptyStatValue(new Date(timeBeforeFirstSample));
            result.add(0, emptyValue);
        }
        for (long lookupDate = firstSampleTime; lookupDate <= queryEndTime; lookupDate += interval) {
            PerformanceMetricStatValue value = this.getSampleForTimestamp(lookupDate, samples);
            result.add(value);
        }
        return result.toArray(new PerformanceMetricStatValue[0]);
    }

    private PerformanceMetricStatValue getSampleForTimestamp(long lookupDate, PerformanceMetricStatValue[] samples) {
        for (PerformanceMetricStatValue sample : samples) {
            if (sample.timestamp.getTime() != lookupDate) continue;
            return sample;
        }
        return BasePerformanceStats.emptyStatValue(new Date(lookupDate));
    }

    private Long calculateSampleInterval(PerformanceMetricStatValue[] samples, PerformanceManager.QuerySpec querySpec) {
        if (querySpec != null && !this.isNullOrEmpty(querySpec.intervalId) && querySpec.intervalId != -1) {
            return (long)querySpec.intervalId.intValue() * 1000L;
        }
        if (!this.isNullOrEmpty(samples) && samples.length >= 2) {
            long firstSampleTime = samples[0].timestamp.getTime();
            long secondSampleTime = samples[1].timestamp.getTime();
            return secondSampleTime - firstSampleTime;
        }
        if (querySpec == null || querySpec.getStartTime() == null || querySpec.getEndTime() == null) {
            return null;
        }
        long queryStartTime = querySpec.getStartTime().getTimeInMillis();
        long queryEndTime = querySpec.getEndTime().getTimeInMillis();
        return (queryEndTime - queryStartTime) / 24L;
    }

    private boolean isNullOrEmpty(Object parameter) {
        if (parameter == null) {
            return true;
        }
        if (parameter instanceof List) {
            return ((List)parameter).size() == 0;
        }
        if (parameter instanceof Object[]) {
            return ((Object[])parameter).length == 0;
        }
        return true;
    }

    void addValuesToResult(PerformanceManager.MetricSeries[] metricSeries, ManagedObjectReference entity, Date[] samples, List<PerformanceCounterStats> result) {
        for (PerformanceManager.MetricSeries metricSerie : metricSeries) {
            long[] values = BasePerformanceStats.extractValues(metricSerie);
            PerformanceCounterStats stats = new PerformanceCounterStats();
            stats.entity = entity;
            stats.performanceCounter = this.counterProvider.findCounterInfo(entity, metricSerie.getId());
            stats.statistics = this.createPerfMetricStatsValues(samples, values, stats.performanceCounter.statsUnitKey, stats.performanceCounter.isUptime);
            result.add(stats);
        }
    }

    static Date[] extractSamples(PerformanceManager.EntityMetricBase entityMetricBase) {
        Date[] samples;
        block4: {
            block3: {
                samples = new Date[]{};
                if (!(entityMetricBase instanceof PerformanceManager.EntityMetric)) break block3;
                PerformanceManager.SampleInfo[] sampleInfos = ((PerformanceManager.EntityMetric)entityMetricBase).getSampleInfo();
                if (sampleInfos == null) break block4;
                samples = new Date[sampleInfos.length];
                for (int sampleIndex = 0; sampleIndex < sampleInfos.length; ++sampleIndex) {
                    samples[sampleIndex] = sampleInfos[sampleIndex].timestamp.getTime();
                }
                break block4;
            }
            if (entityMetricBase instanceof PerformanceManager.EntityMetricCSV) {
                PerformanceManager.EntityMetricCSV entityMetricCsv = (PerformanceManager.EntityMetricCSV)entityMetricBase;
                String[] samplesAsString = entityMetricCsv.getSampleInfoCSV().split(",");
                samples = new Date[samplesAsString.length / 2];
                for (int index = 1; index < samplesAsString.length; index += 2) {
                    samples[index / 2] = DatatypeConverter.parseDateTime((String)samplesAsString[index]).getTime();
                }
            }
        }
        return samples;
    }

    static long[] extractValues(PerformanceManager.MetricSeries metricSerie) {
        long[] values = new long[]{};
        if (metricSerie instanceof PerformanceManager.IntSeries) {
            values = ((PerformanceManager.IntSeries)metricSerie).value;
        } else if (metricSerie instanceof PerformanceManager.MetricSeriesCSV) {
            PerformanceManager.MetricSeriesCSV metricSeriesCSV = (PerformanceManager.MetricSeriesCSV)metricSerie;
            String[] valuesAsString = metricSeriesCSV.getValue().split(",");
            values = new long[valuesAsString.length];
            for (int index = 0; index < valuesAsString.length; ++index) {
                String valueToParse = valuesAsString[index];
                values[index] = StringUtil.isNullOrEmpty((String)valueToParse) ? 0L : Long.parseLong(valueToParse);
            }
        }
        return values;
    }

    private static PerformanceMetricStatValue statValue(Date timeStamp, float value) {
        PerformanceMetricStatValue statValue = new PerformanceMetricStatValue();
        statValue.timestamp = timeStamp;
        statValue.value = value;
        return statValue;
    }

    private static PerformanceMetricStatValue emptyStatValue(Date timeStamp) {
        PerformanceMetricStatValue statValue = new PerformanceMetricStatValue();
        statValue.timestamp = timeStamp;
        statValue.value = -1.0f;
        return statValue;
    }
}

