/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.data.PerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.InstanceNameTranslator;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class PerformanceCounterUtil {
    private static final String GROUP_KEY_SYS = "sys";
    private static final String NAME_KEY_UPTIME = "uptime";
    private static final String STATS_UNIT_KEY_DAYS = "days";
    private static final String STATS_UNIT_NAME_PREFIX = "statsunit.name.";
    private static final String STATS_UNIT_DESC_PREFIX = "statsunit.description.";

    public static List<PerformanceCounter> createCounters(PerformanceManager.CounterInfo[] counterInfos) {
        Validate.notNull((Object)counterInfos);
        ArrayList<PerformanceCounter> result = new ArrayList<PerformanceCounter>(counterInfos.length);
        for (PerformanceManager.CounterInfo ci : counterInfos) {
            result.add(PerformanceCounterUtil.createCounter(ci));
        }
        return result;
    }

    public static List<PerformanceCounter> createCounters(PerformanceManager.MetricId[] metricIds, Map<Integer, PerformanceManager.CounterInfo> counterInfoMap, PerformanceMetricTimeIntervals interval) {
        Validate.notNull((Object)metricIds);
        Validate.notNull(counterInfoMap);
        ArrayList<PerformanceCounter> counters = new ArrayList<PerformanceCounter>(metricIds.length);
        for (PerformanceManager.MetricId metricId : metricIds) {
            PerformanceCounter counter = PerformanceCounterUtil.createCounter(counterInfoMap.get(metricId.counterId), metricId, interval);
            counters.add(counter);
        }
        return counters;
    }

    static PerformanceCounter createCounter(PerformanceManager.CounterInfo counterInfo, String entityName) {
        PerformanceCounter counter = PerformanceCounterUtil.createCounter(counterInfo);
        counter.relatedDeviceId = entityName;
        counter.relatedDeviceName = entityName;
        return counter;
    }

    static List<PerformanceCounter> createCounters(PerformanceManager.MetricId[] metricIds, Map<Integer, PerformanceManager.CounterInfo> counterInfoMap, PerformanceMetricTimeIntervals interval, PerfCounterGroupsData countersData) {
        Validate.notNull((Object)countersData);
        Validate.notNull((Object)metricIds);
        Validate.notNull(counterInfoMap);
        InstanceNameTranslator instanceNameTranslator = new InstanceNameTranslator(countersData);
        ArrayList<PerformanceCounter> counters = new ArrayList<PerformanceCounter>(metricIds.length);
        for (PerformanceManager.MetricId metricId : metricIds) {
            PerformanceCounter counter = PerformanceCounterUtil.createCounter(counterInfoMap.get(metricId.counterId), metricId, interval, instanceNameTranslator);
            counters.add(counter);
        }
        return counters;
    }

    private static PerformanceCounter createCounter(PerformanceManager.CounterInfo counterInfo, PerformanceManager.MetricId metricId, PerformanceMetricTimeIntervals interval, InstanceNameTranslator instanceNameTranslator) {
        Validate.notNull((Object)counterInfo);
        Validate.notNull((Object)metricId);
        PerformanceCounter counter = PerformanceCounterUtil.createCounter(counterInfo);
        counter.interval = interval;
        counter.metricId = metricId;
        counter.relatedDeviceId = metricId.getInstance();
        counter.relatedDeviceName = instanceNameTranslator.getInstanceName(counter);
        return counter;
    }

    private static PerformanceCounter createCounter(PerformanceManager.CounterInfo counterInfo, PerformanceManager.MetricId metricId, PerformanceMetricTimeIntervals interval) {
        Validate.notNull((Object)counterInfo);
        Validate.notNull((Object)metricId);
        PerformanceCounter counter = PerformanceCounterUtil.createCounter(counterInfo);
        counter.interval = interval;
        counter.metricId = metricId;
        counter.relatedDeviceId = metricId.getInstance();
        return counter;
    }

    private static PerformanceCounter createCounter(PerformanceManager.CounterInfo counterInfo) {
        PerformanceCounter counter = new PerformanceCounter();
        counter.id = counterInfo.getKey();
        PerformanceCounterUtil.populateNameAndGroupInfo(counter, counterInfo);
        PerformanceCounterUtil.populateStatsUnitInfo(counter, counterInfo);
        counter.rollupType = counterInfo.getRollupType().name();
        counter.statsType = counterInfo.getStatsType().name();
        counter.level = counterInfo.getLevel();
        return counter;
    }

    private static void populateNameAndGroupInfo(PerformanceCounter counter, PerformanceManager.CounterInfo counterInfo) {
        ElementDescription nameDesc = counterInfo.getNameInfo();
        counter.name = nameDesc.getLabel();
        counter.nameKey = nameDesc.getKey();
        counter.description = nameDesc.getSummary();
        ElementDescription groupDesc = counterInfo.getGroupInfo();
        counter.groupId = groupDesc.getKey();
        counter.groupName = groupDesc.getLabel();
        counter.groupDescription = groupDesc.getSummary();
        counter.isUptime = PerformanceCounterUtil.isUptimeCounter(counter);
    }

    private static boolean isUptimeCounter(PerformanceCounter performanceCounter) {
        return GROUP_KEY_SYS.equals(performanceCounter.groupId) && NAME_KEY_UPTIME.equals(performanceCounter.nameKey);
    }

    private static void populateStatsUnitInfo(PerformanceCounter counter, PerformanceManager.CounterInfo counterInfo) {
        ElementDescription elementDesc = counterInfo.getUnitInfo();
        if (counter.isUptime) {
            counter.statsUnitKey = STATS_UNIT_KEY_DAYS;
            counter.statsUnitName = ResourceUtil.getString((String)"AdvPerfCharts", (String)"statsunit.name.days", (ClassLoader)Constants.class.getClassLoader());
            counter.statsUnitDescription = ResourceUtil.getString((String)"AdvPerfCharts", (String)"statsunit.description.days", (ClassLoader)Constants.class.getClassLoader());
        } else {
            counter.statsUnitKey = elementDesc.getKey();
            counter.statsUnitName = elementDesc.getLabel();
            counter.statsUnitDescription = elementDesc.getSummary();
        }
    }
}

