/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvportgroup.impl;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.dvportgroup.impl.DvPortgroupListCommonData;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupListPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String DVPG_VLAN_LABEL = "portgroupVlanLabel";
    private static final String DVPG_VM_LENGTH_LABEL = "vmLengthLabel";
    private static final String DVPG_PORT_BINDING_LABEL = "portBindingLabel";
    private static final String DVPG_AUTO_EXPAND = "config.autoExpand";
    private static final String DVPG_TYPE = "config.type";
    private static final String DVPG_VLAN = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan";
    private static final String DVPG_DVS = "config.distributedVirtualSwitch";
    private static final String DVPG_VM_LENGTH = "vm._length";
    private static final String DVS_PVLAN_CONFIG = "config[@type='VMwareDVSConfigInfo'].pvlanConfig";
    private static Log _logger = LogFactory.getLog(DvPortgroupListPropertyProviderAdapter.class);
    private final DataService _dataService;

    public DvPortgroupListPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = DistributedVirtualPortgroup.class.getSimpleName();
        ti.properties = new String[]{DVPG_VLAN_LABEL, DVPG_VM_LENGTH_LABEL, DVPG_PORT_BINDING_LABEL};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        Object[] properties = propertyRequest.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objects) || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            return null;
        }
        HashSet<String> reqPropSet = new HashSet<String>();
        for (Object propSpec : properties) {
            if (((PropertySpec)propSpec).propertyNames == null) continue;
            for (String propName : ((PropertySpec)propSpec).propertyNames) {
                reqPropSet.add(propName);
            }
        }
        Object[] queryProps = this.getRequestedQueryProps(reqPropSet);
        ResultSet resultSet = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])queryProps)) {
            try {
                QuerySpec query = QueryUtil.buildQuerySpec((Object[])objects, (String[])queryProps);
                ResultSet pgPropValues = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
                DvPortgroupListCommonData commonData = new DvPortgroupListCommonData();
                this.preprocessPropValues(reqPropSet, pgPropValues, commonData);
                resultSet = this.getResultSet(reqPropSet, pgPropValues, commonData);
            }
            catch (Exception e) {
                resultSet = new ResultSet();
                resultSet.error = e;
            }
        }
        return resultSet;
    }

    private ResultSet getResultSet(Set<String> reqProps, ResultSet propValues, DvPortgroupListCommonData commonData) {
        ResultSet resultSet = new ResultSet();
        if (propValues == null) {
            return resultSet;
        }
        resultSet.error = propValues.error;
        if (ArrayUtil.isNullOrEmpty((Object[])propValues.items)) {
            return resultSet;
        }
        ResultItem[] items = new ResultItem[propValues.items.length];
        for (int i = 0; i < propValues.items.length; ++i) {
            ResultItem ri = propValues.items[i];
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = ri.resourceObject;
            resItem.properties = this.processResultSet(reqProps, ri, commonData);
            items[i] = resItem;
        }
        resultSet.items = items;
        return resultSet;
    }

    private void preprocessPropValues(Set<String> reqProps, ResultSet propValues, DvPortgroupListCommonData commonData) {
        if (propValues == null || propValues.items == null || reqProps == null || commonData == null) {
            return;
        }
        HashSet<ManagedObjectReference> dvsSet = new HashSet<ManagedObjectReference>();
        for (int i = 0; i < propValues.items.length; ++i) {
            ManagedObjectReference dvsRef;
            VmwareDistributedVirtualSwitch.VlanSpec vlanSpec;
            ResultItem ri = propValues.items[i];
            if (!reqProps.contains(DVPG_VLAN_LABEL) || !((vlanSpec = (VmwareDistributedVirtualSwitch.VlanSpec)Util.getPropertyValue(ri, DVPG_VLAN)) instanceof VmwareDistributedVirtualSwitch.PvlanSpec) || (dvsRef = (ManagedObjectReference)Util.getPropertyValue(ri, DVPG_DVS)) == null) continue;
            dvsSet.add(dvsRef);
        }
        if (dvsSet.size() > 0) {
            try {
                QuerySpec query = QueryUtil.buildQuerySpec((Object[])dvsSet.toArray(), (String[])new String[]{DVS_PVLAN_CONFIG});
                ResultSet dvsPropValues = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
                this.buildPvlanMap(dvsPropValues, commonData);
            }
            catch (Exception e) {
                _logger.error((Object)("Failed retrieving PVLAN data: " + e.getLocalizedMessage()));
            }
        }
    }

    private void buildPvlanMap(ResultSet dvsPropValues, DvPortgroupListCommonData commonData) {
        if (dvsPropValues == null || dvsPropValues.items == null || commonData == null) {
            return;
        }
        for (int i = 0; i < dvsPropValues.items.length; ++i) {
            ResultItem ri = dvsPropValues.items[i];
            Object[] pvlanMapEntries = (VmwareDistributedVirtualSwitch.PvlanMapEntry[])Util.getPropertyValue(ri, DVS_PVLAN_CONFIG);
            if (ArrayUtil.isNullOrEmpty((Object[])pvlanMapEntries) || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
            ManagedObjectReference dvsRef = (ManagedObjectReference)ri.resourceObject;
            Map<Integer, VmwareDistributedVirtualSwitch.PvlanMapEntry> pvlanMap = commonData.dvsPvlanMap.get(dvsRef);
            if (pvlanMap == null) {
                pvlanMap = new HashMap<Integer, VmwareDistributedVirtualSwitch.PvlanMapEntry>();
                commonData.dvsPvlanMap.put(dvsRef, pvlanMap);
            }
            for (Object pvlanEntry : pvlanMapEntries) {
                pvlanMap.put(((VmwareDistributedVirtualSwitch.PvlanMapEntry)pvlanEntry).secondaryVlanId, (VmwareDistributedVirtualSwitch.PvlanMapEntry)pvlanEntry);
            }
        }
    }

    private String[] getRequestedQueryProps(Set<String> reqProps) {
        HashSet<String> queryProps = new HashSet<String>();
        if (reqProps.contains(DVPG_VLAN_LABEL)) {
            queryProps.add(DVPG_VLAN);
            queryProps.add(DVPG_DVS);
        }
        if (reqProps.contains(DVPG_VM_LENGTH_LABEL)) {
            queryProps.add(DVPG_VM_LENGTH);
        }
        if (reqProps.contains(DVPG_PORT_BINDING_LABEL)) {
            queryProps.add(DVPG_TYPE);
            queryProps.add(DVPG_AUTO_EXPAND);
        }
        return queryProps.toArray(new String[queryProps.size()]);
    }

    private PropertyValue[] processResultSet(Set<String> reqProps, ResultItem ri, DvPortgroupListCommonData commonData) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(DVPG_PORT_BINDING_LABEL)) {
            this.processPortBinding(ri, results);
        }
        if (reqProps.contains(DVPG_VLAN_LABEL)) {
            this.processVLAN(ri, results, commonData);
        }
        if (reqProps.contains(DVPG_VM_LENGTH_LABEL)) {
            this.processVMLength(ri, results);
        }
        return results.toArray(new PropertyValue[results.size()]);
    }

    private void processPortBinding(ResultItem ri, ArrayList<PropertyValue> propValues) {
        String portBinding = (String)Util.getPropertyValue(ri, DVPG_TYPE);
        Boolean autoExpand = (Boolean)Util.getPropertyValue(ri, DVPG_AUTO_EXPAND);
        propValues.add(ResultUtil.newProperty((String)DVPG_PORT_BINDING_LABEL, (Object)Util.formatPortGroupType(portBinding, autoExpand), (Object)ri.resourceObject));
    }

    private void processVLAN(ResultItem ri, ArrayList<PropertyValue> propValues, DvPortgroupListCommonData commonData) {
        Map<Integer, VmwareDistributedVirtualSwitch.PvlanMapEntry> pvlanMap;
        VmwareDistributedVirtualSwitch.VlanSpec vlanSpec = (VmwareDistributedVirtualSwitch.VlanSpec)Util.getPropertyValue(ri, DVPG_VLAN);
        ManagedObjectReference dvsRef = (ManagedObjectReference)Util.getPropertyValue(ri, DVPG_DVS);
        String vlanLabel = Util.getLocalizedString("noData");
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec;
            vlanLabel = String.format(Util.getLocalizedString("dvPortGroup.list.vlan.access"), vlanIdSpec.vlanId);
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            VmwareDistributedVirtualSwitch.TrunkVlanSpec vlanTrunkSpec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec;
            vlanLabel = String.format(Util.getLocalizedString("dvPortGroup.list.vlan.trunk"), Util.formatVlanTrunkRange(vlanTrunkSpec.vlanId));
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec && commonData != null && (pvlanMap = commonData.dvsPvlanMap.get(dvsRef)) != null) {
            VmwareDistributedVirtualSwitch.PvlanSpec pvlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)vlanSpec;
            VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanEntry = pvlanMap.get(pvlanSpec.pvlanId);
            vlanLabel = Util.formatPvlanEntry(pvlanEntry, Util.getLocalizedString("dvPortGroup.list.pvlan.format"));
        }
        propValues.add(ResultUtil.newProperty((String)DVPG_VLAN_LABEL, (Object)vlanLabel, (Object)ri.resourceObject));
    }

    private void processVMLength(ResultItem ri, ArrayList<PropertyValue> propValues) {
        propValues.add(ResultUtil.newProperty((String)DVPG_VM_LENGTH_LABEL, Util.getPropertyValue(ri, DVPG_VM_LENGTH), (Object)ri.resourceObject));
    }
}

