/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.ports;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvs.api.spec.GenericVlanSpec;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.ports.DistributedVirtualPortState;
import com.vmware.vsphere.client.dvs.ports.FetchedProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

enum ComputedProperties {
    portgroupName{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            Map<String, List<ResultItem>> keys = this.parsePortgroupKeys(items, propertyIndices.get((Object)FetchedProperties.portgroupKey));
            ResultSet result = this.fetchPortgroupNames(keys, dvsRef, dataService);
            this.assignPortgroupNames(keys, result, items, currentIndex);
        }

        private Map<String, List<ResultItem>> parsePortgroupKeys(ResultItem[] items, int propertyIndex) {
            HashMap<String, List<ResultItem>> result = new HashMap<String, List<ResultItem>>();
            for (ResultItem item : items) {
                PropertyValue pValue = item.properties[propertyIndex];
                String pgKey = (String)pValue.value;
                if (StringUtil.isNullOrEmpty((String)pgKey)) continue;
                if (!result.containsKey(pgKey)) {
                    result.put(pgKey, new ArrayList());
                }
                ((List)result.get(pgKey)).add(item);
            }
            return result;
        }

        private ResultSet fetchPortgroupNames(Map<String, List<ResultItem>> portgroupKeys, ManagedObjectReference dvsRef, DataService dataService) throws Exception {
            String[] pgKeys = portgroupKeys.keySet().toArray(new String[portgroupKeys.keySet().size()]);
            CompositeConstraint cc = new CompositeConstraint();
            cc.conjoiner = Conjoiner.OR;
            cc.nestedConstraints = new Constraint[pgKeys.length];
            for (int i = 0; i < pgKeys.length; ++i) {
                cc.nestedConstraints[i] = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"key", (Comparator)Comparator.EQUALS, (Object)pgKeys[i]);
            }
            PropertySpec ps = new PropertySpec();
            ps.propertyNames = new String[]{"key", "name"};
            ps.type = DistributedVirtualPortgroup.class.getSimpleName();
            CompositeConstraint topcc = new CompositeConstraint();
            topcc.conjoiner = Conjoiner.AND;
            topcc.nestedConstraints = new Constraint[2];
            topcc.nestedConstraints[0] = cc;
            topcc.nestedConstraints[1] = QueryUtil.createRelationalConstraint((String)"portgroup", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)dvsRef), (Boolean)true, (String)dvsRef.getType());
            ResourceSpec rs = new ResourceSpec();
            rs.constraint = topcc;
            rs.propertySpecs = new PropertySpec[]{ps};
            QuerySpec qs = new QuerySpec();
            qs.resourceSpec = rs;
            return QueryUtil.getData((DataService)dataService, (QuerySpec)qs);
        }

        private void assignPortgroupNames(Map<String, List<ResultItem>> portgroupKeys, ResultSet resultSet, ResultItem[] items, int currentIndex) {
            if (resultSet != null && resultSet.items != null && resultSet.error == null) {
                for (ResultItem pgItem : resultSet.items) {
                    String pgKey = (String)this.getPropertyValueByName((String)"key", (ResultItem)pgItem).value;
                    String pgName = (String)this.getPropertyValueByName((String)"name", (ResultItem)pgItem).value;
                    for (ResultItem item : portgroupKeys.get(pgKey)) {
                        item.properties[currentIndex].value = pgName;
                    }
                }
            }
        }

        private PropertyValue getPropertyValueByName(String propertyName, ResultItem item) {
            PropertyValue result = null;
            for (PropertyValue pv : item.properties) {
                if (!propertyName.equals(pv.propertyName)) continue;
                result = pv;
                break;
            }
            return result;
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.portgroupKey};
        }
    }
    ,
    connectedEntityName{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            ComputedPropertiesUtil.singlePropertyProcess("name", this.requiredProperties()[0], dataService, items, propertyIndices, currentIndex, dvsRef);
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.connectedEntityReference};
        }
    }
    ,
    proxyHostName{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            ComputedPropertiesUtil.singlePropertyProcess("name", this.requiredProperties()[0], dataService, items, propertyIndices, currentIndex, dvsRef);
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.proxyHost};
        }
    }
    ,
    portState{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) {
            for (ResultItem item : items) {
                Boolean cfBlocked = (Boolean)item.properties[propertyIndices.get((Object)((Object)FetchedProperties.configSettingBlocked)).intValue()].value;
                Boolean rtBlocked = (Boolean)item.properties[propertyIndices.get((Object)((Object)FetchedProperties.stateRuntimeBlocked)).intValue()].value;
                Boolean rtLinkUp = (Boolean)item.properties[propertyIndices.get((Object)((Object)FetchedProperties.stateRuntimeLinkUp)).intValue()].value;
                DistributedVirtualPortState result = cfBlocked == null || rtBlocked == null || rtLinkUp == null ? DistributedVirtualPortState.NO_DATA : (cfBlocked != false || rtBlocked != false ? DistributedVirtualPortState.BLOCKED : (rtLinkUp != false ? DistributedVirtualPortState.LINK_UP : DistributedVirtualPortState.LINK_DOWN));
                item.properties[currentIndex].value = result.toString();
            }
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.configSettingBlocked, FetchedProperties.stateRuntimeBlocked, FetchedProperties.stateRuntimeLinkUp};
        }
    }
    ,
    vlanInfo{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanEntries = DvsUtil.getPvlanConfig(dataService, dvsRef);
            for (ResultItem item : items) {
                VmwareDistributedVirtualSwitch.VlanSpec spec = (VmwareDistributedVirtualSwitch.VlanSpec)item.properties[propertyIndices.get((Object)((Object)FetchedProperties.vmwareVlanSpec)).intValue()].value;
                GenericVlanSpec genericSpec = new GenericVlanSpec();
                genericSpec.vlanSpec = spec;
                if (spec instanceof VmwareDistributedVirtualSwitch.PvlanSpec && pvlanEntries != null && pvlanEntries.length > 0) {
                    for (VmwareDistributedVirtualSwitch.PvlanMapEntry entry : pvlanEntries) {
                        if (entry.secondaryVlanId != ((VmwareDistributedVirtualSwitch.PvlanSpec)spec).pvlanId) continue;
                        genericSpec.matchingPvlanMapEntry = entry;
                        break;
                    }
                }
                item.properties[currentIndex].value = genericSpec;
            }
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.vmwareVlanSpec};
        }
    }
    ,
    lagKey{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            Map searchMap = ComputedProperties.createLagByPortKeySearchMap(dvsRef, dataService);
            Integer keyIdx = propertyIndices.get((Object)FetchedProperties.key);
            for (ResultItem item : items) {
                String portKey = (String)item.properties[keyIdx.intValue()].value;
                VmwareDistributedVirtualSwitch.LacpGroupConfig lag = (VmwareDistributedVirtualSwitch.LacpGroupConfig)searchMap.get(portKey);
                item.properties[currentIndex].value = lag == null ? null : lag.key;
            }
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.key};
        }
    }
    ,
    lagName{

        @Override
        void process(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            Map searchMap = ComputedProperties.createLagByPortKeySearchMap(dvsRef, dataService);
            Integer keyIdx = propertyIndices.get((Object)FetchedProperties.key);
            for (ResultItem item : items) {
                String portKey = (String)item.properties[keyIdx.intValue()].value;
                VmwareDistributedVirtualSwitch.LacpGroupConfig lag = (VmwareDistributedVirtualSwitch.LacpGroupConfig)searchMap.get(portKey);
                item.properties[currentIndex].value = lag == null ? null : lag.name;
            }
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.key};
        }
    };


    abstract void process(DataService var1, ResultItem[] var2, Map<FetchedProperties, Integer> var3, int var4, ManagedObjectReference var5) throws Exception;

    abstract FetchedProperties[] requiredProperties();

    final PropertyValue getPropertyValue(ResultItem item) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = item.resourceObject;
        pv.propertyName = this.toString();
        pv.value = null;
        return pv;
    }

    private static Map<String, VmwareDistributedVirtualSwitch.LacpGroupConfig> createLagByPortKeySearchMap(ManagedObjectReference dvsRef, DataService dataService) throws Exception {
        VmwareDistributedVirtualSwitch.LacpGroupConfig[] lags = (VmwareDistributedVirtualSwitch.LacpGroupConfig[])QueryUtil.getProperty((DataService)dataService, (Object)dvsRef, (String)"config[@type='VMwareDVSConfigInfo'].lacpGroupConfig");
        HashMap<String, VmwareDistributedVirtualSwitch.LacpGroupConfig> results = new HashMap<String, VmwareDistributedVirtualSwitch.LacpGroupConfig>();
        if (lags != null) {
            for (VmwareDistributedVirtualSwitch.LacpGroupConfig lag : lags) {
                if (lag.uplinkPortKey == null) continue;
                for (String portKey : lag.uplinkPortKey) {
                    if (portKey == null) continue;
                    results.put(portKey, lag);
                }
            }
        }
        return results;
    }

    private static class ComputedPropertiesUtil {
        private ComputedPropertiesUtil() {
        }

        static void singlePropertyProcess(String propertyName, FetchedProperties fetchedProperty, DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, int currentIndex, ManagedObjectReference dvsRef) throws Exception {
            Map<ManagedObjectReference, List<ResultItem>> data2 = ComputedPropertiesUtil.parseConnectees(items, propertyIndices.get((Object)fetchedProperty));
            ResultSet result = ComputedPropertiesUtil.getNames(propertyName, data2.keySet(), dataService);
            if (result != null) {
                ComputedPropertiesUtil.assignNames(data2, result, currentIndex);
            }
        }

        private static Map<ManagedObjectReference, List<ResultItem>> parseConnectees(ResultItem[] items, int propertyIndex) {
            HashMap<ManagedObjectReference, List<ResultItem>> result = new HashMap<ManagedObjectReference, List<ResultItem>>();
            for (ResultItem item : items) {
                PropertyValue pValue = item.properties[propertyIndex];
                if (pValue.value == null) continue;
                if (!result.containsKey((ManagedObjectReference)pValue.value)) {
                    result.put((ManagedObjectReference)pValue.value, new ArrayList());
                }
                ((List)result.get((ManagedObjectReference)pValue.value)).add(item);
            }
            return result;
        }

        private static ResultSet getNames(String requestedProperty, Set<ManagedObjectReference> references, DataService dataService) throws Exception {
            if (references != null && references.size() > 0) {
                ManagedObjectReference[] mors = references.toArray(new ManagedObjectReference[references.size()]);
                CompositeConstraint cc = new CompositeConstraint();
                cc.conjoiner = Conjoiner.OR;
                cc.nestedConstraints = new Constraint[mors.length];
                for (int i = 0; i < mors.length; ++i) {
                    cc.nestedConstraints[i] = QueryUtil.createObjectIdentityConstraint((Object)mors[i]);
                }
                PropertySpec ps = new PropertySpec();
                ps.propertyNames = new String[]{requestedProperty};
                ResourceSpec rs = new ResourceSpec();
                rs.constraint = cc;
                rs.propertySpecs = new PropertySpec[]{ps};
                QuerySpec qs = new QuerySpec();
                qs.resourceSpec = rs;
                return QueryUtil.getData((DataService)dataService, (QuerySpec)qs);
            }
            return null;
        }

        private static void assignNames(Map<ManagedObjectReference, List<ResultItem>> data2, ResultSet result, int currentIndex) {
            if (result != null && result.items != null && result.error == null) {
                for (ResultItem resultItem : result.items) {
                    ManagedObjectReference provider = (ManagedObjectReference)resultItem.properties[0].resourceObject;
                    String name = (String)resultItem.properties[0].value;
                    for (ResultItem item : data2.get(provider)) {
                        item.properties[currentIndex].value = name;
                    }
                }
            }
        }
    }
}

