/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.commands;

import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.network.host.api.spec.UpdateHostRoutingCommandSpec;

public class UpdateHostRoutingCommand
extends FutureCommand {
    public UpdateHostRoutingCommand(UpdateHostRoutingCommandSpec spec) {
        this.setCommandSpec((BaseCommandSpec)spec);
    }

    protected ClientFutureImpl<?> launch() throws Exception {
        UpdateHostRoutingCommandSpec spec = (UpdateHostRoutingCommandSpec)this.getCommandSpec();
        NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.networkSystemRef);
        if (spec.netStackInstance != null) {
            ClientFutureImpl updateNetworkConfigFuture = new ClientFutureImpl();
            NetworkConfig networkConfig = new NetworkConfig();
            NetworkConfig.NetStackSpec netStackSpec = new NetworkConfig.NetStackSpec();
            netStackSpec.operation = ConfigSpecOperation.edit.toString();
            netStackSpec.netStackInstance = spec.netStackInstance;
            networkConfig.netStackSpec = new NetworkConfig.NetStackSpec[]{netStackSpec};
            networkSystem.updateNetworkConfig(networkConfig, ConfigChange.Mode.modify.toString(), (Future)updateNetworkConfigFuture);
            return updateNetworkConfigFuture;
        }
        if (spec.ipRouteConfig != null) {
            ClientFutureImpl updateIpRouteConfigFuture = new ClientFutureImpl();
            networkSystem.updateIpRouteConfig(spec.ipRouteConfig, (Future)updateIpRouteConfigFuture);
            return updateIpRouteConfigFuture;
        }
        return null;
    }
}

