/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.iscsi.impl;

import com.vmware.vim.binding.vim.fault.IscsiFaultVnicInUse;
import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;

public class IscsiDependencyPropertyProvider
implements PropertyProviderBean {
    private DataService _dataService;

    public IscsiDependencyPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public MethodFault[] getIscsiDependencies(ManagedObjectReference hostRef, String vnicDevice) throws Exception {
        ManagedObjectReference iscsiMangerObjref = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"iscsiManager");
        if (iscsiMangerObjref == null) {
            return new MethodFault[0];
        }
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiMangerObjref);
        if (iscsiManager == null) {
            return new MethodFault[0];
        }
        IscsiManager.IscsiStatus iscsiPortInfoObjects = iscsiManager.queryVnicStatus(vnicDevice);
        if (iscsiPortInfoObjects == null || iscsiPortInfoObjects.reason == null || iscsiPortInfoObjects.reason.length == 0) {
            return new MethodFault[0];
        }
        Exception[] temp = iscsiPortInfoObjects.reason;
        MethodFault[] res = new MethodFault[temp.length];
        boolean isVirtualNicPortBound = false;
        for (int i = 0; i < temp.length; ++i) {
            res[i] = (MethodFault)temp[i];
            if (!(temp[i] instanceof IscsiFaultVnicInUse)) continue;
            isVirtualNicPortBound = true;
        }
        return isVirtualNicPortBound ? res : new MethodFault[]{};
    }
}

