/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networkselector;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NetworkSelectorUtil {
    public static final String IS_UPLINK_PORT_GROUP_PROPERTY = "isUplinkPortgroup";
    public static final String PORT_GROUP_TYPE_PROPERTY = "config.type";
    private static final String HOST_NETWORK_RELATION = "standardnetwork";
    private static final String HOST_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String HOST_DV_PORT_GROUP_RELATION = "dvpg";
    private static final String DVS_DV_PORT_GROUP_RELATION = "portgroup";
    private static final String VM_NETWORK_RELATION = "standardnetwork";
    private static final String VM_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String VM_DV_PORT_GROUP_RELATION = "dvPortGroup";
    private static final String DC_NETWORK_RELATION = "standardnetwork";
    private static final String DC_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String DC_DV_PORT_GROUP_RELATION = "dvpg";
    private static final String NW_FOLDER_NETWORK_RELATION = "allstandardnetwork";
    private static final String NW_FOLDER_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String NW_FOLDER_PORT_GROUP_RELATION = "alldvpg";
    private static final String CLUSTER_NETWORK_RELATION = "standardnetwork";
    private static final String CLUSTER_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String CLUSTER_DV_PORT_GROUP_RELATION = "pg";
    private static final char OPAQUE_NETWORK_KEY_DELIMITER = '/';
    private static final String ALL_NETWORKS_RELATION = "allNetwork";
    private static Log _logger = LogFactory.getLog(NetworkSelectorUtil.class);

    public static Constraint createConstraintForAllNetworks(Object target) {
        ManagedObjectReference moRef;
        Validate.notNull((Object)target);
        String relation = ALL_NETWORKS_RELATION;
        if (target instanceof ManagedObjectReference && (ManagedObjectUtil.isOfType((ManagedObjectReference)(moRef = (ManagedObjectReference)target), DistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VmwareDistributedVirtualSwitch.class))) {
            relation = DVS_DV_PORT_GROUP_RELATION;
        }
        return QueryUtil.createConstraintForRelationship((Object)target, (String)relation, (String)target.getClass().getSimpleName());
    }

    public static Constraint createConstraintForNetworks(Object[] networks) {
        CompositeConstraint resultConstraint = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])networks)) {
            ArrayList<ObjectIdentityConstraint> nestedConstraints = new ArrayList<ObjectIdentityConstraint>();
            for (Object mor : networks) {
                ObjectIdentityConstraint oic = QueryUtil.createObjectIdentityConstraint((Object)mor);
                nestedConstraints.add(oic);
            }
            resultConstraint = new CompositeConstraint();
            resultConstraint.nestedConstraints = nestedConstraints.toArray(new Constraint[nestedConstraints.size()]);
            resultConstraint.conjoiner = Conjoiner.OR;
        }
        return resultConstraint;
    }

    public static Constraint createConstraintForStandardNetworks(Object target) {
        Constraint relationalConstraint = null;
        if (!(target instanceof ManagedObjectReference)) {
            _logger.error((Object)"target type is not supported!");
            return null;
        }
        relationalConstraint = NetworkSelectorUtil.createConstraintForStandardNetworksByMor((ManagedObjectReference)target);
        return NetworkSelectorUtil.wrapWithTypeConstraint(relationalConstraint, Network.class.getSimpleName());
    }

    public static Constraint wrapWithTypeConstraint(Constraint constraint, String type2) {
        Constraint typeConstraint = new Constraint();
        typeConstraint.targetType = type2;
        return QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{constraint, typeConstraint}, (Conjoiner)Conjoiner.AND);
    }

    public static Constraint createConstraintForOpaqueNetworks(Object target) {
        Constraint relationalConstraint = null;
        if (!(target instanceof ManagedObjectReference)) {
            _logger.error((Object)"target type is not supported!");
            return null;
        }
        relationalConstraint = NetworkSelectorUtil.createConstraintForOpaqueNetworksByMor((ManagedObjectReference)target);
        return NetworkSelectorUtil.wrapWithTypeConstraint(relationalConstraint, OpaqueNetwork.class.getSimpleName());
    }

    private static Constraint createConstraintForStandardNetworksByMor(ManagedObjectReference mor) {
        if (mor == null) {
            return null;
        }
        String relation = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, HostSystem.class)) {
            relation = "standardnetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, VirtualMachine.class)) {
            relation = "standardnetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Datacenter.class)) {
            relation = "standardnetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Folder.class)) {
            relation = NW_FOLDER_NETWORK_RELATION;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, ClusterComputeResource.class)) {
            relation = "standardnetwork";
        }
        return QueryUtil.createConstraintForRelationship((Object)mor, (String)relation, (String)Network.class.getSimpleName());
    }

    private static Constraint createConstraintForOpaqueNetworksByMor(ManagedObjectReference target) {
        if (target == null) {
            return null;
        }
        String relation = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, HostSystem.class)) {
            relation = "opaquenetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualMachine.class)) {
            relation = "opaquenetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Datacenter.class)) {
            relation = "opaquenetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Folder.class)) {
            relation = "opaquenetwork";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class)) {
            relation = "opaquenetwork";
        }
        return QueryUtil.createConstraintForRelationship((Object)target, (String)relation, (String)OpaqueNetwork.class.getSimpleName());
    }

    public static Constraint createConstraintForDistributedPortGroups(Object target) {
        Constraint relationalConstraint = null;
        if (!(target instanceof ManagedObjectReference)) {
            _logger.error((Object)"target type is not supported!");
            return null;
        }
        relationalConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroupsByMor((ManagedObjectReference)target);
        return relationalConstraint;
    }

    public static Constraint createConstraintForDistributedPortGroups(Object target, boolean isUplink) {
        Constraint distributedPortGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target);
        PropertyConstraint isUplinkConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)IS_UPLINK_PORT_GROUP_PROPERTY, (Comparator)Comparator.EQUALS, (Object)isUplink);
        CompositeConstraint resultConstraint = new CompositeConstraint();
        resultConstraint.conjoiner = Conjoiner.AND;
        resultConstraint.nestedConstraints = new Constraint[]{distributedPortGroupsConstraint, isUplinkConstraint};
        resultConstraint.targetType = DistributedVirtualPortgroup.class.getSimpleName();
        return resultConstraint;
    }

    private static Constraint createConstraintForDistributedPortGroupsByMor(ManagedObjectReference mor) {
        if (mor == null) {
            return null;
        }
        String relation = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, HostSystem.class)) {
            relation = "dvpg";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, DistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)mor, VmwareDistributedVirtualSwitch.class)) {
            relation = DVS_DV_PORT_GROUP_RELATION;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, VirtualMachine.class)) {
            relation = VM_DV_PORT_GROUP_RELATION;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Datacenter.class)) {
            relation = "dvpg";
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Folder.class)) {
            relation = NW_FOLDER_PORT_GROUP_RELATION;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, ClusterComputeResource.class)) {
            relation = CLUSTER_DV_PORT_GROUP_RELATION;
        }
        return QueryUtil.createConstraintForRelationship((Object)mor, (String)relation, (String)DistributedVirtualPortgroup.class.getSimpleName());
    }

    public static QuerySpec createEmptyQuerySpecForConstraint(Constraint constraint) {
        QuerySpec query = new QuerySpec();
        query.resourceSpec = QueryUtil.createEmptyResourceSpec();
        query.resourceSpec.constraint = constraint;
        return query;
    }

    public static QuerySpec createPortgroupTypeQuerySpec(Constraint constraint) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = DistributedVirtualPortgroup.class.getSimpleName();
        propertySpec.propertyNames = new String[]{IS_UPLINK_PORT_GROUP_PROPERTY, PORT_GROUP_TYPE_PROPERTY};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        querySpec.resourceSpec.constraint = constraint;
        return querySpec;
    }

    public static String convertArrayToString(String[] arr, String delimiter) {
        if (ArrayUtil.isNullOrEmpty((Object[])arr)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length - 1; ++i) {
            sb.append(arr[i]);
            sb.append(delimiter);
        }
        sb.append(arr[arr.length - 1]);
        return sb.toString();
    }

    public static ManagedObjectReference[] getMorsOfType(Object[] mors, String type2) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])mors)) {
            for (Object obj : mors) {
                ManagedObjectReference mor;
                if (!(obj instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)(mor = (ManagedObjectReference)obj), (String)type2)) continue;
                result.add(mor);
            }
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    public static ManagedObjectReference[] getEntitiesOfType(ResultItem[] networks, String type2) {
        if (networks == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> entities = new ArrayList<ManagedObjectReference>();
        for (ResultItem item : networks) {
            ManagedObjectReference entityMor;
            if (item == null || !(item.resourceObject instanceof ManagedObjectReference) || !(entityMor = (ManagedObjectReference)item.resourceObject).getType().equals(type2)) continue;
            entities.add(entityMor);
        }
        return entities.toArray(new ManagedObjectReference[entities.size()]);
    }

    public static String getOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        if (StringUtil.isNullOrEmpty((String)opaqueNetworkId) || StringUtil.isNullOrEmpty((String)opaqueNetworkType)) {
            throw new IllegalArgumentException("Empty opaque network id/type detected.");
        }
        return new StringBuilder(opaqueNetworkType.length() + opaqueNetworkId.length() + 1).append(opaqueNetworkType).append('/').append(opaqueNetworkId).toString();
    }

    public static String getOpaqueNetworkKey(VirtualEthernetCard.OpaqueNetworkBackingInfo infp) {
        return NetworkSelectorUtil.getOpaqueNetworkKey(infp.opaqueNetworkId, infp.opaqueNetworkType);
    }
}

