/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.exception;

import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vsphere.client.sso.admin.exception.SsoPermissionException;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;

public abstract class BackendExceptionTransformer {
    private static final String PERMISSION_ERROR_MESSAGE = "sso.admin.NoPermission";
    private BackendExceptionTransformer nextTransformer;

    public void setSpecificTransformer(BackendExceptionTransformer transformer) {
        this.nextTransformer = transformer;
    }

    public Exception transformException(Exception exception) {
        Exception result = null;
        if (exception instanceof NoPermission) {
            return new SsoPermissionException(SsoAdminUtil.getString(PERMISSION_ERROR_MESSAGE, new String[0]));
        }
        if (this.nextTransformer != null) {
            result = this.nextTransformer.transform(exception);
        }
        if (result == null) {
            return this.transform(exception);
        }
        return result;
    }

    protected abstract Exception transform(Exception var1);
}

