/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.exception;

import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.exception.SsoBackendException;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypedExceptionTransformer
extends BackendExceptionTransformer {
    private static final Log _logger = LogFactory.getLog(TypedExceptionTransformer.class);
    private static final String TRANSLATION_DOMAIN_PREFIX = "sso.admin.";
    private static final String CODE_DOMAIN = "com.vmware.vsphere.client";

    @Override
    public Exception transform(Exception exception) {
        String message = null;
        if (exception.getStackTrace().length > 0) {
            StringBuffer messageKey = new StringBuffer();
            messageKey.append(TRANSLATION_DOMAIN_PREFIX);
            messageKey.append(exception.getClass().getSimpleName());
            for (StackTraceElement element : exception.getStackTrace()) {
                if (!element.getClassName().contains(CODE_DOMAIN)) continue;
                messageKey.append(".").append(element.getMethodName());
                break;
            }
            if ((message = SsoAdminUtil.getString(messageKey.toString(), new String[0])).equals(messageKey.toString())) {
                message = null;
            }
        }
        if (message == null) {
            StringBuffer messageCode = new StringBuffer();
            messageCode.append(TRANSLATION_DOMAIN_PREFIX);
            messageCode.append(exception.getClass().getSimpleName());
            message = SsoAdminUtil.getString(messageCode.toString(), new String[0]);
            if (message.equals(messageCode.toString())) {
                message = null;
            }
        }
        if (message == null) {
            _logger.debug((Object)"Unable to provide error message", (Throwable)exception);
            return null;
        }
        SsoBackendException newException = new SsoBackendException(message);
        return newException;
    }
}

