/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AdminServiceBase {
    private static final String SSO_ADMIN_SERVICE_KEY = "ssoAdminService";
    private static final String SSO_SOLUTION_USER_ADMIN_SERVICE_KEY = "ssoSolutionUserAdminService";
    private static final String SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY = "ssoAdminServiceSyncObject";
    private SsoService _ssoService;
    private SsoServiceManager _ssoServiceManager;
    private SsoServerInfo _ssoServerInfo;
    private Boolean _useSolutionUser = false;
    private SsoAdminService _presetAdminService = null;
    private BackendExceptionTransformer _exceptionTransformer;

    public AdminServiceBase(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        Validate.notNull((Object)ssoServiceManager, (String)"ssoService is null");
        Validate.notNull((Object)ssoServiceManager, (String)"ssoServiceManager is null");
        Validate.notNull((Object)transformer, (String)"transformer is null");
        this._ssoService = ssoService;
        this._ssoServiceManager = ssoServiceManager;
        this._exceptionTransformer = transformer;
    }

    public AdminServiceBase(SsoAdminService presetAdminService) {
        this._presetAdminService = presetAdminService;
    }

    public AdminServiceBase(SsoService ssoService, SsoServiceManager ssoServiceManager, Boolean useSolutionUser, BackendExceptionTransformer transformer) {
        this(ssoService, ssoServiceManager, transformer);
        this._useSolutionUser = useSolutionUser;
    }

    protected Exception transformBackendException(Exception exception) {
        return this._exceptionTransformer.transformException(exception);
    }

    protected SsoServerInfo getSsoServerInfo() throws SsoServiceException {
        if (this._ssoServerInfo == null) {
            try {
                this._ssoServerInfo = this._ssoService.getServerInfo();
            }
            catch (Exception ex) {
                throw new SsoServiceException((Throwable)ex);
            }
        }
        return this._ssoServerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SsoAdminService getAdminService(HttpSession session) throws SsoServiceException {
        Object syncObj;
        if (this._presetAdminService != null) {
            return this._presetAdminService;
        }
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        Object object = syncObj = SessionUtil.getSyncObject((String)SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY, (HttpSession)session);
        synchronized (object) {
            String sessionKey = this.getSessionKey();
            SsoAdminService srv = (SsoAdminService)SessionUtil.getData((String)sessionKey);
            if (srv == null) {
                srv = this._useSolutionUser != false ? this._ssoServiceManager.getSolutionAdminService(null, SsoDomain.getLocal()) : this._ssoServiceManager.getAdminService(null, SsoDomain.getLocal());
            }
            return srv;
        }
    }

    protected String getSessionKey() {
        return this._useSolutionUser != false ? SSO_SOLUTION_USER_ADMIN_SERVICE_KEY : SSO_ADMIN_SERVICE_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseResources(HttpSession session) throws SsoServiceException {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            for (String key : new String[]{SSO_ADMIN_SERVICE_KEY, SSO_SOLUTION_USER_ADMIN_SERVICE_KEY}) {
                SsoAdminService srv = (SsoAdminService)SessionUtil.getData((String)key);
                if (srv == null) continue;
                srv.logout();
                SessionUtil.removeData((String)key, (HttpSession)session);
            }
        }
    }
}

