/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.sso.admin.SsoException;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.FindDomainUserSpec;
import java.net.URI;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrincipalManagerPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(PrincipalManagerPropertyProvider.class);
    private final PrincipalManagementServiceImpl _principalManagementService;

    public PrincipalManagerPropertyProvider(SsoService ssoService, PrincipalManagementServiceImpl managementService) {
        _logger.debug((Object)"instantiated");
        this._principalManagementService = managementService;
    }

    @ModelMetadata(type={"sso:PrincipalManager"}, property="userSsoGroups")
    public String[] getUserSsoGroups(URI principalManager, PrincipalId pid) throws SsoException {
        Set currentGroups = SsoUtil.getGroups();
        if (currentGroups == null || currentGroups.size() == 0) {
            return new String[0];
        }
        return currentGroups.toArray(new String[currentGroups.size()]);
    }

    @ModelMetadata(type={"sso:PrincipalManager"}, property="vsphere:domainUsers")
    public PersonUser[] getLocalSsoUsers(Object object, FindDomainUserSpec spec) throws SsoException {
        try {
            return this._principalManagementService.findUsers(spec.domainName, spec.criteria);
        }
        catch (Exception e) {
            _logger.error((Object)("Error while extracting local SSO users with spec :\n" + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            throw new SsoException("Error while extracting local SSO users", e);
        }
    }

    @ModelMetadata(type={"sso:PrincipalManager"}, property="vsphere:selfPasswordExpiration")
    public int getSelfPasswordExpiration(Object object) {
        try {
            return this._principalManagementService.getSelfPasswordExpiration();
        }
        catch (Exception e) {
            _logger.error((Object)"Not able to password expiration info for current user", (Throwable)e);
            return -1;
        }
    }
}

