/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.vim.UserSearchResult;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.users.DomainSearchResult;
import com.vmware.vise.vim.users.UserDirectorySpec;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.LocalOSDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoUserDirectoryPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(SsoUserDirectoryPropertyProvider.class);
    private SsoServiceManager _ssoMgr = null;

    public SsoUserDirectoryPropertyProvider(SsoServiceManager ssoServiceManager) {
        this._ssoMgr = ssoServiceManager;
    }

    @ModelMetadata(type={"*"}, property="vsphere:domainList")
    public DomainSearchResult[] getDomainList(Object object) throws Exception {
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, SsoDomain.getLocal());
        IdentitySourceDomainManagementService domainMgmt = new IdentitySourceDomainManagementService(adminService);
        List<DomainSpec> domains = domainMgmt.getDomains();
        ArrayList<DomainSearchResult> domainList = new ArrayList<DomainSearchResult>();
        for (DomainSpec domain : domains) {
            DomainSearchResult dsr = new DomainSearchResult(domain.domainName);
            if (domain instanceof ExternalDomainSpec || domain instanceof NativeAdDomainSpec) {
                dsr.isSystem = false;
            } else if (domain instanceof LocalOSDomainSpec) {
                dsr.isLocal = true;
            } else {
                dsr.isSystem = true;
            }
            domainList.add(dsr);
        }
        _logger.debug((Object)("getDomainList found " + domainList.size() + " domains."));
        return (DomainSearchResult[])ArrayUtil.toArray(domainList, DomainSearchResult.class);
    }

    @ModelMetadata(type={"*"}, property="vsphere:systemDomainList")
    public String[] getSystemDomainsList(Object object) throws Exception {
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, SsoDomain.getLocal());
        IdentitySourceDomainManagementService domainMgmt = new IdentitySourceDomainManagementService(adminService);
        Set<String> domains = domainMgmt.getSystemDomains();
        return domains.toArray(new String[domains.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @ModelMetadata(type={"*"}, property="vsphere:userGroups")
    public UserSearchResult[] getUserGroups(Object object, UserDirectorySpec spec) throws Exception {
        UserSearchResult searchResult;
        if (spec.searchString == null) {
            spec.searchString = "";
        }
        ArrayList<UserSearchResult> result = new ArrayList<UserSearchResult>();
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, SsoDomain.getLocal());
        PrincipalManagementServiceImpl principalDiscovery = new PrincipalManagementServiceImpl(adminService);
        PrincipalDiscoveryService.SearchResult usersAndGroups = principalDiscovery.find(spec.domain, spec.searchString);
        if (spec.findUsers) {
            void var11_15;
            Object[] users = usersAndGroups.personUsers;
            for (PersonUser personUser : (PersonUser[])ArrayUtil.toSafe((Object[])users, PersonUser.class)) {
                searchResult = new UserSearchResult();
                searchResult.principal = personUser.id.name;
                searchResult.group = false;
                searchResult.fullName = this.getFullName(personUser.details.firstName, personUser.details.lastName);
                result.add(searchResult);
            }
            Object[] solutionUsers = usersAndGroups.solutionUsers;
            SolutionUser[] solutionUserArray = (SolutionUser[])ArrayUtil.toSafe((Object[])solutionUsers, SolutionUser.class);
            int n = solutionUserArray.length;
            boolean bl = false;
            while (var11_15 < n) {
                SolutionUser solutionUser = solutionUserArray[var11_15];
                UserSearchResult searchResult2 = new UserSearchResult();
                searchResult2.principal = solutionUser.id.name;
                searchResult2.group = false;
                searchResult2.fullName = solutionUser.details.description;
                result.add(searchResult2);
                ++var11_15;
            }
        }
        if (spec.findGroups) {
            Object[] groups = usersAndGroups.groups;
            for (PersonUser personUser : (Group[])ArrayUtil.toSafe((Object[])groups, Group.class)) {
                searchResult = new UserSearchResult();
                searchResult.principal = personUser.id.name;
                searchResult.group = true;
                searchResult.fullName = personUser.details.description;
                result.add(searchResult);
            }
        }
        if (spec.exactMatch) {
            result = this.filterByPrincipal(result, spec.searchString);
        }
        return (UserSearchResult[])ArrayUtil.toArray(result, UserSearchResult.class);
    }

    private ArrayList<UserSearchResult> filterByPrincipal(ArrayList<UserSearchResult> list, String criteria) {
        ArrayList<UserSearchResult> result = new ArrayList<UserSearchResult>();
        for (UserSearchResult searchResult : list) {
            if (!criteria.equalsIgnoreCase(searchResult.principal)) continue;
            result.add(searchResult);
        }
        return result;
    }

    private String getFullName(String firstName, String lastName) {
        String result = "";
        if (!StringUtil.isNullOrEmpty((String)firstName)) {
            result = result + firstName;
        }
        if (!StringUtil.isNullOrEmpty((String)lastName)) {
            result = result + (result.length() > 0 ? " " + lastName : lastName);
        }
        return result;
    }
}

