/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.AgencyIssueData;
import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.issue.AgencyIssue;
import com.vmware.vim.binding.eam.issue.AgentIssue;
import com.vmware.vim.binding.eam.issue.ExtensibleIssue;
import com.vmware.vim.binding.eam.issue.Issue;
import com.vmware.vim.binding.eam.issue.VmIssue;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vcextension.common.NamedMoRef;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgencyIssueProvider
implements PropertyProviderAdapter {
    private final TypeInfo[] providedTypes;
    private final String PROPERTY_ISSUES = "issues";
    private final String PROPERTY_NAME = "name";
    private final DataService _dataService;
    private static final Log _logger = LogFactory.getLog(AgencyIssueProvider.class);

    public AgencyIssueProvider(DataService dataService, DataServiceExtensionRegistry registry) {
        assert (dataService != null);
        this._dataService = dataService;
        TypeInfo agencyType = new TypeInfo();
        agencyType.type = "eam:Agency";
        agencyType.properties = new String[]{"issues"};
        this.providedTypes = new TypeInfo[]{agencyType};
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        return this.providedTypes;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        Object[] properties = propertyRequest.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objects) || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            _logger.warn((Object)"Property provider adapter got a null or empty list of properties or objects");
            return ResultUtil.newEmptyResultSet();
        }
        List<ManagedObjectReference> moRefs = EamUtil.filterMoRefs(objects);
        if (moRefs.size() != objects.length) {
            _logger.warn((Object)"Agency issues requested for object types other than ManagedObjectReference");
        }
        Map<String, List<ManagedObjectReference>> agencies = EamUtil.moRefPerServer(moRefs);
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        for (String serverGuid : agencies.keySet()) {
            try {
                List<ResultItem> resultsForServer = this.getAgencyIssues(serverGuid, agencies.get(serverGuid));
                results.addAll(resultsForServer);
            }
            catch (Exception ex) {
                _logger.error((Object)("Exception getting issues for EAM on VC " + serverGuid + " - The exception is: " + ex));
            }
        }
        ResultSet result = new ResultSet();
        result.items = (ResultItem[])ArrayUtil.toArray(results, ResultItem.class);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultItem> getAgencyIssues(String serverGuid, List<ManagedObjectReference> agencyRefs) throws Exception {
        assert (!StringUtil.isNullOrEmpty((String)serverGuid) && agencyRefs != null);
        if (agencyRefs.isEmpty()) {
            _logger.warn((Object)"Request to get issues for empty list of agencies");
            return Collections.emptyList();
        }
        ArrayList<ResultItem> results = new ArrayList<ResultItem>(agencyRefs.size());
        for (ManagedObjectReference agencyRef : agencyRefs) {
            EamConnection eamConnection = null;
            try {
                eamConnection = EamConnection.newInstance(serverGuid);
                ManagedObjectReference eamAgencyMoRef = EamUtil.dsToEamMoref(agencyRef);
                Agency agency = eamConnection.getAgency(eamAgencyMoRef);
                Object[] allIssues = agency.getRuntime().getIssue();
                ResultItem result = null;
                if (ArrayUtil.isNullOrEmpty((Object[])allIssues)) {
                    result = this.createResultItem(agencyRef, null, serverGuid);
                } else {
                    Map<Class<? extends Issue>, List<Issue>> agencyIssues = this.filterIssues((Issue[])allIssues);
                    ArrayList<AgencyIssueData> issueDescriptions = new ArrayList<AgencyIssueData>();
                    List<Issue> issues = agencyIssues.get(AgencyIssue.class);
                    this.addAgencyIssues(issues, serverGuid, issueDescriptions);
                    issues = agencyIssues.get(ExtensibleIssue.class);
                    this.addExtensibleIssues(issues, serverGuid, issueDescriptions);
                    String agencyName = agency.getConfig().agencyName;
                    for (AgencyIssueData issue : issueDescriptions) {
                        issue.agency = new NamedMoRef(agencyRef, agencyName);
                    }
                    result = this.createResultItem(agencyRef, issueDescriptions, serverGuid);
                }
                results.add(result);
            }
            finally {
                EamConnection.tryClose((VcExtensionConnection)eamConnection);
            }
        }
        return results;
    }

    private Map<Class<? extends Issue>, List<Issue>> filterIssues(Issue[] allIssues) {
        HashMap<Class<? extends Issue>, List<Issue>> result = new HashMap<Class<? extends Issue>, List<Issue>>();
        result.put(ExtensibleIssue.class, new ArrayList());
        result.put(AgencyIssue.class, new ArrayList());
        for (Issue issue : allIssues) {
            if (issue instanceof AgencyIssue) {
                ((List)result.get(AgencyIssue.class)).add(issue);
                continue;
            }
            if (!(issue instanceof ExtensibleIssue)) continue;
            ExtensibleIssue extIssue = (ExtensibleIssue)issue;
            if (extIssue.agency == null) continue;
            ((List)result.get(ExtensibleIssue.class)).add(issue);
        }
        return result;
    }

    private void addExtensibleIssues(List<Issue> issues, String serverGuid, List<AgencyIssueData> resultTarget) {
        assert (issues != null && serverGuid != null && resultTarget != null);
        HashMap<ManagedObjectReference, AgencyIssueData> hostRelations = new HashMap<ManagedObjectReference, AgencyIssueData>();
        for (Issue issue : issues) {
            assert (issue instanceof ExtensibleIssue);
            ExtensibleIssue extIssue = (ExtensibleIssue)issue;
            AgencyIssueData issueData = this.createBaseIssueDescription(issue);
            if (extIssue.target != null && ManagedObjectUtil.isOfType((ManagedObjectReference)extIssue.target, HostSystem.class)) {
                ManagedObjectReference hostRef = EamUtil.eamToVimMoref(extIssue.target, serverGuid);
                hostRelations.put(hostRef, issueData);
            }
            resultTarget.add(issueData);
        }
        try {
            PropertyValue[] names;
            Object[] hosts = hostRelations.keySet().toArray();
            for (PropertyValue name : names = QueryUtil.getProperty((DataService)this._dataService, (Object[])hosts, (String)"name")) {
                if (name == null) {
                    _logger.error((Object)"Data service returned a null PropertyValue when requesting host names.");
                    continue;
                }
                if (name.resourceObject == null) {
                    _logger.error((Object)"No provider object set for host name property returned by data service - cannot match value to known object.");
                    continue;
                }
                if (!(name.resourceObject instanceof ManagedObjectReference)) {
                    _logger.error((Object)("Invalid provider type for host name property: " + name.resourceObject.getClass().getSimpleName()));
                    continue;
                }
                if (!hostRelations.containsKey(name.resourceObject)) {
                    _logger.error((Object)"Unable to match name property returned by data service to a known host moref.");
                    continue;
                }
                assert (name.propertyName.equals("name") && name.value instanceof String);
                ManagedObjectReference hostRef = (ManagedObjectReference)name.resourceObject;
                AgencyIssueData issueData = (AgencyIssueData)((Object)hostRelations.get(name.resourceObject));
                issueData.host = new NamedMoRef(hostRef, (String)name.value);
            }
        }
        catch (Exception dataServiceException) {
            _logger.error((Object)("Exception when trying to get the names ExtensibleIssue target hosts: " + dataServiceException));
        }
    }

    private void addAgencyIssues(List<Issue> issues, String serverGuid, List<AgencyIssueData> resultTarget) {
        assert (issues != null && resultTarget != null);
        for (Issue issue : issues) {
            assert (issue instanceof AgencyIssue);
            AgencyIssueData agencyIssueData = this.createBaseIssueDescription(issue);
            if (issue instanceof AgentIssue) {
                AgentIssue agentIssue = (AgentIssue)issue;
                if (agentIssue.host != null) {
                    ManagedObjectReference hostRef = EamUtil.eamToVimMoref(agentIssue.host, serverGuid);
                    agencyIssueData.host = new NamedMoRef(hostRef, agentIssue.hostName);
                }
                if (issue instanceof VmIssue) {
                    VmIssue vmIssue = (VmIssue)issue;
                    ManagedObjectReference vmRef = EamUtil.eamToVimMoref(vmIssue.vm, serverGuid);
                    agencyIssueData.agent = new NamedMoRef(vmRef, agentIssue.agentName);
                }
            }
            resultTarget.add(agencyIssueData);
        }
    }

    private AgencyIssueData createBaseIssueDescription(Issue issue) {
        AgencyIssueData newIssue = new AgencyIssueData();
        newIssue.key = issue.key;
        newIssue.description = issue.description;
        newIssue.time = issue.time;
        return newIssue;
    }

    private ResultItem createResultItem(ManagedObjectReference agencyRef, List<AgencyIssueData> issueData, String serverGuid) {
        assert (agencyRef != null);
        ResultItem result = new ResultItem();
        result.resourceObject = agencyRef;
        PropertyValue property = ResultUtil.newProperty((String)"issues", (Object)ArrayUtil.toArray(issueData, AgencyIssueData.class));
        property.resourceObject = result.resourceObject;
        result.properties = new PropertyValue[]{property};
        return result;
    }
}

