/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.dvpg.api.DvPortgroupProperties;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.dvportgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.EditDvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupPropertiesAndPolicyData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupPropertiesData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.EditDvPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.EditDvPortgroupDialogProperties;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterData;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterParser;

public class DvPortgroupSettingsPropertyProvider
implements PropertyProviderBean {
    private final String IS_UPLINK_PORTGROUP_PROP = "isUplinkPortgroup";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public DvPortgroupSettingsPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="dvPortgroupProperties")
    public DvPortgroupProperties getDvPortgroupProperties(ManagedObjectReference dvpgRef) {
        DvPortgroupPropertiesData dvPortgroupPropertiesData = (DvPortgroupPropertiesData)this._queryBindingService.prepare(DvPortgroupPropertiesData.class).fetch((Object)dvpgRef);
        return DvPortgroupParser.getPortgroupProperties(dvPortgroupPropertiesData);
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="dvPortgroupPolicies")
    public HostNetworkDetailsData.PortPolicy getDvPortgroupPolicies(ManagedObjectReference dvpgRef) {
        DvPortgroupData dvPortgroupData = (DvPortgroupData)((Object)this._queryBindingService.prepare(DvPortgroupData.class).fetch((Object)dvpgRef));
        HostNetworkDetailsData.PortPolicy portPolicy = DvPortgroupParser.getPortPolicy(dvPortgroupData);
        return portPolicy;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="dvPortgroupTrafficFilter")
    public DvpgTrafficFilterModel getDvPortgroupTrafficFilterPolicy(ManagedObjectReference dvpgRef) {
        DvpgTrafficFilterData trafficFilterData = (DvpgTrafficFilterData)((Object)this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch((Object)dvpgRef));
        DvpgTrafficFilterModel portPolicy = DvpgTrafficFilterParser.getTrafficFilterPolicy(trafficFilterData.filterPolicy);
        return portPolicy;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="editDvPortgroupDialogProperties")
    public EditDvPortgroupDialogProperties getEditDvPortgroupDialogProperties(ManagedObjectReference dvpgRef) {
        EditDvPortgroupDialogData dvPortgroupData = (EditDvPortgroupDialogData)this._queryBindingService.prepare(EditDvPortgroupDialogData.class).fetch((Object)dvpgRef);
        EditDvPortgroupDialogProperties properties = EditDvPortgroupParser.getDvPortgroupDialogProperties(dvPortgroupData);
        return properties;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="dvpg", property="dvPortgroupPropertiesAndPolicy")
    public DvPortgroupPropertiesAndPolicyData getDvPortgroupPropertiesAndPolicy(ManagedObjectReference hostRef, String portgroupKey) {
        ResultSet dvpgRefQueryResult = this._queryService.select(new String[]{"isUplinkPortgroup"}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("host", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef), new PropertyPredicate("key", PropertyPredicate.ComparisonOperator.EQUAL, (Object)portgroupKey)}).fetch();
        if (dvpgRefQueryResult == null || dvpgRefQueryResult.getItems() == null || dvpgRefQueryResult.getItems().size() != 1) {
            return null;
        }
        ResourceItem dvpgItem = (ResourceItem)dvpgRefQueryResult.getItems().get(0);
        ManagedObjectReference dvpgRef = (ManagedObjectReference)dvpgItem.getKey();
        DvPortgroupPropertiesAndPolicyData result = new DvPortgroupPropertiesAndPolicyData();
        result.properties = this.getDvPortgroupProperties(dvpgRef);
        result.policy = this.getDvPortgroupPolicies(dvpgRef);
        result.isUplink = Boolean.TRUE.equals(dvpgItem.get("isUplinkPortgroup"));
        return result;
    }
}

