/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.ports;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.dvs.api.port.DvsPortData;
import com.vmware.vsphere.client.h5.network.dvportgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.ports.DvPortgroupPortsViewData;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgTrafficRuleModel;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsPolicyData;
import com.vmware.vsphere.client.h5.network.dvs.ports.DvsPortEditParser;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortPoliciesData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrafficFilterModel;
import com.vmware.vsphere.client.h5.network.model.DvsPortsListData;
import com.vmware.vsphere.client.h5.network.util.DvsPortsUtil;
import java.util.ArrayList;
import java.util.Map;

public class DvPortgroupPortsPropertyProvider
implements PropertyProviderBean {
    private final QueryExecutor _queryExecutor;
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private static final String DVPG_DVS = "config.distributedVirtualSwitch";
    private static final String DVPG_TRAFFIC_FILTER_OVERRIDE_ALLOWED = "config.policy.trafficFilterOverrideAllowed";

    public DvPortgroupPortsPropertyProvider(QueryExecutor queryExecutor, QueryService queryService, QueryBindingService queryBindingService) {
        this._queryExecutor = queryExecutor;
        this._queryService = queryService;
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvportgroupports", property="portsViewData")
    public DvsPortsListData getPortsViewData(ManagedObjectReference dvpgMor) throws Exception {
        DvPortgroupPortsViewData portsViewData = (DvPortgroupPortsViewData)((Object)this._queryBindingService.prepare(DvPortgroupPortsViewData.class).fetch((Object)dvpgMor));
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvportgroupPortsQuerySpec(dvpgMor, portsViewData.dvsRef));
        ArrayList<DvsPortData> ports = new ArrayList<DvsPortData>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                ports.add(DvsPortsUtil.parsePortsData(item));
            }
        }
        DvsPortsListData data2 = new DvsPortsListData();
        data2.dvsMor = portsViewData.dvsRef;
        data2.portTrafficFilterSupported = portsViewData.trafficFilterSupported != null && portsViewData.trafficFilterSupported != false;
        data2.ports = DvsPortsUtil.sortDvsPortsData(ports);
        return data2;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvportgroupport", property="portPoliciesData")
    public HostNetworkDetailsData.PortPolicy getPortPoliciesData(ManagedObjectReference dvpgMor, String portId) throws Exception {
        com.vmware.vise.data.query.ResultSet portSettingResultSet;
        DvsPortPoliciesData dvsPortPoliciesData = new DvsPortPoliciesData();
        ManagedObjectReference dvsMor = null;
        ResultSet dvpgResultSet = this._queryService.select(new String[]{"isUplinkPortgroup", DVPG_DVS}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgMor)}).fetch();
        if (dvpgResultSet != null && dvpgResultSet.getItems() != null) {
            ResourceItem dvpgResultSetItems = (ResourceItem)dvpgResultSet.getItems().get(0);
            dvsPortPoliciesData.isUplink = (Boolean)dvpgResultSetItems.getPropertyValues().get(0);
            dvsMor = (ManagedObjectReference)dvpgResultSetItems.getPropertyValues().get(1);
        }
        if ((portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsPoliciesQuerySpec(dvsMor, portId))) != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)item.properties[0].value;
                dvsPortPoliciesData.portSetting = configInfo.setting;
            }
        }
        dvsPortPoliciesData.dvsPolicyData = (DvsPolicyData)this._queryBindingService.prepare(DvsPolicyData.class).fetch(dvsMor);
        HostNetworkDetailsData.PortPolicy portPolicy = DvPortgroupParser.getPortPolicy(dvsPortPoliciesData);
        return portPolicy;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvportgroupport", property="portTrafficFilterData")
    public DvsPortTrafficFilterModel getDvpgPortTrafficFilterData(ManagedObjectReference dvpgRef, String portId) throws Exception {
        ManagedObjectReference dvsMor = null;
        boolean isTrafficFilterOverrideEnabled = false;
        ResultSet dvpgResultSet = this._queryService.select(new String[]{DVPG_DVS, DVPG_TRAFFIC_FILTER_OVERRIDE_ALLOWED}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgRef)}).fetch();
        if (dvpgResultSet != null && dvpgResultSet.getItems() != null) {
            ResourceItem dvpgResultSetItems = (ResourceItem)dvpgResultSet.getItems().get(0);
            dvsMor = (ManagedObjectReference)dvpgResultSetItems.getPropertyValues().get(0);
            isTrafficFilterOverrideEnabled = (Boolean)dvpgResultSetItems.getPropertyValues().get(1);
        }
        DistributedVirtualPort.FilterPolicy portFilterPolicy = this.getPortTrafficFilterPolicy(dvsMor, portId);
        DvsPortTrafficFilterModel portTrafficFilterModel = DvpgTrafficFilterParser.getTrafficFilterPolicyForPort(portFilterPolicy, isTrafficFilterOverrideEnabled);
        return portTrafficFilterModel;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvportgroupport", property="portEditTrafficRuleData")
    public DvpgTrafficRuleModel getEditDvpgPortTrafficFilterData(ManagedObjectReference dvpgRef, Map<String, String> portParams) throws Exception {
        String portId = portParams.get("portId");
        String ruleKey = portParams.get("ruleKey");
        ResultSet dvpgResultSet = this._queryService.select(new String[]{DVPG_DVS}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgRef)}).fetch();
        ManagedObjectReference dvsRef = null;
        if (dvpgResultSet != null && dvpgResultSet.getItems() != null) {
            ResourceItem dvpgResultSetItems = (ResourceItem)dvpgResultSet.getItems().get(0);
            dvsRef = (ManagedObjectReference)dvpgResultSetItems.getPropertyValues().get(0);
        }
        DistributedVirtualPort.FilterPolicy filterPolicy = this.getPortTrafficFilterPolicy(dvsRef, portId);
        return DvpgTrafficRuleModelBuilder.getTrafficRuleModelByKey(filterPolicy, ruleKey);
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvportgroupport", property="portEditData")
    public DvsPortEditData getPortEditData(ManagedObjectReference dvpgMor, Map<String, String> portParams) throws Exception {
        String portId = portParams.get("portId");
        ManagedObjectReference dvsMor = ManagedObjectUtil.stringToMoref((String)portParams.get("dSwitchUri"));
        DvsPortEditQueryBinding dvsPortEditQueryBinding = (DvsPortEditQueryBinding)this._queryBindingService.prepare(DvsPortEditQueryBinding.class).fetch((Object)dvpgMor);
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortEditQuerySpec(dvsMor, portId));
        return DvsPortEditParser.getPortEditData(dvsPortEditQueryBinding, resultSet, dvsMor);
    }

    private DistributedVirtualPort.FilterPolicy getPortTrafficFilterPolicy(ManagedObjectReference dvsMor, String portId) throws Exception {
        if (dvsMor == null || StringUtil.isNullOrEmpty((String)portId)) {
            return null;
        }
        com.vmware.vise.data.query.ResultSet portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsPoliciesQuerySpec(dvsMor, portId));
        if (portSettingResultSet != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)item.properties[0].value;
                if (configInfo.setting == null) continue;
                return configInfo.setting.filterPolicy;
            }
        }
        return null;
    }
}

