/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter;

import com.vmware.vim.binding.vim.IntExpression;
import com.vmware.vim.binding.vim.IpAddress;
import com.vmware.vim.binding.vim.IpRange;
import com.vmware.vim.binding.vim.MacAddress;
import com.vmware.vim.binding.vim.MacRange;
import com.vmware.vim.binding.vim.SingleIp;
import com.vmware.vim.binding.vim.SingleMac;
import com.vmware.vim.binding.vim.StringExpression;
import com.vmware.vim.binding.vim.dvs.TrafficRule;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgIpAddressModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgIpQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgMacAddressModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgMacQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgPortModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgProtocolModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgSystemQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgTrafficRuleModel;
import java.util.ArrayList;

public class DvpgTrafficRuleBuilder {
    private static final int SEQUENCE_NUMBER_RANGE = 10;
    private static final String ALLOW = "allow";
    private static final String DROP = "drop";
    private static final String TAG = "tag";
    private static final int ANY = 0;
    private static final int IS = 1;
    private static final int IS_NOT = 2;
    private static final int IN_RANGE = 3;
    private static final int NOT_IN_RANGE = 4;
    private static final int MATCHES = 5;
    private static final int DOES_NOT_MATCH = 6;
    private static final int TCP_PROTOCOL_VALUE = 6;
    private static final int UDP_PROTOCOL_VALUE = 17;
    private static final int CUSTOM_PROTOCOL_VALUE = 0;
    private static final String IPV4 = "ipv4";
    private static final String MIXED = "mixed";
    private static final int ANY_IP_PREFIX = 0;
    private static final String ANY_IPV4_ADDRESS = "255.255.255.255";
    private static final String ANY_IPV6_ADDRESS = "::";

    public static TrafficRule createTrafficRule(DvpgTrafficRuleModel ruleModel) {
        if (ruleModel == null) {
            return null;
        }
        TrafficRule rule = new TrafficRule();
        rule.key = ruleModel.key;
        rule.sequence = ruleModel.sequence;
        rule.action = DvpgTrafficRuleBuilder.getRuleAction(ruleModel.action, ruleModel.qosTagSelected, ruleModel.qosTagValue, ruleModel.dscpTagSelected, ruleModel.dscpTagValue);
        rule.direction = ruleModel.direction;
        rule.description = ruleModel.name;
        rule.qualifier = DvpgTrafficRuleBuilder.getRuleQualifiers(ruleModel.ipQualifierModel, ruleModel.macQualifierModel, ruleModel.systemQualifierModel);
        return rule;
    }

    public static TrafficRule.Action getRuleAction(String action, boolean qosTagSelected, String qosTagValue, boolean dscpTagSelected, String dscpTagValue) {
        if (StringUtil.isNullOrEmpty((String)action)) {
            return null;
        }
        switch (action) {
            case "allow": {
                return new TrafficRule.AcceptAction();
            }
            case "drop": {
                return new TrafficRule.DropAction();
            }
            case "tag": {
                TrafficRule.UpdateTagAction updateTagAction = new TrafficRule.UpdateTagAction();
                if (qosTagSelected) {
                    updateTagAction.qosTag = DvpgTrafficRuleBuilder.tryParseToInt(qosTagValue, 0);
                }
                if (dscpTagSelected) {
                    updateTagAction.dscpTag = DvpgTrafficRuleBuilder.tryParseToInt(dscpTagValue, 0);
                }
                return updateTagAction;
            }
        }
        return null;
    }

    public static TrafficRule.Qualifier[] getRuleQualifiers(DvpgIpQualifierModel ipQualifierModel, DvpgMacQualifierModel macQualifierModel, DvpgSystemQualifierModel systemQualifierModel) {
        ArrayList<Object> qualifiers = new ArrayList<Object>();
        if (ipQualifierModel != null && ipQualifierModel.enableIpQualifier) {
            TrafficRule.IpQualifier ipQualifier = DvpgTrafficRuleBuilder.getIpQualifier(ipQualifierModel);
            qualifiers.add(ipQualifier);
        }
        if (macQualifierModel != null && macQualifierModel.enableMacQualifier) {
            TrafficRule.MacQualifier macQualifier = DvpgTrafficRuleBuilder.getMacQualifier(macQualifierModel);
            qualifiers.add(macQualifier);
        }
        if (systemQualifierModel != null && systemQualifierModel.enableSystemQualifier) {
            TrafficRule.SystemTrafficQualifier systemQualifier = DvpgTrafficRuleBuilder.getSystemQualifier(systemQualifierModel);
            qualifiers.add(systemQualifier);
        }
        return qualifiers.toArray(new TrafficRule.Qualifier[qualifiers.size()]);
    }

    public static TrafficRule.IpQualifier getIpQualifier(DvpgIpQualifierModel ipQualifierModel) {
        if (ipQualifierModel == null) {
            return null;
        }
        TrafficRule.IpQualifier ipQualifier = new TrafficRule.IpQualifier();
        ipQualifier.protocol = DvpgTrafficRuleBuilder.getQualifierProtocol(ipQualifierModel.protocol, false);
        if (ipQualifierModel.protocol.type == 6 || ipQualifierModel.protocol.type == 17) {
            ipQualifier.sourceIpPort = DvpgTrafficRuleBuilder.getIpPort(ipQualifierModel.sourcePort);
            ipQualifier.destinationIpPort = DvpgTrafficRuleBuilder.getIpPort(ipQualifierModel.destinationPort);
        }
        ipQualifier.sourceAddress = DvpgTrafficRuleBuilder.getIpAddress(ipQualifierModel.sourceIpAddress);
        ipQualifier.destinationAddress = DvpgTrafficRuleBuilder.getIpAddress(ipQualifierModel.destinationIpAddress);
        return ipQualifier;
    }

    public static TrafficRule.MacQualifier getMacQualifier(DvpgMacQualifierModel macQualifierModel) {
        if (macQualifierModel == null) {
            return null;
        }
        TrafficRule.MacQualifier macQualifier = new TrafficRule.MacQualifier();
        macQualifier.protocol = DvpgTrafficRuleBuilder.getQualifierProtocol(macQualifierModel.protocol, true);
        macQualifier.vlanId = DvpgTrafficRuleBuilder.getVlanId(macQualifierModel.vlanOperation, macQualifierModel.vlanId);
        macQualifier.sourceAddress = DvpgTrafficRuleBuilder.getMacAddress(macQualifierModel.sourceMacAddress);
        macQualifier.destinationAddress = DvpgTrafficRuleBuilder.getMacAddress(macQualifierModel.destinationMacAddress);
        return macQualifier;
    }

    public static TrafficRule.SystemTrafficQualifier getSystemQualifier(DvpgSystemQualifierModel systemQualifierModel) {
        if (systemQualifierModel == null) {
            return null;
        }
        TrafficRule.SystemTrafficQualifier systemQualifier = new TrafficRule.SystemTrafficQualifier();
        systemQualifier.typeOfSystemTraffic = new StringExpression();
        systemQualifier.typeOfSystemTraffic.value = systemQualifierModel.trafficType;
        systemQualifier.typeOfSystemTraffic.negate = systemQualifierModel.trafficOperation == 2;
        return systemQualifier;
    }

    public static IntExpression getQualifierProtocol(DvpgProtocolModel protocolModel, boolean isHexValue) {
        if (protocolModel == null || protocolModel.operation == 0) {
            return null;
        }
        IntExpression protocol = new IntExpression();
        protocol.negate = protocolModel.operation == 2;
        protocol.value = protocolModel.type == 0 ? DvpgTrafficRuleBuilder.convertStringToInteger(protocolModel.customValue, isHexValue) : protocolModel.type;
        return protocol;
    }

    public static IntExpression getVlanId(int vlanOperation, String vlanId) {
        if (vlanOperation == 0) {
            return null;
        }
        IntExpression vlan = new IntExpression();
        vlan.negate = vlanOperation == 2;
        vlan.value = DvpgTrafficRuleBuilder.tryParseToInt(vlanId, 0);
        return vlan;
    }

    public static TrafficRule.IpPort getIpPort(DvpgPortModel portModel) {
        if (portModel == null || portModel.operation == 0) {
            return null;
        }
        if (portModel.operation == 1 || portModel.operation == 2) {
            TrafficRule.SingleIpPort port = new TrafficRule.SingleIpPort();
            port.portNumber = DvpgTrafficRuleBuilder.tryParseToInt(portModel.port, 0);
            port.negate = portModel.operation == 2;
            return port;
        }
        if (portModel.operation == 3 || portModel.operation == 4) {
            TrafficRule.IpPortRange portRange = new TrafficRule.IpPortRange();
            portRange.startPortNumber = DvpgTrafficRuleBuilder.tryParseToInt(portModel.port, 0);
            portRange.endPortNumber = DvpgTrafficRuleBuilder.tryParseToInt(portModel.portRangeEnd, 0);
            portRange.negate = portModel.operation == 4;
            return portRange;
        }
        return null;
    }

    public static IpAddress getIpAddress(DvpgIpAddressModel ipAddressModel) {
        if (ipAddressModel == null || ipAddressModel.operation == 0 && ipAddressModel.ipAddressType.equals(MIXED)) {
            return null;
        }
        if (ipAddressModel.operation == 0) {
            IpRange ipRange = new IpRange();
            ipRange.prefixLength = 0;
            ipRange.addressPrefix = ipAddressModel.ipAddressType.equals(IPV4) ? ANY_IPV4_ADDRESS : ANY_IPV6_ADDRESS;
            return ipRange;
        }
        if (ipAddressModel.operation == 1 || ipAddressModel.operation == 2) {
            SingleIp singleIp = new SingleIp();
            singleIp.address = ipAddressModel.ipAddress.trim();
            singleIp.negate = ipAddressModel.operation == 2;
            return singleIp;
        }
        if (ipAddressModel.operation == 5 || ipAddressModel.operation == 6) {
            IpRange ipRange = new IpRange();
            ipRange.addressPrefix = ipAddressModel.ipAddress.trim();
            ipRange.prefixLength = DvpgTrafficRuleBuilder.tryParseToInt(ipAddressModel.prefixLength, 0);
            ipRange.negate = ipAddressModel.operation == 6;
            return ipRange;
        }
        return null;
    }

    public static MacAddress getMacAddress(DvpgMacAddressModel macAddressModel) {
        if (macAddressModel == null || macAddressModel.operation == 0) {
            return null;
        }
        if (macAddressModel.operation == 1 || macAddressModel.operation == 2) {
            SingleMac singleMac = new SingleMac();
            singleMac.address = macAddressModel.macAddress.trim();
            singleMac.negate = macAddressModel.operation == 2;
            return singleMac;
        }
        if (macAddressModel.operation == 6 || macAddressModel.operation == 5) {
            MacRange portRange = new MacRange();
            portRange.address = macAddressModel.macAddress.trim();
            portRange.mask = macAddressModel.wildcardMask.trim();
            portRange.negate = macAddressModel.operation == 6;
            return portRange;
        }
        return null;
    }

    public static int getNextAvailableSequenceNumber(TrafficRule[] trafficRules) {
        int sequenceNumber = 0;
        if (ArrayUtil.isNullOrEmpty((Object[])trafficRules)) {
            return 10;
        }
        for (TrafficRule rule : trafficRules) {
            if (rule.sequence <= sequenceNumber) continue;
            sequenceNumber = rule.sequence;
        }
        return sequenceNumber + 10;
    }

    private static Integer convertStringToInteger(String value, boolean isHexValue) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return null;
        }
        if (isHexValue) {
            return DvpgTrafficRuleBuilder.tryParseToInt(value, null, 16);
        }
        return DvpgTrafficRuleBuilder.tryParseToInt(value);
    }

    private static Integer tryParseToInt(String text, Integer defaultValue, int radix) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private static Integer tryParseToInt(String text, Integer defaultValue) {
        return DvpgTrafficRuleBuilder.tryParseToInt(text, defaultValue, 10);
    }

    private static Integer tryParseToInt(String text) {
        return DvpgTrafficRuleBuilder.tryParseToInt(text, null, 10);
    }
}

