/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.ResControlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsListDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String LACP_VERSION_LABEL = "lacpVersionColumnLabelDerived";
    private static final String NIOC_VERSION_LABEL = "niocVersionColumnLabel";
    private static final String LACP_API_VERSION = "config[@type='VMwareDVSConfigInfo'].lacpApiVersion";
    private static final String LACP_CAPABILITY = "capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lacpCapability.lacpSupported";
    private static final String NIOC_API_VERSION = "config[@type='VMwareDVSConfigInfo'].networkResourceControlVersion";
    private static final String VMWARE_DVS_TYPE = VmwareDistributedVirtualSwitch.class.getSimpleName();
    private static final String DVS_TYPE = DistributedVirtualSwitch.class.getSimpleName();
    private static Log _logger = LogFactory.getLog(DvsListDerivedPropertyProviderAdapter.class);

    public DvsListDerivedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo dvsTypeInfo = new TypeInfo();
        dvsTypeInfo.type = DVS_TYPE;
        dvsTypeInfo.properties = new String[]{LACP_VERSION_LABEL, NIOC_VERSION_LABEL};
        TypeInfo vmwDvsTypeInfo = new TypeInfo();
        vmwDvsTypeInfo.type = VMWARE_DVS_TYPE;
        vmwDvsTypeInfo.properties = new String[]{LACP_VERSION_LABEL, NIOC_VERSION_LABEL};
        DerivedPropertyInfo lacpVersionAndCapability = new DerivedPropertyInfo();
        lacpVersionAndCapability.propertyName = LACP_VERSION_LABEL;
        lacpVersionAndCapability.sourcePropertyNames = new String[]{LACP_API_VERSION, LACP_CAPABILITY};
        DerivedPropertyInfo niocVersion = new DerivedPropertyInfo();
        niocVersion.propertyName = NIOC_VERSION_LABEL;
        niocVersion.sourcePropertyNames = new String[]{NIOC_API_VERSION};
        vmwDvsTypeInfo.derivedProperties = new DerivedPropertyInfo[]{lacpVersionAndCapability, niocVersion};
        return new TypeInfo[]{dvsTypeInfo, vmwDvsTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        if (ArrayUtil.isNullOrEmpty((Object[])objects)) {
            return null;
        }
        Set<String> requestedProperties = this.getRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        if (sourcePropertyValues != null) {
            for (Object object : objects) {
                Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(object);
                if (sourcePropertyValuesMap == null) continue;
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = object;
                Boolean isVmwareDvs = object instanceof ManagedObjectReference && ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)object), (String)VMWARE_DVS_TYPE);
                LinkedList<PropertyValue> resultProperties = new LinkedList<PropertyValue>();
                if (requestedProperties.contains(LACP_VERSION_LABEL)) {
                    String lacpVersionLabel = isVmwareDvs != false ? this.getLacpVersionLabel(sourcePropertyValuesMap) : NetworkStringUtil.getString("na");
                    resultProperties.add(this.createPropertyValue(LACP_VERSION_LABEL, resultItem.resourceObject, lacpVersionLabel));
                }
                if (requestedProperties.contains(NIOC_VERSION_LABEL)) {
                    String niocVersionLabel = isVmwareDvs != false ? this.getNiocVersionLabel(sourcePropertyValuesMap) : NetworkStringUtil.getString("na");
                    resultProperties.add(this.createPropertyValue(NIOC_VERSION_LABEL, resultItem.resourceObject, niocVersionLabel));
                }
                resultItem.properties = resultProperties.toArray(new PropertyValue[resultProperties.size()]);
                resultItems.add(resultItem);
            }
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private Set<String> getRequestedProperties(PropertyRequestSpec propertyRequestSpec) {
        HashSet<String> requestedProperties = new HashSet<String>();
        if (!ArrayUtil.isNullOrEmpty((Object[])propertyRequestSpec.properties)) {
            for (PropertySpec propertySpec : propertyRequestSpec.properties) {
                if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames)) continue;
                for (String propertyName : propertySpec.propertyNames) {
                    requestedProperties.add(propertyName);
                }
            }
        }
        return requestedProperties;
    }

    private PropertyValue createPropertyValue(String propertyName, Object resourceObject, String value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = propertyName;
        propertyValue.resourceObject = resourceObject;
        propertyValue.value = value;
        return propertyValue;
    }

    private String formatLacpVersion(String lacpApiVersion, boolean lacpCapability) {
        String lacpVersionLabel;
        if (!lacpCapability || StringUtil.isNullOrEmpty((String)lacpApiVersion)) {
            return NetworkStringUtil.getString("na");
        }
        VmwareDistributedVirtualSwitch.LacpApiVersion lacpApiVersionEnum = null;
        try {
            lacpApiVersionEnum = VmwareDistributedVirtualSwitch.LacpApiVersion.valueOf((String)lacpApiVersion);
        }
        catch (IllegalArgumentException e) {
            _logger.debug((Object)("Unknown lacp API version: " + lacpApiVersion));
            return NetworkStringUtil.getString("na");
        }
        switch (lacpApiVersionEnum) {
            case singleLag: {
                lacpVersionLabel = NetworkStringUtil.getString("lacp.version.singleLag");
                break;
            }
            case multipleLag: {
                lacpVersionLabel = NetworkStringUtil.getString("lacp.version.multipleLag");
                break;
            }
            default: {
                lacpVersionLabel = NetworkStringUtil.getString("na");
            }
        }
        return lacpVersionLabel;
    }

    private String getNiocVersionLabel(Map<String, Object> sourcePropertyValuesMap) {
        String niocApiVersion = (String)DvsListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, NIOC_API_VERSION);
        return ResControlUtil.formatNiocVersion(niocApiVersion);
    }

    private String getLacpVersionLabel(Map<String, Object> sourcePropertyValuesMap) {
        String lacpApiVersion = (String)DvsListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, LACP_API_VERSION);
        boolean lacpCapability = (Boolean)DvsListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, LACP_CAPABILITY);
        return this.formatLacpVersion(lacpApiVersion, lacpCapability);
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }
}

