/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddAndManageHostsSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmVnicAssignmentSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VnicAssignmentSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.DvsAddHostSpecFactory;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostNetworkModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsAddHostMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DvsAddHostMutationProvider.class);
    private final QueryExecutor _queryExecutor;
    private final MutationService _mutationService;
    private final QueryBindingService _queryBindingService;

    public DvsAddHostMutationProvider(QueryExecutor queryExecutor, MutationService mutationService, QueryBindingService queryBindingService) {
        this._queryExecutor = queryExecutor;
        this._mutationService = mutationService;
        this._queryBindingService = queryBindingService;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsAddAndManageHostsSpec dvsAddAndManageHostsSpec) throws Exception {
        Object[] vmRefs;
        Object[] dvPortgroupRefs;
        String uuid = (String)this._queryExecutor.getProperty((Object)dvsRef, "uuid");
        Set<ManagedObjectReference> hostsToMutate = this.getHostsToMutate(dvsAddAndManageHostsSpec);
        ArrayList<HostNetworkModel> hostNetworkModels = new ArrayList();
        if (!hostsToMutate.isEmpty()) {
            hostNetworkModels = this._queryBindingService.prepare(HostNetworkModel.class).fetch(Arrays.asList(hostsToMutate));
        }
        PropertyValue[] dvPortgroupKeys = null;
        if (!(ArrayUtil.isNullOrEmpty((Object[])dvsAddAndManageHostsSpec.vnicAssignmentSpecs) && ArrayUtil.isNullOrEmpty((Object[])dvsAddAndManageHostsSpec.vmVnicAssignmentSpecs) || ArrayUtil.isNullOrEmpty((Object[])(dvPortgroupRefs = this.getAssignedDvPortgroupRefs(dvsAddAndManageHostsSpec.vnicAssignmentSpecs, dvsAddAndManageHostsSpec.vmVnicAssignmentSpecs))))) {
            dvPortgroupKeys = this._queryExecutor.getProperty(dvPortgroupRefs, "key");
        }
        PropertyValue[] vmDevices = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])dvsAddAndManageHostsSpec.vmVnicAssignmentSpecs) && !ArrayUtil.isNullOrEmpty((Object[])(vmRefs = this.getMigratedVmRefs(dvsAddAndManageHostsSpec.vmVnicAssignmentSpecs)))) {
            vmDevices = this._queryExecutor.getProperty(vmRefs, "config.hardware.device");
        }
        BaseCommandSpec baseCommandSpec = DvsAddHostSpecFactory.createDvsAddHostSpec(dvsRef, dvsAddAndManageHostsSpec, uuid, hostNetworkModels, dvPortgroupKeys, vmDevices, dvsAddAndManageHostsSpec.areMemberHosts);
        return this._mutationService.apply((Object)dvsRef, (Object)baseCommandSpec);
    }

    private Set<ManagedObjectReference> getHostsToMutate(DvsAddAndManageHostsSpec dvsAddAndManageHostsSpec) {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        if (dvsAddAndManageHostsSpec != null && !ArrayUtil.isNullOrEmpty((Object[])dvsAddAndManageHostsSpec.hostsToMutate)) {
            result.addAll(Arrays.asList(dvsAddAndManageHostsSpec.hostsToMutate));
        }
        return result;
    }

    private ManagedObjectReference[] getAssignedDvPortgroupRefs(VnicAssignmentSpec[] vnicAssignmentSpecs, VmVnicAssignmentSpec[] vmVnicAssignmentSpecs) {
        HashSet<ManagedObjectReference> dvPortgroupRefs = new HashSet<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])vnicAssignmentSpecs)) {
            for (VnicAssignmentSpec vnicAssignmentSpec : vnicAssignmentSpecs) {
                if (vnicAssignmentSpec == null || vnicAssignmentSpec.distributedPortgroupRef == null) continue;
                dvPortgroupRefs.add(vnicAssignmentSpec.distributedPortgroupRef);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])vmVnicAssignmentSpecs)) {
            for (VmVnicAssignmentSpec vmVnicAssignmentSpec : vmVnicAssignmentSpecs) {
                if (vmVnicAssignmentSpec == null || vmVnicAssignmentSpec.distributedPortgroupRef == null) continue;
                dvPortgroupRefs.add(vmVnicAssignmentSpec.distributedPortgroupRef);
            }
        }
        return dvPortgroupRefs.toArray(new ManagedObjectReference[dvPortgroupRefs.size()]);
    }

    private ManagedObjectReference[] getMigratedVmRefs(VmVnicAssignmentSpec[] vmVnicAssignmentSpecs) {
        HashSet<ManagedObjectReference> vmRefs = new HashSet<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])vmVnicAssignmentSpecs)) {
            for (VmVnicAssignmentSpec vmVnicAssignmentSpec : vmVnicAssignmentSpecs) {
                if (vmVnicAssignmentSpec == null || vmVnicAssignmentSpec.vm == null) continue;
                vmRefs.add(vmVnicAssignmentSpec.vm);
            }
        }
        return vmRefs.toArray(new ManagedObjectReference[vmRefs.size()]);
    }
}

