/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000e;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualPCNet32;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet2;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet3;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListHostItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListVmItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListVmVnicItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostHostVmsModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostVmModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsVmOpaqueNetworkModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmDvPortgroupModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmVnicSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.VmVnicSettingsQueryModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class DvsAddHostVmParser {
    private static final String DIGIT_REGEX = "[0-9]";
    private static final String NON_NUMBER_REGEX = "\\D+";

    public static DvsAddHostHierarchicalListItem[] parseHostVms(Collection<DvsAddHostHostVmsModel> hostVmsModels, boolean areMemberHosts) {
        if (hostVmsModels == null) {
            return new DvsAddHostHierarchicalListItem[0];
        }
        DvsAddHostHostVmsModel[] hostVmModelsArray = hostVmsModels.toArray(new DvsAddHostHostVmsModel[hostVmsModels.size()]);
        if (ArrayUtil.isNullOrEmpty((Object[])hostVmModelsArray)) {
            return new DvsAddHostHierarchicalListItem[0];
        }
        Map<String, String> portgroupNamesMap = DvsAddHostVmParser.createPortgroupNamesMap(hostVmsModels);
        DvsAddHostVmParser.sortHostsAndVms(hostVmModelsArray);
        ArrayList<DvsAddHostHierarchicalListItem> treeListItems = new ArrayList<DvsAddHostHierarchicalListItem>();
        for (DvsAddHostHostVmsModel hostVmsModel : hostVmModelsArray) {
            if (hostVmsModel == null || ArrayUtil.isNullOrEmpty((Object[])hostVmsModel.vm) || hostVmsModel.provider == null) continue;
            DvsAddHostHierarchicalListHostItem hostItem = null;
            for (DvsAddHostVmModel vmModel : hostVmsModel.vm) {
                DvsAddHostHierarchicalListVmItem vmItem;
                Object[] virtualEthernetCards;
                if (vmModel == null || vmModel.isTemplate || DvsAddHostWizardUtil.isSecondaryVm(vmModel.role) || ArrayUtil.isNullOrEmpty((Object[])(virtualEthernetCards = vmModel.getVirtualEthernetCards()))) continue;
                if (hostItem == null && (hostItem = DvsAddHostVmParser.createHostItem(hostVmsModel, areMemberHosts)) != null) {
                    treeListItems.add(hostItem);
                }
                if (hostItem == null || (vmItem = DvsAddHostVmParser.createVmItem(vmModel, hostItem.id, hostItem.hostRef)) == null) continue;
                treeListItems.add(vmItem);
                Arrays.sort(virtualEthernetCards, new Comparator<VirtualEthernetCard>(){

                    @Override
                    public int compare(VirtualEthernetCard a1, VirtualEthernetCard a2) {
                        if (a1.deviceInfo == null || a2.deviceInfo == null || StringUtil.isNullOrEmpty((String)a1.deviceInfo.label) || StringUtil.isNullOrEmpty((String)a2.deviceInfo.label)) {
                            return 0;
                        }
                        boolean compareLexicographically = false;
                        int nic1 = 0;
                        int nic2 = 0;
                        String nic1Prefix = a1.deviceInfo.label.replaceAll(DvsAddHostVmParser.DIGIT_REGEX, "");
                        String nic2Prefix = a2.deviceInfo.label.replaceAll(DvsAddHostVmParser.DIGIT_REGEX, "");
                        String nic1IndexString = a1.deviceInfo.label.replaceAll(DvsAddHostVmParser.NON_NUMBER_REGEX, "");
                        String nic2IndexString = a2.deviceInfo.label.replaceAll(DvsAddHostVmParser.NON_NUMBER_REGEX, "");
                        if (StringUtil.isNullOrEmpty((String)nic1Prefix) || StringUtil.isNullOrEmpty((String)nic2Prefix)) {
                            compareLexicographically = true;
                        } else {
                            int prefixComparison = nic1Prefix.compareTo(nic2Prefix);
                            if (prefixComparison != 0) {
                                compareLexicographically = true;
                            } else {
                                try {
                                    nic1 = Integer.parseInt(nic1IndexString);
                                    nic2 = Integer.parseInt(nic2IndexString);
                                }
                                catch (NumberFormatException nfe) {
                                    compareLexicographically = true;
                                }
                            }
                        }
                        if (compareLexicographically) {
                            return a1.deviceInfo.label.compareTo(a2.deviceInfo.label);
                        }
                        return nic1 < nic2 ? -1 : (nic1 == nic2 ? 0 : 1);
                    }
                });
                for (Object virtualEthernetCard : virtualEthernetCards) {
                    DvsAddHostHierarchicalListVmVnicItem vnicItem = DvsAddHostVmParser.createVnicItem((VirtualEthernetCard)virtualEthernetCard, vmItem.id, vmItem.vmRef, hostItem.hostRef, portgroupNamesMap, vmModel.opaqueNetworks, vmModel.changeVersion);
                    if (vnicItem == null) continue;
                    treeListItems.add(vnicItem);
                    ++vmItem.nicCount;
                    if (!vnicItem.showWarning) continue;
                    vmItem.raiseWarning();
                }
            }
        }
        return treeListItems.toArray(new DvsAddHostHierarchicalListItem[treeListItems.size()]);
    }

    public static List<VmVnicSettingsData> parseVmVnicsSettings(VmVnicSettingsQueryModel vmVnicSettingsQueryModel) {
        ArrayList<VmVnicSettingsData> vmVnicSettingsDataItems = new ArrayList<VmVnicSettingsData>();
        if (vmVnicSettingsQueryModel != null && !ArrayUtils.isEmpty((Object[])vmVnicSettingsQueryModel.device)) {
            for (VirtualDevice device : vmVnicSettingsQueryModel.device) {
                if (!(device instanceof VirtualEthernetCard)) continue;
                VirtualEthernetCard virtualEthernetCard = (VirtualEthernetCard)device;
                VmVnicSettingsData vmVnicSettingsData = new VmVnicSettingsData();
                vmVnicSettingsData.key = device.key;
                if (virtualEthernetCard.deviceInfo != null) {
                    vmVnicSettingsData.adapterName = virtualEthernetCard.deviceInfo.label;
                }
                vmVnicSettingsData.macAddress = virtualEthernetCard.macAddress;
                vmVnicSettingsData.adapterType = DvsAddHostVmParser.getAdapterType(virtualEthernetCard);
                vmVnicSettingsData.sriovInfo = DvsAddHostVmParser.getSriovInfo(virtualEthernetCard);
                HashMap<String, String> portgroupsNameMap = new HashMap<String, String>();
                DvsAddHostVmParser.addPortgroupsToMap(portgroupsNameMap, vmVnicSettingsQueryModel.distributedPortgroups);
                vmVnicSettingsData.portgroupName = DvsAddHostVmParser.getPortgroupName(virtualEthernetCard, portgroupsNameMap, vmVnicSettingsQueryModel.opaqueNetworks);
                vmVnicSettingsDataItems.add(vmVnicSettingsData);
            }
        }
        return vmVnicSettingsDataItems;
    }

    private static VmVnicSettingsData.SriovInfo getSriovInfo(VirtualEthernetCard device) {
        VmVnicSettingsData.SriovInfo sriovInfo = null;
        if (device instanceof VirtualSriovEthernetCard) {
            sriovInfo = new VmVnicSettingsData.SriovInfo();
            VirtualSriovEthernetCard sriovEthernetCard = (VirtualSriovEthernetCard)device;
            sriovInfo.allowGuestOsMtuChange = sriovEthernetCard.allowGuestOSMtuChange;
            VirtualSriovEthernetCard.SriovBackingInfo sriovBacking = sriovEthernetCard.sriovBacking;
            if (sriovEthernetCard.sriovBacking != null) {
                if (sriovBacking.virtualFunctionBacking != null && sriovBacking.virtualFunctionBacking.id != null) {
                    sriovInfo.virtualFunctionId = sriovBacking.virtualFunctionBacking.id;
                }
                if (sriovBacking.physicalFunctionBacking != null) {
                    sriovInfo.physicalFunctionDeviceId = sriovBacking.physicalFunctionBacking.deviceId;
                    sriovInfo.physicalFunctionId = sriovBacking.physicalFunctionBacking.id;
                }
            }
        }
        return sriovInfo;
    }

    private static String getAdapterType(VirtualEthernetCard adapter) {
        String adapterType = adapter instanceof VirtualVmxnet ? (adapter instanceof VirtualVmxnet3 ? NetworkStringUtil.getString("VnicType.vmxnet3") : (adapter instanceof VirtualVmxnet2 ? NetworkStringUtil.getString("VnicType.vmxnet2") : NetworkStringUtil.getString("VnicType.vmxnet"))) : (adapter instanceof VirtualE1000 ? NetworkStringUtil.getString("VnicType.e1000") : (adapter instanceof VirtualPCNet32 ? NetworkStringUtil.getString("VnicType.pcNet32") : (adapter instanceof VirtualE1000e ? NetworkStringUtil.getString("VnicType.e1000e") : (adapter instanceof VirtualSriovEthernetCard ? NetworkStringUtil.getString("VnicType.sriovPassthru") : NetworkStringUtil.getString("VnicType.unrecognized")))));
        return adapterType;
    }

    private static Map<String, String> createPortgroupNamesMap(Collection<DvsAddHostHostVmsModel> hostVmsModels) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (DvsAddHostHostVmsModel hostVmsModel : hostVmsModels) {
            if (hostVmsModel == null || hostVmsModel.vm == null) continue;
            for (DvsAddHostVmModel vmModel : hostVmsModel.vm) {
                if (vmModel == null) continue;
                DvsAddHostVmParser.addPortgroupsToMap(result, vmModel.distributedPortgroups);
            }
        }
        return result;
    }

    private static void addPortgroupsToMap(Map<String, String> portgroupNamesMap, VmDvPortgroupModel[] distributedPortgroups) {
        if (distributedPortgroups != null) {
            for (VmDvPortgroupModel portgroupModel : distributedPortgroups) {
                if (portgroupModel == null || portgroupModel.dvsUuid == null || portgroupModel.key == null) continue;
                String uniquePortgroupKey = DvsAddHostVmParser.getUniquePortgroupKey(portgroupModel.key, portgroupModel.dvsUuid);
                portgroupNamesMap.put(uniquePortgroupKey, portgroupModel.name);
            }
        }
    }

    private static String getUniquePortgroupKey(String portgroupKey, String dvsUuid) {
        if (portgroupKey == null || dvsUuid == null) {
            return null;
        }
        return dvsUuid + portgroupKey;
    }

    private static DvsAddHostHierarchicalListVmVnicItem createVnicItem(VirtualEthernetCard virtualEthernetCard, String parentId, ManagedObjectReference vmRef, ManagedObjectReference hostRef, Map<String, String> portgroupNamesMap, DvsVmOpaqueNetworkModel[] opaqueNetworkModels, String changeVersion) {
        if (virtualEthernetCard == null || virtualEthernetCard.deviceInfo == null || StringUtil.isNullOrEmpty((String)virtualEthernetCard.deviceInfo.label)) {
            return null;
        }
        String sourcePortgroupName = DvsAddHostVmParser.getPortgroupName(virtualEthernetCard, portgroupNamesMap, opaqueNetworkModels);
        DvsAddHostHierarchicalListVmVnicItem vnicItem = new DvsAddHostHierarchicalListVmVnicItem(virtualEthernetCard.deviceInfo.label, parentId + virtualEthernetCard.deviceInfo.label, parentId, virtualEthernetCard.key, vmRef, hostRef, sourcePortgroupName, changeVersion);
        return vnicItem;
    }

    private static String getPortgroupName(VirtualEthernetCard virtualEthernetCard, Map<String, String> portgroupNamesMap, DvsVmOpaqueNetworkModel[] opaqueNetworkModels) {
        String sourcePortgroupName = null;
        if (virtualEthernetCard.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
            VirtualEthernetCard.DistributedVirtualPortBackingInfo dvPortBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)virtualEthernetCard.backing;
            if (dvPortBacking.port != null) {
                if (!StringUtil.isNullOrEmpty((String)dvPortBacking.port.portgroupKey)) {
                    String pgKey = dvPortBacking.port.portgroupKey;
                    String switchUuid = dvPortBacking.port.switchUuid;
                    String uniquePortgroupKey = DvsAddHostVmParser.getUniquePortgroupKey(pgKey, switchUuid);
                    sourcePortgroupName = portgroupNamesMap.get(uniquePortgroupKey);
                } else if (!StringUtil.isNullOrEmpty((String)dvPortBacking.port.portKey)) {
                    sourcePortgroupName = NetworkStringUtil.getString("SelectVirtualMachinesPage.portId", dvPortBacking.port.portKey);
                }
            }
        } else if (virtualEthernetCard.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
            VirtualEthernetCard.NetworkBackingInfo networkBackingInfo = (VirtualEthernetCard.NetworkBackingInfo)virtualEthernetCard.backing;
            sourcePortgroupName = networkBackingInfo.deviceName;
        } else if (virtualEthernetCard.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
            VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueNetworkBackingInfo = (VirtualEthernetCard.OpaqueNetworkBackingInfo)virtualEthernetCard.backing;
            sourcePortgroupName = DvsAddHostVmParser.getOpaqueNetworkName(opaqueNetworkBackingInfo, opaqueNetworkModels);
        }
        return sourcePortgroupName;
    }

    private static String getOpaqueNetworkName(VirtualEthernetCard.OpaqueNetworkBackingInfo vnicBacking, DvsVmOpaqueNetworkModel[] opaqueNetworks) {
        String name = null;
        if (vnicBacking == null || opaqueNetworks == null) {
            return name;
        }
        for (DvsVmOpaqueNetworkModel dvsVmOpaqueNetworkModel : opaqueNetworks) {
            if (dvsVmOpaqueNetworkModel == null || vnicBacking.opaqueNetworkId == null || !vnicBacking.opaqueNetworkId.equals(dvsVmOpaqueNetworkModel.opaqueNetworkId) || vnicBacking.opaqueNetworkType == null || !vnicBacking.opaqueNetworkType.equals(dvsVmOpaqueNetworkModel.opaqueNetworkType)) continue;
            name = dvsVmOpaqueNetworkModel.name;
            break;
        }
        return name;
    }

    private static DvsAddHostHierarchicalListHostItem createHostItem(DvsAddHostHostVmsModel dvsAddHostHostVmsModel, boolean isMemberHost) {
        if (dvsAddHostHostVmsModel == null || dvsAddHostHostVmsModel.provider == null || !(dvsAddHostHostVmsModel.provider instanceof ManagedObjectReference) || StringUtil.isNullOrEmpty((String)dvsAddHostHostVmsModel.name)) {
            return null;
        }
        DvsAddHostHierarchicalListHostItem hostItem = new DvsAddHostHierarchicalListHostItem(dvsAddHostHostVmsModel.name, dvsAddHostHostVmsModel.provider.toString(), null, (ManagedObjectReference)dvsAddHostHostVmsModel.provider, isMemberHost);
        return hostItem;
    }

    private static DvsAddHostHierarchicalListVmItem createVmItem(DvsAddHostVmModel vmModel, String parentId, ManagedObjectReference hostRef) {
        if (vmModel == null || StringUtil.isNullOrEmpty((String)vmModel.name)) {
            return null;
        }
        DvsAddHostHierarchicalListVmItem vmItem = new DvsAddHostHierarchicalListVmItem(vmModel.name, parentId + vmModel.name, parentId, hostRef, (ManagedObjectReference)vmModel.provider, vmModel.connectionState, DvsAddHostWizardUtil.isPrimaryVm(vmModel.role));
        return vmItem;
    }

    private static void sortHostsAndVms(DvsAddHostHostVmsModel[] hostVmsModelsArray) {
        Arrays.sort(hostVmsModelsArray, new Comparator<DvsAddHostHostVmsModel>(){

            @Override
            public int compare(DvsAddHostHostVmsModel host1, DvsAddHostHostVmsModel host2) {
                if (host1 == null || host2 == null) {
                    return 0;
                }
                return ObjectUtil.compare((Comparable)((Object)host1.name), (Comparable)((Object)host2.name));
            }
        });
        for (DvsAddHostHostVmsModel hostVmsModel : hostVmsModelsArray) {
            if (hostVmsModel == null || hostVmsModel.vm == null) continue;
            Arrays.sort(hostVmsModel.vm, new Comparator<DvsAddHostVmModel>(){

                @Override
                public int compare(DvsAddHostVmModel vm1, DvsAddHostVmModel vm2) {
                    if (vm1 == null || vm2 == null) {
                        return 0;
                    }
                    return ObjectUtil.compare((Comparable)((Object)vm1.name), (Comparable)((Object)vm2.name));
                }
            });
        }
    }
}

