/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostVnicParser;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListVnicItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostVnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostsSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsAddHostVnicPropertyProvider
implements PropertyProviderBean {
    private static final String DV_PORTGROUP_NAME_PROPERTY = "config.name";
    private static final String DV_PORTGROUP_KEY_PROPERTY = "key";
    private static final String DVS_UUID_PROPERTY = "dvsUuid";
    private static final Log _logger = LogFactory.getLog(DvsAddHostVnicPropertyProvider.class);
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private QueryExecutor _queryExecutor;

    public DvsAddHostVnicPropertyProvider(QueryBindingService queryBindingService, QueryService queryService, QueryExecutor queryExecutor) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsAddHost", property="hostVnicData")
    public DvsAddHostHierarchicalListItem[] getHostVnicData(ManagedObjectReference dvsRef, DvsHostsSpec dvsHostsSpec) throws Exception {
        String dvsUuid;
        Collection result = this._queryBindingService.prepare(DvsHostVnicModel.class).fetch(Arrays.asList(dvsHostsSpec.hosts));
        DvsAddHostVnicParser.Result parserResult = DvsAddHostVnicParser.parseHostVnics(result, dvsHostsSpec.areMemberHosts, dvsUuid = (String)this._queryExecutor.getProperty((Object)dvsRef, "uuid"));
        if (parserResult == null) {
            return new DvsAddHostHierarchicalListItem[0];
        }
        if (!parserResult.distributedPortgroupKeys.isEmpty()) {
            ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
            predicateList.add(new PropertyPredicate(DV_PORTGROUP_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.IN, parserResult.distributedPortgroupKeys));
            predicateList.add(new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsRef.getServerGuid()));
            Filter filter = new Filter(predicateList);
            try {
                ResultSet dvPortgroupProperties = this._queryService.select(new String[]{DV_PORTGROUP_NAME_PROPERTY, DV_PORTGROUP_KEY_PROPERTY, DVS_UUID_PROPERTY}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(filter).fetch();
                if (dvPortgroupProperties != null) {
                    for (ResourceItem ri : dvPortgroupProperties.getItems()) {
                        String name = (String)ri.get(DV_PORTGROUP_NAME_PROPERTY);
                        String uuid = (String)ri.get(DVS_UUID_PROPERTY);
                        String key = (String)ri.get(DV_PORTGROUP_KEY_PROPERTY);
                        String uniquePortgroupIdentifier = DvsAddHostVnicParser.getUniqueDvPortgroupIdentifier(key, uuid);
                        List<DvsAddHostHierarchicalListVnicItem> itemsToUpdate = parserResult.vnicsConnectedToDvPortgroups.get(uniquePortgroupIdentifier);
                        if (itemsToUpdate == null) continue;
                        for (DvsAddHostHierarchicalListVnicItem item : itemsToUpdate) {
                            item.sourcePortgroup = name;
                            item.portgroupRef = (ManagedObjectReference)ri.getKey();
                        }
                    }
                }
            }
            catch (Exception e) {
                _logger.debug((Object)("Retrieval of distributed port group names failed: " + e.getLocalizedMessage()));
                return parserResult.treeListItems;
            }
        }
        return parserResult.treeListItems;
    }
}

