/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.editsettings;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvs.editsettings.model.DvsNameSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsEditSettingsDialogMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DvsEditSettingsDialogMutationProvider.class);
    private final String UTF_8 = "UTF-8";
    private final Integer DVS_NAME_MAX_LENGTH_BYTES = 254;
    private final String DVS_NAME_EXISTS_PROP = "dvsNameExists";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public DvsEditSettingsDialogMutationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public ValidationResult validate(ManagedObjectReference dvsRef, DvsNameSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dvsRef;
        if (spec.name == null) {
            _logger.error((Object)"The name of the distributed switch is not providedin DvsNameSpec");
            return validationResult;
        }
        byte[] byteArray = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name).getBytes("UTF-8");
        if (byteArray != null && byteArray.length > this.DVS_NAME_MAX_LENGTH_BYTES) {
            validationResult.result = NetworkStringUtil.getString("DvsConfigPage.name.tooLong");
            return validationResult;
        }
        try {
            Boolean dvsNameExists = (Boolean)NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, dvsRef, "dvsNameExists", spec.name);
            if (dvsNameExists.booleanValue()) {
                validationResult.result = NetworkStringUtil.getString("DvsConfigPage.name.duplicate");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to retrieve switchNameExists property: " + ex.getMessage()), (Throwable)ex);
        }
        return validationResult;
    }
}

