/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.export;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvsExportSpec;
import com.vmware.vsphere.client.h5.network.dvs.export.model.ExportDvsSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsExportPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DvsExportPropertyProvider.class);
    private static final String EXPORT_CONFIGURATION = "exportConfiguration";
    private static final String PARENT_DVS_PROPERTY = "config.distributedVirtualSwitch";
    private final QueryService _queryService;

    public DvsExportPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch", "DistributedVirtualPortgroup"}, propertyNamespace="dvs", property="exportDvsConfiguration")
    public byte[] getExportDvsConfiguration(ManagedObjectReference targetObjectRef, ExportDvsSpec exportDvsSpec) {
        ManagedObjectReference targetRef;
        ValidationUtil.notNull((Object)exportDvsSpec);
        exportDvsSpec.description = exportDvsSpec.description.replace("\n", "\r");
        DvsExportSpec dvsExportSpec = new DvsExportSpec();
        dvsExportSpec.description = exportDvsSpec.description;
        if (DistributedVirtualPortgroup.class.getSimpleName().equals(targetObjectRef.getType())) {
            ManagedObjectReference parentDvsMor;
            dvsExportSpec.portgroupConstraint = QueryUtil.createObjectIdentityConstraint((Object)targetObjectRef);
            targetRef = parentDvsMor = (ManagedObjectReference)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)targetObjectRef, (String)PARENT_DVS_PROPERTY);
        } else {
            if (exportDvsSpec.includePortGroups) {
                dvsExportSpec.portgroupConstraint = QueryUtil.createRelationalConstraint((String)"portgroup", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)targetObjectRef), (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
            }
            targetRef = targetObjectRef;
        }
        ResultSet result = this._queryService.select(new String[]{EXPORT_CONFIGURATION}).from(new String[]{targetRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("exportConfiguration/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsExportSpec), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetRef)}).fetch();
        if (result.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resultItem = (ResourceItem)result.getItems().get(0);
        if (resultItem != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
            return (byte[])resultItem.getPropertyValues().get(0);
        }
        return null;
    }
}

