/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.lacp;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvs.lacp.model.LagCreateModel;
import com.vmware.vsphere.client.h5.network.dvs.lacp.model.LagEditModel;
import com.vmware.vsphere.client.h5.network.dvs.lacp.queries.LagCreateData;
import java.util.Arrays;

public class LacpPropertyProvider
implements PropertyProviderBean {
    private QueryBindingService queryBindingService;

    public LacpPropertyProvider(QueryBindingService queryBindingService) {
        this.queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="lacp", property="lagEditModel")
    public LagEditModel getLagEditModel(ManagedObjectReference dvsMor, final String lagKey) {
        LagCreateData data2 = (LagCreateData)this.queryBindingService.prepare(LagCreateData.class).fetch((Object)dvsMor);
        LagEditModel model = new LagEditModel();
        VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig = (VmwareDistributedVirtualSwitch.LacpGroupConfig)Iterables.find(Arrays.asList(data2.lacpGroupConfigs), (Predicate)new Predicate<VmwareDistributedVirtualSwitch.LacpGroupConfig>(){

            public boolean apply(VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig) {
                return lagKey.equals(lacpGroupConfig.key);
            }
        });
        model.lagName = lacpGroupConfig.name;
        model.mode = lacpGroupConfig.mode;
        model.uplinkNum = lacpGroupConfig.uplinkNum;
        model.loadBalancingMode = lacpGroupConfig.loadbalanceAlgorithm;
        boolean bl = model.overrideVlan = lacpGroupConfig.vlan != null && lacpGroupConfig.vlan.vlanId != null;
        if (model.overrideVlan) {
            model.vlanTrunkRanges = lacpGroupConfig.vlan.vlanId;
        }
        boolean bl2 = model.overrideNetFlow = lacpGroupConfig.ipfix != null && lacpGroupConfig.ipfix.ipfixEnabled != null;
        if (model.overrideNetFlow) {
            model.netFlowEnabled = lacpGroupConfig.ipfix.ipfixEnabled;
        }
        model.maxUplinkNum = data2.availableUplinkCount + lacpGroupConfig.uplinkNum;
        model.overrideNetFlowAllowed = data2.overrideNetFlowAllowed;
        model.overrideVlanAllowed = data2.overrideVlanAllowed;
        model.loadBalanceAlgorithms = Collections2.transform(Arrays.asList(VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm.values()), (Function)new Function<VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm, String>(){

            public String apply(VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm lacpLoadBalanceAlgorithm) {
                return lacpLoadBalanceAlgorithm.toString();
            }
        });
        return model;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="lacp", property="lagCreateModel")
    public LagCreateModel getLagCreateModel(ManagedObjectReference dvsMor) {
        LagCreateData data2 = (LagCreateData)this.queryBindingService.prepare(LagCreateData.class).fetch((Object)dvsMor);
        LagCreateModel model = new LagCreateModel();
        model.maxUplinkNum = data2.availableUplinkCount;
        model.overrideNetFlowAllowed = data2.overrideNetFlowAllowed;
        model.overrideVlanAllowed = data2.overrideVlanAllowed;
        model.uniqueName = this.getUniqueName(data2.lacpGroupConfigs);
        model.loadBalanceAlgorithms = Collections2.transform(Arrays.asList(VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm.values()), (Function)new Function<VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm, String>(){

            public String apply(VmwareDistributedVirtualSwitch.LacpLoadBalanceAlgorithm lacpLoadBalanceAlgorithm) {
                return lacpLoadBalanceAlgorithm.toString();
            }
        });
        return model;
    }

    private String getUniqueName(VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs) {
        if (lacpGroupConfigs == null) {
            lacpGroupConfigs = new VmwareDistributedVirtualSwitch.LacpGroupConfig[]{};
        }
        String defaultName = null;
        int i = 1;
        boolean isNameOccupied = true;
        while (isNameOccupied) {
            final String candidate = String.format("lag%s", i);
            isNameOccupied = Iterables.any(Arrays.asList(lacpGroupConfigs), (Predicate)new Predicate<VmwareDistributedVirtualSwitch.LacpGroupConfig>(){

                public boolean apply(VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig) {
                    return candidate.equals(lacpGroupConfig.name);
                }
            });
            defaultName = candidate;
            ++i;
        }
        return defaultName;
    }
}

