/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.DvsPortMirroringPropertyProviderParser;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringDestinationPorts;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringSessionData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringSourcePorts;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringSpec;
import com.vmware.vsphere.client.h5.network.util.DvsPortMirrorUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.List;

public class DvsPortMirroringPropertyProvider
implements PropertyProviderBean {
    private static final String VSPAN_CAPABILITIES_PROP = "capability/featuresSupported/vspanCapability";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private DvsPortMirroringPropertyProviderParser _propertyProviderParser;

    public DvsPortMirroringPropertyProvider(QueryBindingService queryBindingService, QueryExecutor queryExecutor, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._propertyProviderParser = new DvsPortMirroringPropertyProviderParser(queryExecutor);
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portMirroringDetails")
    public DvsPortMirroringData getDistributedSwitchPortMirroringDetails(ManagedObjectReference dvsMor) {
        DvsPortMirroringData dvsPortMirroringData = new DvsPortMirroringData();
        DvsPortMirroringQueryBinding dvsPortMirroringQueryData = (DvsPortMirroringQueryBinding)this._queryBindingService.prepare(DvsPortMirroringQueryBinding.class).fetch((Object)dvsMor);
        if (dvsPortMirroringQueryData == null) {
            return null;
        }
        if (dvsPortMirroringQueryData.vspanCapabilities == null || !dvsPortMirroringQueryData.vspanSupported) {
            return null;
        }
        if (dvsPortMirroringQueryData.vspanSessions != null && dvsPortMirroringQueryData.vspanSessions.length != 0) {
            ArrayList<DvsPortMirroringSessionData> sessionsData = new ArrayList<DvsPortMirroringSessionData>();
            for (VmwareDistributedVirtualSwitch.VspanSession session : dvsPortMirroringQueryData.vspanSessions) {
                DvsPortMirroringSessionData sessionData = new DvsPortMirroringSessionData();
                sessionData.key = session.key;
                sessionData.name = !StringUtil.isNullOrEmpty((String)session.name) ? MixedUtil.unescapeVimEntityNameSpecialChars((String)session.name) : null;
                sessionData.enabled = session.enabled ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                sessionData.sessionType = DvsPortMirrorUtil.formatDvsPortMirrorSessionType(session.sessionType);
                if (VmwareDistributedVirtualSwitch.VspanSessionType.dvPortMirror.toString().equals(session.sessionType)) {
                    sessionData.isDvPortMirrorSession = true;
                } else if (VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorDest.toString().equals(session.sessionType)) {
                    sessionData.isRemoteDestinationSession = true;
                } else if (VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorSource.toString().equals(session.sessionType)) {
                    sessionData.isRemoteSourceSession = true;
                } else if (VmwareDistributedVirtualSwitch.VspanSessionType.encapsulatedRemoteMirrorSource.toString().equals(session.sessionType)) {
                    sessionData.isEncapsulatedSession = true;
                } else if (VmwareDistributedVirtualSwitch.VspanSessionType.mixedDestMirror.toString().equals(session.sessionType)) {
                    sessionData.isLegacySession = true;
                }
                sessionsData.add(sessionData);
            }
            dvsPortMirroringData.portMirroringSessionsData = sessionsData.toArray(new DvsPortMirroringSessionData[sessionsData.size()]);
        }
        return dvsPortMirroringData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portMirroringSessionDetails")
    public DvsPortMirroringSessionData getDistributedSwitchPortMirroringSessionDetails(ManagedObjectReference dvsMor, DvsPortMirroringSpec spec) {
        DvsPortMirroringQueryBinding dvsPortMirroringQueryData = (DvsPortMirroringQueryBinding)this._queryBindingService.prepare(DvsPortMirroringQueryBinding.class).fetch((Object)dvsMor);
        if (dvsPortMirroringQueryData == null) {
            return null;
        }
        if (spec == null || spec.sessionKey == null) {
            return null;
        }
        if (dvsPortMirroringQueryData.vspanCapabilities == null || !dvsPortMirroringQueryData.vspanSupported) {
            return null;
        }
        DvsPortMirroringSessionData sessionData = null;
        if (dvsPortMirroringQueryData.vspanSessions != null) {
            for (VmwareDistributedVirtualSwitch.VspanSession session : dvsPortMirroringQueryData.vspanSessions) {
                if (!spec.sessionKey.equals(session.key)) continue;
                sessionData = new DvsPortMirroringSessionData();
                sessionData.name = !StringUtil.isNullOrEmpty((String)session.name) ? MixedUtil.unescapeVimEntityNameSpecialChars((String)session.name) : null;
                sessionData.enabled = session.enabled ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                sessionData.sessionType = DvsPortMirrorUtil.formatDvsPortMirrorSessionType(session.sessionType);
                if (session.mirroredPacketLength != null) {
                    this._propertyProviderParser.parseMirroredPacketLength(session, sessionData);
                } else {
                    sessionData.mirroredPacketLength = NetworkStringUtil.getString("na");
                }
                sessionData.sessionId = -1;
                sessionData.isRemoteDestinationSession = VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorDest.name().equals(session.sessionType);
                sessionData.isRemoteSourceSession = VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorSource.name().equals(session.sessionType);
                sessionData.isDvPortMirrorSession = VmwareDistributedVirtualSwitch.VspanSessionType.dvPortMirror.name().equals(session.sessionType);
                sessionData.isEncapsulatedSession = VmwareDistributedVirtualSwitch.VspanSessionType.encapsulatedRemoteMirrorSource.name().equals(session.sessionType);
                sessionData.isLegacySession = VmwareDistributedVirtualSwitch.VspanSessionType.mixedDestMirror.name().equals(session.sessionType);
                this._propertyProviderParser.parseSessionPropertiesBasedOnSessionType(session, sessionData);
                sessionData.description = !StringUtil.isNullOrEmpty((String)session.description) ? session.description : null;
            }
        }
        return sessionData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portMirroringSourcePortsDetails")
    public DvsPortMirroringSourcePorts getDvSwitchPortMirroringSourcePortsDetails(ManagedObjectReference dvsMor, DvsPortMirroringSpec spec) {
        DvsPortMirroringQueryBinding dvsPortMirroringQueryData = this.getDvsPortMirroringQueryBinding(dvsMor);
        if (dvsPortMirroringQueryData != null && (spec == null || spec.sessionKey == null)) {
            return null;
        }
        DvsPortMirroringSourcePorts sourcePortsSessionData = null;
        if (dvsPortMirroringQueryData != null && dvsPortMirroringQueryData.vspanSessions != null) {
            for (VmwareDistributedVirtualSwitch.VspanSession session : dvsPortMirroringQueryData.vspanSessions) {
                if (!spec.sessionKey.equals(session.key)) continue;
                sourcePortsSessionData = new DvsPortMirroringSourcePorts();
                this._propertyProviderParser.parseSourcePortData(dvsMor, session, sourcePortsSessionData);
            }
        }
        return sourcePortsSessionData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portMirroringDestinationPortsDetails")
    public DvsPortMirroringDestinationPorts getDvSwitchPortMirroringDestinationPortsDetails(ManagedObjectReference dvsMor, DvsPortMirroringSpec spec) {
        DvsPortMirroringQueryBinding dvsPortMirroringQueryData = this.getDvsPortMirroringQueryBinding(dvsMor);
        if (dvsPortMirroringQueryData != null && (spec == null || spec.sessionKey == null)) {
            return null;
        }
        DvsPortMirroringDestinationPorts destinationPortsSessionData = null;
        if (dvsPortMirroringQueryData != null && dvsPortMirroringQueryData.vspanSessions != null) {
            for (VmwareDistributedVirtualSwitch.VspanSession session : dvsPortMirroringQueryData.vspanSessions) {
                if (!spec.sessionKey.equals(session.key)) continue;
                destinationPortsSessionData = new DvsPortMirroringDestinationPorts();
                this._propertyProviderParser.parseDestinationPortData(dvsMor, session, destinationPortsSessionData);
            }
        }
        return destinationPortsSessionData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="isAnySpanSessionSupported")
    public Boolean getIsAnySpanSessionSupported(ManagedObjectReference dvsMor) {
        ResultSet resultSet = this._queryService.select(new String[]{VSPAN_CAPABILITIES_PROP}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        List resultItems = resultSet.getItems();
        if (!resultItems.isEmpty()) {
            VmwareDistributedVirtualSwitch.VspanFeatureCapability capabilities = (VmwareDistributedVirtualSwitch.VspanFeatureCapability)((ResourceItem)resultItems.get(0)).get(VSPAN_CAPABILITIES_PROP);
            return capabilities.dvportSupported || capabilities.encapRemoteSourceSupported || capabilities.remoteDestSupported || capabilities.remoteSourceSupported;
        }
        return false;
    }

    private DvsPortMirroringQueryBinding getDvsPortMirroringQueryBinding(ManagedObjectReference dvsMor) {
        DvsPortMirroringQueryBinding dvsPortMirroringQueryData = (DvsPortMirroringQueryBinding)this._queryBindingService.prepare(DvsPortMirroringQueryBinding.class).fetch((Object)dvsMor);
        if (dvsPortMirroringQueryData == null) {
            return null;
        }
        if (dvsPortMirroringQueryData.vspanCapabilities == null || !dvsPortMirroringQueryData.vspanSupported) {
            return null;
        }
        return dvsPortMirroringQueryData;
    }
}

