/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.dvs.api.spec.DistributedVirtualPortFilterSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.DvsPortMirroringPropertyProvider;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringDestinationPorts;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringPortData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringSessionData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringSourcePorts;
import com.vmware.vsphere.client.h5.network.util.DvsPortMirrorUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsPortMirroringPropertyProviderParser {
    private static final String DVPORT_KEY_PROPERTY_NAME = "key";
    private static final String DVPORT_CONNECTED_ENTITY_PROPERTY_NAME = "connectedEntityName";
    private static final String DVPORT_CONNECTEE_PROPERTY_NAME = "connectee";
    private static final String DVPORT_PROXY_HOST_PROPERTY_NAME = "proxyHostName";
    private static final String HOST_VMK_VNIC_CONNECTEE_TYPE = "hostVmkVnic";
    private static final String HOST_PNIC_CONNECTEE_TYPE = "pnic";
    private static final String VM_VNIC_CONNECTEE_TYPE = "vmVnic";
    private static final Log _logger = LogFactory.getLog(DvsPortMirroringPropertyProvider.class);
    private QueryExecutor _queryExecutor;

    public DvsPortMirroringPropertyProviderParser(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public void parseMirroredPacketLength(VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSessionData sessionData) {
        if (session.mirroredPacketLength > 9000 || session.mirroredPacketLength != -1 && session.mirroredPacketLength < 60) {
            throw new IllegalArgumentException("Mirrored packet length should be between 60 and 9000");
        }
        sessionData.mirroredPacketLength = session.mirroredPacketLength != -1 ? NetworkStringUtil.getString("dvPortMirror.packet.length", String.valueOf(session.mirroredPacketLength)) : NetworkStringUtil.getString("na");
    }

    public void parseSessionPropertiesBasedOnSessionType(VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSessionData sessionData) {
        if (VmwareDistributedVirtualSwitch.VspanSessionType.encapsulatedRemoteMirrorSource.name().equals(session.sessionType)) {
            this.fillEncapsulationTypeAndSessionId(session, sessionData);
        } else {
            String string = sessionData.normalTrafficOnDestPorts = session.normalTrafficAllowed ? NetworkStringUtil.getString("dvPortMirror.normalTraffix.allowed") : NetworkStringUtil.getString("dvPortMirror.normalTraffix.disallowed");
        }
        if (VmwareDistributedVirtualSwitch.VspanSessionType.mixedDestMirror.name().equals(session.sessionType) || VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorSource.name().equals(session.sessionType)) {
            String string = sessionData.preserveOriginalVlan = !session.stripOriginalVlan ? NetworkStringUtil.getString("yes") : NetworkStringUtil.getString("no");
            if (session.encapsulationVlanId != null) {
                sessionData.encapsulationVlanId = session.encapsulationVlanId != 0 ? String.valueOf(session.encapsulationVlanId) : NetworkStringUtil.getString("na");
                String string2 = sessionData.preserveOriginalVlan = session.encapsulationVlanId != 0 ? sessionData.preserveOriginalVlan : null;
            }
        }
        if (!VmwareDistributedVirtualSwitch.VspanSessionType.mixedDestMirror.name().equals(session.sessionType)) {
            this.fillSamplingRate(session, sessionData);
        }
    }

    private void fillEncapsulationTypeAndSessionId(VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSessionData sessionData) {
        if (session.encapType != null) {
            sessionData.encapsulationType = DvsPortMirrorUtil.formatDvsPortMirrorEncapsulationType(session.encapType);
            if (!VmwareDistributedVirtualSwitch.VspanSessionEncapType.gre.name().equals(session.encapType)) {
                if (session.erspanId == null || session.erspanId > 1023 || session.erspanId < 0) {
                    throw new IllegalArgumentException("ERSPAN ID should be between 0 and 1023");
                }
                sessionData.sessionId = session.erspanId;
            }
        }
        if (session.netstack != null) {
            sessionData.tcpIpStack = DvsPortMirrorUtil.formatDvsPortMirrorNetStack(session.netstack);
        }
    }

    private void fillSamplingRate(VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSessionData sessionData) {
        if (session.samplingRate == null) {
            return;
        }
        if (session.samplingRate > 65535 || session.samplingRate < 1) {
            throw new IllegalArgumentException("Sampling rate for the vspan session must be set and between 1 and 65535");
        }
        sessionData.samplingRate = NetworkStringUtil.getString("dvPortMirror.sampling.rate", String.valueOf(session.samplingRate));
    }

    public void parseSourcePortData(ManagedObjectReference dvsMor, VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSourcePorts sourcePortsSessionData) {
        if (!(VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorDest.name().equals(session.sessionType) || session.sourcePortReceived == null && session.sourcePortTransmitted == null)) {
            this.fillNonRemoteDestinationPortsData(dvsMor, session, sourcePortsSessionData);
        } else if (VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorDest.name().equals(session.sessionType) && session.sourcePortReceived != null) {
            this.fillRemoteDestinationPortData(session, sourcePortsSessionData);
        }
    }

    public void parseDestinationPortData(ManagedObjectReference dvsMor, VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringDestinationPorts destinationPortsSessionData) {
        DvsPortMirroringPortData portData;
        VmwareDistributedVirtualSwitch.VspanPorts destinationPort = session.destinationPort;
        if (destinationPort == null) {
            return;
        }
        ArrayList<DvsPortMirroringPortData> portsData = new ArrayList<DvsPortMirroringPortData>();
        if (!ArrayUtil.isNullOrEmpty((Object[])destinationPort.portKey)) {
            ResultSet resultSet = this.getDvPortComputedProperties(dvsMor, destinationPort.portKey);
            portsData.addAll(this.formatDvPortDataFromResultSet(resultSet, null, null, null));
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])destinationPort.uplinkPortName)) {
            for (String uplinkName : destinationPort.uplinkPortName) {
                portData = new DvsPortMirroringPortData();
                portData.isUplinkPort = true;
                portData.portKey = uplinkName;
                portData.connectedEntityName = NetworkStringUtil.getString("na");
                portData.hostProxyName = NetworkStringUtil.getString("na");
                portsData.add(portData);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])destinationPort.ipAddress)) {
            for (String ipAddress : destinationPort.ipAddress) {
                portData = new DvsPortMirroringPortData();
                portData.ipAddress = ipAddress;
                portsData.add(portData);
            }
            Collections.sort(portsData, new Comparator<DvsPortMirroringPortData>(){

                @Override
                public int compare(DvsPortMirroringPortData port1, DvsPortMirroringPortData port2) {
                    return port1.ipAddress.compareTo(port2.ipAddress);
                }
            });
        }
        if (!portsData.isEmpty()) {
            destinationPortsSessionData.destinationPortData = portsData.toArray(new DvsPortMirroringPortData[portsData.size()]);
        }
    }

    private void fillNonRemoteDestinationPortsData(ManagedObjectReference dvsMor, VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSourcePorts sourcePortsSessionData) {
        VmwareDistributedVirtualSwitch.VspanPorts sourcePortReceived = session.sourcePortReceived;
        VmwareDistributedVirtualSwitch.VspanPorts sourcePortTransmitted = session.sourcePortTransmitted;
        if (sourcePortReceived != null && sourcePortReceived.portKey == null && sourcePortTransmitted.portKey == null) {
            return;
        }
        ArrayList<String> bothDirectionsPorts = new ArrayList<String>();
        ArrayList<String> egressPorts = null;
        ArrayList<String> ingressPorts = null;
        if (sourcePortReceived != null && !ArrayUtil.isNullOrEmpty((Object[])sourcePortReceived.portKey)) {
            ingressPorts = new ArrayList<String>();
            ingressPorts.addAll(Arrays.asList(sourcePortReceived.portKey));
        }
        if (sourcePortTransmitted != null && !ArrayUtil.isNullOrEmpty((Object[])sourcePortTransmitted.portKey)) {
            egressPorts = new ArrayList<String>();
            egressPorts.addAll(Arrays.asList(sourcePortTransmitted.portKey));
        }
        if (!ArrayUtil.isNullOrEmpty(egressPorts) && !ArrayUtil.isNullOrEmpty(ingressPorts)) {
            for (String ingressPort : ingressPorts) {
                if (!egressPorts.contains(ingressPort)) continue;
                bothDirectionsPorts.add(ingressPort);
            }
            if (!ArrayUtil.isNullOrEmpty(bothDirectionsPorts)) {
                ingressPorts.removeAll(bothDirectionsPorts);
                egressPorts.removeAll(bothDirectionsPorts);
            }
        }
        ArrayList<String> allPorts = new ArrayList<String>();
        if (!ArrayUtil.isNullOrEmpty(ingressPorts)) {
            allPorts.addAll(ingressPorts);
        }
        if (!ArrayUtil.isNullOrEmpty(egressPorts)) {
            allPorts.addAll(egressPorts);
        }
        if (!ArrayUtil.isNullOrEmpty(bothDirectionsPorts)) {
            allPorts.addAll(bothDirectionsPorts);
        }
        ResultSet resultSet = this.getDvPortComputedProperties(dvsMor, allPorts.toArray(new String[allPorts.size()]));
        ArrayList<DvsPortMirroringPortData> portsData = this.formatDvPortDataFromResultSet(resultSet, ingressPorts, egressPorts, bothDirectionsPorts);
        sourcePortsSessionData.sourcePortData = portsData.toArray(new DvsPortMirroringPortData[portsData.size()]);
    }

    private void fillRemoteDestinationPortData(VmwareDistributedVirtualSwitch.VspanSession session, DvsPortMirroringSourcePorts sourcePortsSessionData) {
        VmwareDistributedVirtualSwitch.VspanPorts sourcePortReceived = session.sourcePortReceived;
        if (sourcePortReceived.vlans == null) {
            return;
        }
        ArrayList<DvsPortMirroringPortData> portsData = new ArrayList<DvsPortMirroringPortData>();
        int[] nArray = sourcePortReceived.vlans;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer vlanId = nArray[i];
            DvsPortMirroringPortData sourcePortData = new DvsPortMirroringPortData();
            sourcePortData.vlan = vlanId;
            portsData.add(sourcePortData);
        }
        sourcePortsSessionData.sourcePortData = portsData.toArray(new DvsPortMirroringPortData[portsData.size()]);
    }

    private ResultSet getDvPortComputedProperties(ManagedObjectReference dvsMor, String[] portKeys) {
        ResultSet resultSet = null;
        try {
            PortCriteria portCriteria = new PortCriteria();
            if (portKeys != null && portKeys.length > 0) {
                portCriteria.portKey = portKeys;
            }
            DistributedVirtualPortFilterSpec filter = new DistributedVirtualPortFilterSpec();
            filter.dvs = dvsMor;
            filter.portCriteria = portCriteria;
            Constraint constraint = new Constraint();
            constraint.targetType = "DVPort";
            ParameterSpec paramSpec = new ParameterSpec();
            paramSpec.propertyName = DVPORT_KEY_PROPERTY_NAME;
            paramSpec.parameter = filter;
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.propertyNames = new String[]{DVPORT_CONNECTED_ENTITY_PROPERTY_NAME, DVPORT_CONNECTEE_PROPERTY_NAME, DVPORT_KEY_PROPERTY_NAME, DVPORT_PROXY_HOST_PROPERTY_NAME};
            propertySpec.parameters = new ParameterSpec[]{paramSpec};
            propertySpec.type = "DVPort";
            ResourceSpec resourceSpec = new ResourceSpec();
            resourceSpec.constraint = constraint;
            resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
            QuerySpec querySpec = new QuerySpec();
            querySpec.resourceSpec = resourceSpec;
            querySpec.name = "CustomPortListQueryForH5C";
            resultSet = this._queryExecutor.getData(querySpec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception while getting data for CustomPortListQueryForH5C", (Throwable)ex);
        }
        return resultSet;
    }

    private ArrayList<DvsPortMirroringPortData> formatDvPortDataFromResultSet(ResultSet dvPortPropertiesResultSet, List<String> ingressPorts, List<String> egressPorts, List<String> bothDirectionsPorts) {
        ArrayList<DvsPortMirroringPortData> portsData = new ArrayList<DvsPortMirroringPortData>();
        String naData = NetworkStringUtil.getString("na");
        if (dvPortPropertiesResultSet != null && !ArrayUtil.isNullOrEmpty((Object[])dvPortPropertiesResultSet.items)) {
            for (ResultItem resultItem : dvPortPropertiesResultSet.items) {
                DvsPortMirroringPortData portData = new DvsPortMirroringPortData();
                for (PropertyValue property : resultItem.properties) {
                    if (property.propertyName.equals(DVPORT_CONNECTED_ENTITY_PROPERTY_NAME)) {
                        String string = portData.connectedEntityName = property.value != null ? property.value.toString() : naData;
                    }
                    if (property.propertyName.equals(DVPORT_CONNECTEE_PROPERTY_NAME) && property.value != null && property.value instanceof PortConnectee) {
                        PortConnectee portConnectee = (PortConnectee)property.value;
                        switch (portConnectee.type) {
                            case "hostVmkVnic": {
                                portData.connectedEntityName = portConnectee.nicKey;
                                portData.connecteeIconId = "network-lib-ui-icon-virtualAdapter";
                                break;
                            }
                            case "pnic": {
                                portData.connectedEntityName = portConnectee.nicKey;
                                portData.connecteeIconId = "network-lib-ui-icon-physicalAdapter";
                                break;
                            }
                            case "vmVnic": {
                                portData.connecteeIconId = "vsphere-icon-vm";
                            }
                        }
                    }
                    if (property.propertyName.equals(DVPORT_PROXY_HOST_PROPERTY_NAME)) {
                        portData.hostProxyName = property.value != null ? property.value.toString() : naData;
                        String string = portData.hostIcon = property.value != null ? "vsphere-icon-host" : null;
                    }
                    if (!property.propertyName.equals(DVPORT_KEY_PROPERTY_NAME)) continue;
                    portData.portKey = property.value.toString();
                    if (!ArrayUtil.isNullOrEmpty(ingressPorts) && ingressPorts.contains(portData.portKey)) {
                        portData.trafficDirection = NetworkStringUtil.getString("dvPortMirror.trafficDirection.ingress");
                        portData.trafficDirectionIconId = "network-lib-ui-icon-ingressTraffic";
                    }
                    if (!ArrayUtil.isNullOrEmpty(egressPorts) && egressPorts.contains(portData.portKey)) {
                        portData.trafficDirection = NetworkStringUtil.getString("dvPortMirror.trafficDirection.egress");
                        portData.trafficDirectionIconId = "network-lib-ui-icon-egressTraffic";
                    }
                    if (ArrayUtil.isNullOrEmpty(bothDirectionsPorts) || !bothDirectionsPorts.contains(portData.portKey)) continue;
                    portData.trafficDirection = NetworkStringUtil.getString("dvPortMirror.trafficDirection.both");
                    portData.trafficDirectionIconId = "network-lib-ui-icon-ingressEgressTraffic";
                }
                portsData.add(portData);
            }
        }
        return portsData;
    }
}

