/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.dvs.api.spec.VmResControlConfigInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmVnicInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmVnicSpec;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsVmVnicResourceSettingsDialogData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.Collection;
import java.util.List;

public class DvsVmVnicResourceSettingsDialogPropertyProvider
implements PropertyProviderBean {
    private static final String DATA_PROPERTY = "resourceControlVmConfig";
    private final QueryService _queryService;

    public DvsVmVnicResourceSettingsDialogPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="vmVnicResourceSettingsDialogData")
    public DvsVmVnicResourceSettingsDialogData getVmVnicResourceSettingsDialogData(ManagedObjectReference dvsMor, VmVnicInfoSpec[] specs) {
        VmResControlConfigInfoSpec vmResControlConfigInfoSpec;
        if (ArrayUtil.isNullOrEmpty((Object[])specs)) {
            throw new IllegalArgumentException("No VmVnicInfoSpecs provided");
        }
        ResultSet resultSet = this._queryService.select(new String[]{DATA_PROPERTY}).from(new String[]{dvsMor.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("resourceControlVmConfig/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)specs), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        DvsVmVnicResourceSettingsDialogData dialogData = new DvsVmVnicResourceSettingsDialogData();
        List resourceItems = resultSet.getItems();
        if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (vmResControlConfigInfoSpec = (VmResControlConfigInfoSpec)((ResourceItem)resourceItems.get(0)).get(DATA_PROPERTY)) != null) {
            dialogData = this.createDialogData(vmResControlConfigInfoSpec);
        }
        return dialogData;
    }

    private DvsVmVnicResourceSettingsDialogData createDialogData(VmResControlConfigInfoSpec configInfoSpec) {
        int nicCount = 0;
        int excludedNicCount = 0;
        VmVnicSpec vmVnicSpec = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])configInfoSpec.vmVnicSpec)) {
            for (VmVnicSpec vnicSpec : configInfoSpec.vmVnicSpec) {
                if (vnicSpec == null) continue;
                int missingDeviceCount = vnicSpec.missingDeviceKeys != null ? vnicSpec.missingDeviceKeys.length : 0;
                int deviceCount = vnicSpec.networkAdapters != null ? vnicSpec.networkAdapters.length : 0;
                excludedNicCount += missingDeviceCount;
                if (vnicSpec.deviceEditingAllowed) {
                    nicCount += deviceCount;
                    if (vmVnicSpec != null || deviceCount <= 0) continue;
                    vmVnicSpec = vnicSpec;
                    continue;
                }
                excludedNicCount += deviceCount;
            }
        }
        DvsVmVnicResourceSettingsDialogData dialogData = this.createDialogDataFromVnicSpec(vmVnicSpec, nicCount, configInfoSpec.highShareValue);
        if (nicCount == 0) {
            dialogData.serverError = excludedNicCount == 0 ? NetworkStringUtil.getString("vmVnicDialog.error.data.retrieval") : (excludedNicCount == 1 ? NetworkStringUtil.getString("vmVnicDialog.error.operationNotApplicable") : NetworkStringUtil.getString("vmVnicDialog.error.operationNotApplicablePlural"));
        } else if (excludedNicCount > 0) {
            dialogData.serverWarning = NetworkStringUtil.getString("vmVnicDialog.warning.operationNotApplicable");
        }
        dialogData.highSharesValue = configInfoSpec.highShareValue;
        dialogData.vnicSpecs = configInfoSpec.vmVnicSpec;
        dialogData.maxReservation = configInfoSpec.maxReservation;
        return dialogData;
    }

    private DvsVmVnicResourceSettingsDialogData createDialogDataFromVnicSpec(VmVnicSpec vmVnicSpec, int nicCount, int highShares) {
        DvsVmVnicResourceSettingsDialogData dialogData = new DvsVmVnicResourceSettingsDialogData();
        if (nicCount == 1) {
            VirtualEthernetCard.ResourceAllocation allocation = vmVnicSpec.networkAdapters[0].resourceAllocation;
            if (allocation != null && allocation.share != null) {
                if (allocation.share.level != null) {
                    dialogData.sharesLevel = allocation.share.level.name();
                }
                dialogData.sharesValue = allocation.share.shares;
                dialogData.reservation = allocation.reservation;
                dialogData.limit = allocation.limit;
            }
        } else {
            dialogData.sharesValue = highShares / 2;
            dialogData.sharesLevel = SharesInfo.Level.normal.name();
            dialogData.reservation = 0L;
            dialogData.limit = -1L;
        }
        return dialogData;
    }
}

