/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.dvs.api.info.DvsResControlStatistics;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficEditDialogData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficEditDialogQueryBinding;

public class DvsSystemTrafficEditDialogPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public DvsSystemTrafficEditDialogPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="systemTrafficEditDialogData")
    public DvsSystemTrafficEditDialogData getSystemTrafficDialogData(ManagedObjectReference dvsMor, String systemTrafficTypeKey) throws IllegalArgumentException {
        DvsSystemTrafficEditDialogData dialogData = new DvsSystemTrafficEditDialogData();
        if (systemTrafficTypeKey == null) {
            throw new IllegalArgumentException("No infrastructure traffic type specified");
        }
        DvsSystemTrafficEditDialogQueryBinding queryBinding = (DvsSystemTrafficEditDialogQueryBinding)this._queryBindingService.prepare(DvsSystemTrafficEditDialogQueryBinding.class).fetch((Object)dvsMor);
        if (queryBinding != null) {
            dialogData.configVersion = queryBinding.configVersion;
            DistributedVirtualSwitch.HostInfrastructureTrafficResource resource = this.getInfrastructureTrafficResource(queryBinding.infrastructureTrafficResource, systemTrafficTypeKey);
            if (resource != null && resource.allocationInfo != null) {
                dialogData.limit = resource.allocationInfo.limit;
                dialogData.reservation = resource.allocationInfo.reservation;
                if (resource.allocationInfo.shares != null) {
                    dialogData.sharesLevel = resource.allocationInfo.shares.level != null ? resource.allocationInfo.shares.level.toString() : null;
                    dialogData.sharesValue = resource.allocationInfo.shares.shares;
                }
            }
            if (queryBinding.resControlStatistics != null) {
                DvsResControlStatistics stats = queryBinding.resControlStatistics;
                dialogData.minLinkSpeed = stats.minPnicLinkSpeed;
                dialogData.availableBandwidth = (int)((float)stats.pnicCapacityRatio / 100.0f * (float)stats.minPnicLinkSpeed);
                if (dialogData.reservation != null) {
                    DvsSystemTrafficEditDialogData dvsSystemTrafficEditDialogData = dialogData;
                    dvsSystemTrafficEditDialogData.availableBandwidth = dvsSystemTrafficEditDialogData.availableBandwidth + dialogData.reservation.intValue();
                }
                if (stats.reservedInfrastructureTrafficBandwidth > 0) {
                    dialogData.availableBandwidth = Math.max(dialogData.availableBandwidth - stats.reservedInfrastructureTrafficBandwidth, 0);
                }
            }
        }
        return dialogData;
    }

    private DistributedVirtualSwitch.HostInfrastructureTrafficResource getInfrastructureTrafficResource(DistributedVirtualSwitch.HostInfrastructureTrafficResource[] resources, String key) {
        if (!ArrayUtil.isNullOrEmpty((Object[])resources)) {
            for (DistributedVirtualSwitch.HostInfrastructureTrafficResource resource : resources) {
                if (!key.equals(resource.key)) continue;
                return resource;
            }
        }
        return null;
    }
}

