/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.summary;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.dvs.api.host.DvsHostsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.HostListItemHelper;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.DvsMemberHostsModel;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsFeaturesPortletData;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsFeaturesQueryBinding;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class DvsSummaryPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private final HostListItemHelper _hostListItemHelper;

    public DvsSummaryPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, HostListItemHelper hostListItemHelper) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._hostListItemHelper = hostListItemHelper;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="featuresPortletData")
    public DvsFeaturesPortletData getFeaturesPortletData(ManagedObjectReference dvsMor) {
        DvsFeaturesQueryBinding featuresData = (DvsFeaturesQueryBinding)((Object)this._queryBindingService.prepare(DvsFeaturesQueryBinding.class).fetch((Object)dvsMor));
        if (featuresData == null) {
            return null;
        }
        DvsFeaturesPortletData portletData = new DvsFeaturesPortletData();
        portletData.lacpApiVersion = featuresData.lacpApiVersion;
        portletData.networkResourceManagementVersion = featuresData.networkResourceManagementVersion;
        if (featuresData.featureCapability != null) {
            portletData.niocSupported = featuresData.featureCapability.networkResourceManagementCapability != null && featuresData.featureCapability.networkResourceManagementCapability.networkResourceManagementSupported;
            portletData.isVmwareDvs = featuresData.featureCapability instanceof VmwareDistributedVirtualSwitch.FeatureCapability;
            if (portletData.isVmwareDvs) {
                VmwareDistributedVirtualSwitch.FeatureCapability vmwareFeatureCapability = (VmwareDistributedVirtualSwitch.FeatureCapability)featuresData.featureCapability;
                portletData.ipfixSupported = vmwareFeatureCapability.ipfixSupported != null && vmwareFeatureCapability.ipfixSupported != false;
                portletData.lldpSupported = vmwareFeatureCapability.lldpSupported != null && vmwareFeatureCapability.lldpSupported != false;
                portletData.multicastSnoopingSupported = vmwareFeatureCapability.multicastSnoopingSupported != null && vmwareFeatureCapability.multicastSnoopingSupported != false;
                portletData.vspanSupported = vmwareFeatureCapability.vspanSupported != null && vmwareFeatureCapability.vspanSupported != false;
                boolean bl = portletData.lacpSupported = vmwareFeatureCapability.lacpCapability != null && vmwareFeatureCapability.lacpCapability.lacpSupported != null && vmwareFeatureCapability.lacpCapability.lacpSupported != false;
                if (vmwareFeatureCapability.healthCheckCapability instanceof VmwareDistributedVirtualSwitch.VmwareHealthCheckFeatureCapability) {
                    VmwareDistributedVirtualSwitch.VmwareHealthCheckFeatureCapability healthCheckCapability = (VmwareDistributedVirtualSwitch.VmwareHealthCheckFeatureCapability)vmwareFeatureCapability.healthCheckCapability;
                    portletData.healthCheckSupported = healthCheckCapability.teamingSupported || healthCheckCapability.vlanMtuSupported;
                }
            }
        }
        return portletData;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="dvsOutOfSyncHostsData")
    public DvsHostsData getDvsOutOfSyncHostsData(ManagedObjectReference dvsRef) throws Exception {
        Validate.notNull((Object)dvsRef);
        DvsHostsData dvsHostsData = new DvsHostsData();
        DvsMemberHostsModel dvsMemberHostsModel = (DvsMemberHostsModel)this._queryBindingService.prepare(DvsMemberHostsModel.class).fetch((Object)dvsRef);
        dvsHostsData.dvsHosts = dvsMemberHostsModel.dvsHostMemberModels != null ? this._hostListItemHelper.createOutOfSyncHostListItems(Arrays.asList(dvsMemberHostsModel.dvsHostMemberModels), dvsMemberHostsModel.hostMemberRuntimeInfos) : new ArrayList();
        return dvsHostsData;
    }
}

