/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.upgrade;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.util.PropertyChangeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvsApplyProductSpecCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsResControlUpgradeSpec;
import com.vmware.vsphere.client.dvs.api.spec.LacpUpgradeSpec;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.DvsUpgradeSpecBuilder;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.DvsUpgradeWizardSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsUpgradeMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DvsUpgradeMutationProvider.class);
    private final MutationService _mutationService;
    private final QueryExecutor _queryExecutor;

    public DvsUpgradeMutationProvider(MutationService mutationService, QueryExecutor queryExecutor) {
        this._mutationService = mutationService;
        this._queryExecutor = queryExecutor;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsUpgradeWizardSpec spec) {
        OperationResult dvsUpgradeResult;
        try {
            DvsUpgradeSpecBuilder specBuilder = new DvsUpgradeSpecBuilder();
            DvsApplyProductSpecCommandSpec commandSpec = specBuilder.buildDvsUpgradeCommandSpec(dvsRef, spec);
            DvsConfigChangeListener changeListener = new DvsConfigChangeListener(dvsRef, this._queryExecutor);
            changeListener.resetConfigVersion();
            dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)commandSpec);
            if (spec.explicitNiocUpgrade && dvsUpgradeResult.error == null) {
                DvsResControlUpgradeSpec niocUpgradeSpec = new DvsResControlUpgradeSpec();
                niocUpgradeSpec.migrateShares = spec.migrateShares;
                changeListener.waitUntilConfigVersionChanged();
                changeListener.resetConfigVersion();
                dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)niocUpgradeSpec);
            }
            if (spec.explicitLacpUpgrade && dvsUpgradeResult.error == null) {
                LacpUpgradeSpec lacpUpgradeSpec = new LacpUpgradeSpec();
                lacpUpgradeSpec.lag = spec.lag;
                changeListener.waitUntilConfigVersionChanged();
                dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)lacpUpgradeSpec);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            dvsUpgradeResult = new OperationResult();
            dvsUpgradeResult.entity = dvsRef;
            dvsUpgradeResult.error = ex;
        }
        return dvsUpgradeResult;
    }

    private static final class DvsConfigChangeListener
    implements PropertyChangeInfo {
        private final String DVS_CONFIG_VERSION = "config.configVersion";
        private final QueryExecutor _queryExecutor;
        private final ManagedObjectReference _dvsRef;
        private boolean _is60Vc;
        private String _configVersion;

        public DvsConfigChangeListener(ManagedObjectReference dvsRef, QueryExecutor queryExecutor) {
            this._dvsRef = dvsRef;
            this._queryExecutor = queryExecutor;
            this._is60Vc = !VcServiceUtil.is65VcOrLaterByServerGuid((String)this._dvsRef.getServerGuid(), (boolean)true);
        }

        public void resetConfigVersion() throws Exception {
            if (this._is60Vc) {
                this._configVersion = this.getDvsConfigVersion();
            }
        }

        public void waitUntilConfigVersionChanged() throws Exception {
            if (this._is60Vc) {
                this._queryExecutor.waitUntilPropertyChanged((Object)this._dvsRef, (PropertyChangeInfo)this);
            }
        }

        public String getPropertyName() {
            return "config.configVersion";
        }

        public boolean isChanged(Object newValue) {
            return !ObjectUtil.objectsEqual((Object)this._configVersion, (Object)newValue);
        }

        private String getDvsConfigVersion() throws Exception {
            return (String)this._queryExecutor.getProperty((Object)this._dvsRef, "config.configVersion");
        }
    }
}

