/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.iscsi;

import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.host.iscsi.model.IscsiPortInfoItem;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;

public class HostIscsiPortBindingUtil {
    public static String getPortGroupName(IscsiManager.IscsiPortInfo portInfo) {
        String portGroupName;
        String string = portGroupName = StringUtil.isNullOrEmpty((String)portInfo.portgroupName) ? portInfo.opaqueNetworkName : portInfo.portgroupName;
        if (!StringUtil.isNullOrEmpty((String)portGroupName) && !StringUtil.isNullOrEmpty((String)portInfo.switchName)) {
            portGroupName = NetworkStringUtil.getString("portbinding.portgroupNameAndSwitch", portGroupName, portInfo.switchName);
        }
        return portGroupName;
    }

    public static IscsiPortInfoItem.VNICBackingType getVNICBackingType(VirtualNic vnic) {
        if (vnic == null || vnic.spec == null) {
            return IscsiPortInfoItem.VNICBackingType.unknown;
        }
        if (vnic.spec.portgroup != null) {
            return IscsiPortInfoItem.VNICBackingType.standard;
        }
        if (vnic.spec.distributedVirtualPort != null) {
            return IscsiPortInfoItem.VNICBackingType.distributed;
        }
        if (vnic.spec.opaqueNetwork != null) {
            return IscsiPortInfoItem.VNICBackingType.opaque;
        }
        return IscsiPortInfoItem.VNICBackingType.unknown;
    }

    public static String getPhysicalNetworkAdapterInfo(IscsiManager.IscsiPortInfo info) {
        if (StringUtil.isNullOrEmpty((String)info.pnicDevice)) {
            return null;
        }
        String result = info.pnicDevice;
        if (info.pnic == null || info.pnic.linkSpeed == null || StringUtil.isNullOrEmpty((String)info.pnic.device)) {
            return result;
        }
        result = NetworkStringUtil.getString("portbinding.physicalNetworkAdapter", info.pnic.device, FormatUtil.getBitRateFormatted((Number)info.pnic.linkSpeed.speedMb, (int)0, (long)FormatUtil.MBPS, (long)-1L, (boolean)true), NetworkStringUtil.getString(info.pnic.linkSpeed.duplex ? "portbinding.fullLabel" : "portbinding.halfLabel"));
        return result;
    }
}

