/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.iscsi.model;

import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vsphere.client.h5.network.host.iscsi.HostIscsiPortBindingUtil;

public class IscsiPortInfoItem {
    public String portGroupName;
    public VNICBackingType vnicBackingType;
    public String vmKernelAdapter;
    public boolean isCompliant;
    public Exception[] complianceErrors;
    public String pathStatus;
    public String physicalNetworkAdapterInfo;
    public String pnicDevice;
    public VirtualNic.Specification vnicSpec;
    public String switchName;
    public String dvSwitchUuid;

    public static IscsiPortInfoItem newInstance(IscsiManager.IscsiPortInfo portInfo) {
        IscsiPortInfoItem item = IscsiPortInfoItem.newBaseInstance(portInfo);
        if (portInfo == null) {
            return item;
        }
        if (portInfo.complianceStatus == null) {
            item.isCompliant = true;
        } else {
            item.isCompliant = false;
            item.complianceErrors = portInfo.complianceStatus.reason;
        }
        item.pathStatus = portInfo.pathStatus;
        return item;
    }

    public static IscsiPortInfoItem newInstanceForCandidateIsciItem(IscsiManager.IscsiPortInfo portInfo) {
        IscsiPortInfoItem item = IscsiPortInfoItem.newBaseInstance(portInfo);
        if (portInfo == null) {
            return item;
        }
        if (portInfo.vnic == null || portInfo.pnic == null) {
            item.isCompliant = false;
        } else if (portInfo.complianceStatus == null) {
            item.isCompliant = true;
        } else {
            item.isCompliant = false;
            item.complianceErrors = portInfo.complianceStatus.reason;
        }
        return item;
    }

    private static IscsiPortInfoItem newBaseInstance(IscsiManager.IscsiPortInfo portInfo) {
        IscsiPortInfoItem item = new IscsiPortInfoItem();
        if (portInfo == null) {
            return item;
        }
        item.portGroupName = HostIscsiPortBindingUtil.getPortGroupName(portInfo);
        item.vnicBackingType = HostIscsiPortBindingUtil.getVNICBackingType(portInfo.vnic);
        if (portInfo.vnic != null) {
            item.vnicSpec = portInfo.vnic.spec;
        }
        item.vmKernelAdapter = portInfo.vnicDevice;
        item.physicalNetworkAdapterInfo = HostIscsiPortBindingUtil.getPhysicalNetworkAdapterInfo(portInfo);
        item.pnicDevice = portInfo.pnicDevice;
        item.switchName = portInfo.switchName;
        item.dvSwitchUuid = portInfo.switchUuid;
        return item;
    }

    public static enum VNICBackingType {
        standard,
        distributed,
        opaque,
        unknown;

    }
}

