/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.migratevmkadapter;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.host.migratevmkadapter.model.DestinationStandardPortGroupInitialInfo;
import com.vmware.vsphere.client.h5.network.host.migratevmkadapter.model.HostDataQueryBinding;
import com.vmware.vsphere.client.h5.network.host.migratevmkadapter.model.HostStandardPortGroupInfo;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicUtils;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.h5.network.util.VlanUtil;
import java.util.List;

public class MigrateVmkAdapterToVssPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private static final String HOST_PORT_GROUPS = "config.network.portgroup";
    private static final String HOST_VNICS = "config.network.vnic";

    public MigrateVmkAdapterToVssPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vmkmigratewizard", property="hostName")
    public String getHostName(ManagedObjectReference hostRef) {
        HostDataQueryBinding hostData = (HostDataQueryBinding)((Object)this._queryBindingService.prepare(HostDataQueryBinding.class).fetch((Object)hostRef));
        return hostData.name;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vmkmigratewizard", property="standardPortGroupInfo")
    public HostStandardPortGroupInfo getStandardPortGroupInfo(ManagedObjectReference hostRef, DestinationStandardPortGroupInitialInfo portGroupInfo) {
        VirtualNic virtualNic;
        String uniqueNamePrefix = portGroupInfo.portGroupUniquePreffix;
        String vmkAdapter = portGroupInfo.vmkDevice;
        HostStandardPortGroupInfo hostStandardPortgroupInfo = new HostStandardPortGroupInfo();
        ResultSet resultSet = this._queryService.select(new String[]{HOST_PORT_GROUPS, HOST_VNICS}).from(new String[]{hostRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
        PortGroup[] portGroups = null;
        VirtualNic[] vnics = null;
        if (!ArrayUtil.isNullOrEmpty((List)resultSet.getItems())) {
            for (ResourceItem item : resultSet.getItems()) {
                Object[] vnicsResArray;
                Object[] portGroupsResArray;
                if (item.get(HOST_PORT_GROUPS) instanceof Object[] && !ArrayUtil.isNullOrEmpty((Object[])(portGroupsResArray = (Object[])item.get(HOST_PORT_GROUPS)))) {
                    portGroups = (PortGroup[])portGroupsResArray;
                }
                if (!(item.get(HOST_VNICS) instanceof Object[]) || ArrayUtil.isNullOrEmpty((Object[])(vnicsResArray = (Object[])item.get(HOST_VNICS)))) continue;
                vnics = (VirtualNic[])vnicsResArray;
            }
        }
        if ((virtualNic = VnicUtils.getVnicByDevice(vnics, vmkAdapter)) != null) {
            String sourcePortGroupName = virtualNic.portgroup;
            Object sourcePortGroup = null;
            if (portGroups != null) {
                for (void var15_15 : portGroups) {
                    if (!sourcePortGroupName.equals(var15_15.getSpec().name)) continue;
                    sourcePortGroup = var15_15;
                }
            }
            if (sourcePortGroup != null) {
                hostStandardPortgroupInfo.sourcePortGroupVlanId = sourcePortGroup.getSpec().vlanId;
            }
        }
        hostStandardPortgroupInfo.networkLabel = NetworkUtil.getUniqueName(portGroups, uniqueNamePrefix);
        hostStandardPortgroupInfo.vlanIds = VlanUtil.getAvailableVlanIds(portGroups);
        return hostStandardPortgroupInfo;
    }
}

