/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.netstack;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.IpRouteConfig;
import com.vmware.vim.binding.vim.host.IpRouteEntry;
import com.vmware.vim.binding.vim.host.IpRouteOp;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.model.HostNetStackData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackConfigData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackConfigItem;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackConfigSpec;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackItem;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackRouteTableEntry;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class HostNetstackPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private static final String IPV4_DEFAULT_ADDRESS = "0.0.0.0";
    private static final String IPV6_DEFAULT_ADDRESS = "::";
    private static final int INVALID_NUMBER_OF_CONNECTIONS = -1;

    public HostNetstackPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="netstack", property="netStackData")
    public HostNetStackData getNetStackData(ManagedObjectReference hostRef) {
        LinkedList<NetStackItem> netStackItems = new LinkedList<NetStackItem>();
        NetStackData netStackData = (NetStackData)((Object)this._queryBindingService.prepare(NetStackData.class).fetch((Object)hostRef));
        HostNetStackData hostNetStackData = new HostNetStackData();
        if (netStackData != null) {
            hostNetStackData.ipv6Enabled = netStackData.ipv6Enabled;
            hostNetStackData.multipleNetworkStackInstanceSupported = netStackData.multipleNetworkStackInstanceSupported;
            if (netStackData.multipleNetworkStackInstanceSupported) {
                if (!ArrayUtil.isNullOrEmpty((Object[])netStackData.netStackInstances)) {
                    Map<String, RuntimeInfo.NetStackInstanceRuntimeInfo> netStackInstRuntimeInfoMap = HostNetstackPropertyProvider.buildNetStackInstRuntimeInfoMap(netStackData.netStackInstanceRuntimeInfo);
                    for (NetStackInstance netStackInstance : netStackData.netStackInstances) {
                        if (netStackInstance == null || StringUtil.isNullOrEmpty((String)netStackInstance.key)) continue;
                        NetStackItem netStackItem = new NetStackItem();
                        netStackItem.key = netStackInstance.key;
                        netStackItem.name = NetStackUtil.getNetStackInstanceName(netStackInstance);
                        netStackItem.isSystemStack = NetStackUtil.isSystemStackKeyValue(netStackInstance.key);
                        HostNetstackPropertyProvider.populateGatewayInfo(netStackItem, netStackInstance.ipRouteConfig);
                        HostNetstackPropertyProvider.populateDnsInfo(netStackItem, netStackInstance.dnsConfig);
                        netStackItem.virtualNicCount = HostNetstackPropertyProvider.getVnicCount(netStackInstRuntimeInfoMap.get(netStackInstance.key));
                        if (NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) {
                            netStackItems.add(0, netStackItem);
                            continue;
                        }
                        netStackItems.add(netStackItem);
                    }
                }
            } else {
                NetStackItem defaultNetStackItem = new NetStackItem();
                defaultNetStackItem.key = NetStackInstance.SystemStackKey.defaultTcpipStack.toString();
                defaultNetStackItem.name = NetworkStringUtil.getString("NetStackInstance.defaultStackName");
                defaultNetStackItem.isSystemStack = true;
                HostNetstackPropertyProvider.populateGatewayInfo(defaultNetStackItem, netStackData.hostRouteConfig);
                HostNetstackPropertyProvider.populateDnsInfo(defaultNetStackItem, netStackData.hostDnsConfig);
                defaultNetStackItem.virtualNicCount = netStackData.vmkernelVnicsCount;
                netStackItems.add(defaultNetStackItem);
            }
        }
        hostNetStackData.netStackItems = netStackItems.toArray(new NetStackItem[netStackItems.size()]);
        return hostNetStackData;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="netstack", property="netStackConfig")
    public NetStackConfigItem getNetStackConfigData(ManagedObjectReference hostRef, NetStackConfigSpec spec) {
        IpRouteConfig ipRouteConfig;
        VirtualNic[] vnics;
        DnsConfig dnsConfig;
        NetStackConfigData netStackConfigData = (NetStackConfigData)((Object)this._queryBindingService.prepare(NetStackConfigData.class).fetch((Object)hostRef));
        if (netStackConfigData.multipleNetworkStackInstanceSupported != null && netStackConfigData.multipleNetworkStackInstanceSupported.booleanValue() && (spec == null || StringUtil.isNullOrEmpty((String)spec.netStackInstanceKey))) {
            throw new IllegalArgumentException("NetStack key not specified");
        }
        NetStackConfigItem netStackConfigItem = new NetStackConfigItem();
        if (netStackConfigData.multipleNetworkStackInstanceSupported == null || !netStackConfigData.multipleNetworkStackInstanceSupported.booleanValue()) {
            dnsConfig = netStackConfigData.hostDnsConfig;
            vnics = netStackConfigData.vnics;
            ipRouteConfig = netStackConfigData.ipRouteConfig;
            netStackConfigItem.isDefaultNetStack = true;
            netStackConfigItem.isSystemNetStack = true;
            netStackConfigItem.name = NetworkStringUtil.getString("NetStackInstance.defaultStackName");
            netStackConfigItem.ipv4RouteTableEntries = new NetStackRouteTableEntry[0];
            netStackConfigItem.ipv6RouteTableEntries = new NetStackRouteTableEntry[0];
            if (netStackConfigData.ipRouteTableInfo != null) {
                netStackConfigItem.ipv4RouteTableEntries = this.getRouteTableEntries(netStackConfigData.ipRouteTableInfo.ipRoute, false);
                netStackConfigItem.ipv6RouteTableEntries = this.getRouteTableEntries(netStackConfigData.ipRouteTableInfo.ipv6Route, true);
            }
        } else {
            NetStackInstance netStackInstance = NetStackUtil.getNetStackInstanceByKey(spec.netStackInstanceKey, netStackConfigData.netStackInstances);
            Validate.notNull((Object)netStackInstance);
            dnsConfig = netStackInstance.dnsConfig;
            vnics = HostNetstackPropertyProvider.filterNetStackVnics(spec.netStackInstanceKey, netStackConfigData.vnics);
            ipRouteConfig = netStackInstance.ipRouteConfig;
            netStackConfigItem.isDefaultNetStack = NetStackUtil.isDefaultNetStackInstance(spec.netStackInstanceKey);
            netStackConfigItem.isSystemNetStack = NetStackUtil.isSystemStackKeyValue(netStackInstance.key);
            netStackConfigItem.name = NetStackUtil.getNetStackInstanceName(netStackInstance);
            netStackConfigItem.ipv4RouteTableEntries = new NetStackRouteTableEntry[0];
            netStackConfigItem.ipv6RouteTableEntries = new NetStackRouteTableEntry[0];
            this.fillNetStackRoutingTableEntries(netStackConfigItem, netStackInstance);
            netStackConfigItem.congestionControlAlgorithm = netStackInstance.congestionControlAlgorithm;
            netStackConfigItem.maxNumberOfConnections = netStackInstance.requestedMaxNumberOfConnections;
            RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo = this.getRuntimeInfoByKey(netStackConfigData.netStackInstanceRuntimeInfo, netStackInstance.key);
            String runtimeState = this.getRuntimeState(runtimeInfo);
            int runtimeMaxNumberOfConnections = this.getRuntimeMaxNumberOfConnections(runtimeInfo);
            netStackConfigItem.runtimeMaxNumberOfConnections = runtimeMaxNumberOfConnections;
            netStackConfigItem.isRuntimeInfoActive = runtimeState.equals(RuntimeInfo.NetStackInstanceRuntimeInfo.State.active.name());
        }
        if (dnsConfig == null) {
            dnsConfig = new DnsConfig();
        }
        if (ipRouteConfig == null) {
            ipRouteConfig = new IpRouteConfig();
        }
        if (netStackConfigItem.isDefaultNetStack) {
            netStackConfigItem.isDhcpEnabled = dnsConfig.dhcp;
            netStackConfigItem.vnicsWithDhcpEnabled = HostNetstackPropertyProvider.getDhcpEnabledVnics(vnics);
            netStackConfigItem.selectedVnic = dnsConfig.virtualNicDevice == null ? "" : dnsConfig.virtualNicDevice;
            netStackConfigItem.hostName = dnsConfig.hostName == null ? "" : dnsConfig.hostName;
            netStackConfigItem.domainName = dnsConfig.domainName == null ? "" : dnsConfig.domainName;
            netStackConfigItem.preferredDns = this.getPreferredDnsAddress(dnsConfig.address);
            netStackConfigItem.alternateDns = this.getAlternateDnsAddress(dnsConfig.address);
            netStackConfigItem.searchDomains = this.convertSearchDomain(dnsConfig.searchDomain);
        }
        netStackConfigItem.defaultGateway = ipRouteConfig.defaultGateway;
        netStackConfigItem.ipV6DefaultGateway = ipRouteConfig.ipV6DefaultGateway;
        netStackConfigItem.hasVnicWithIpv4Settings = this.hasVnicWithIpv4Settings(vnics);
        netStackConfigItem.hasVnicWithIpv6Settings = this.hasVnicWithIpv6Settings(vnics);
        netStackConfigItem.isIpv6Enabled = netStackConfigData.ipv6Enabled != null && netStackConfigData.ipv6Enabled != false;
        return netStackConfigItem;
    }

    private String getRuntimeState(RuntimeInfo.NetStackInstanceRuntimeInfo netStackInstanceRuntime) {
        if (netStackInstanceRuntime != null && netStackInstanceRuntime.state != null && !netStackInstanceRuntime.state.equals("")) {
            return netStackInstanceRuntime.state;
        }
        return RuntimeInfo.NetStackInstanceRuntimeInfo.State.inactive.toString();
    }

    private int getRuntimeMaxNumberOfConnections(RuntimeInfo.NetStackInstanceRuntimeInfo netStackInstanceRuntime) {
        if (netStackInstanceRuntime != null && netStackInstanceRuntime.maxNumberOfConnections != null) {
            return netStackInstanceRuntime.maxNumberOfConnections;
        }
        return -1;
    }

    private RuntimeInfo.NetStackInstanceRuntimeInfo getRuntimeInfoByKey(RuntimeInfo.NetStackInstanceRuntimeInfo[] runtimeInfos, String key) {
        if (runtimeInfos != null) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo : runtimeInfos) {
                if (!runtimeInfo.netStackInstanceKey.equals(key)) continue;
                return runtimeInfo;
            }
        }
        return null;
    }

    private void fillNetStackRoutingTableEntries(NetStackConfigItem netStackConfigItem, NetStackInstance netStackInstance) {
        if (netStackInstance.getRouteTableConfig() != null) {
            if (netStackInstance.getRouteTableConfig().getIpRoute() != null) {
                LinkedList<IpRouteEntry> ipv4RouteEntries = new LinkedList<IpRouteEntry>();
                for (IpRouteOp ipRoute : netStackInstance.getRouteTableConfig().getIpRoute()) {
                    ipv4RouteEntries.add(ipRoute.getRoute());
                }
                netStackConfigItem.ipv4RouteTableEntries = this.getRouteTableEntries(ipv4RouteEntries.toArray(new IpRouteEntry[ipv4RouteEntries.size()]), false);
            }
            if (netStackInstance.getRouteTableConfig().getIpv6Route() != null) {
                LinkedList<IpRouteEntry> ipv6RouteEntries = new LinkedList<IpRouteEntry>();
                for (IpRouteOp ipv6Route : netStackInstance.getRouteTableConfig().getIpv6Route()) {
                    ipv6RouteEntries.add(ipv6Route.getRoute());
                }
                netStackConfigItem.ipv6RouteTableEntries = this.getRouteTableEntries(ipv6RouteEntries.toArray(new IpRouteEntry[ipv6RouteEntries.size()]), true);
            }
        }
    }

    private NetStackRouteTableEntry[] getRouteTableEntries(IpRouteEntry[] ipRouteEntries, boolean isIpv6RouteEntryTable) {
        if (ipRouteEntries == null) {
            return null;
        }
        LinkedList<NetStackRouteTableEntry> entries = new LinkedList<NetStackRouteTableEntry>();
        for (IpRouteEntry ipRouteEntry : ipRouteEntries) {
            NetStackRouteTableEntry entry = new NetStackRouteTableEntry();
            String network = IPV4_DEFAULT_ADDRESS.equals(ipRouteEntry.network) || IPV6_DEFAULT_ADDRESS.equals(ipRouteEntry.network) ? NetworkStringUtil.getString("NetStackInstance.routingTable.defaultAddress") : ipRouteEntry.network;
            String gateway = IPV4_DEFAULT_ADDRESS.equals(ipRouteEntry.gateway) || IPV6_DEFAULT_ADDRESS.equals(ipRouteEntry.gateway) ? NetworkStringUtil.getString("NetStackInstance.routingTable.localSubnet") : ipRouteEntry.gateway;
            entry.deviceName = ipRouteEntry.deviceName;
            entry.gateway = gateway;
            entry.network = network;
            entry.prefixLength = ipRouteEntry.prefixLength;
            if (!isIpv6RouteEntryTable) {
                entry.subnetMask = IpUtil.getIpv4SubnetMask(String.valueOf(ipRouteEntry.prefixLength));
            }
            entries.add(entry);
        }
        NetStackRouteTableEntry[] routeTableEntries = entries.toArray(new NetStackRouteTableEntry[entries.size()]);
        if (!isIpv6RouteEntryTable) {
            Arrays.sort(routeTableEntries, new Comparator<NetStackRouteTableEntry>(){

                @Override
                public int compare(NetStackRouteTableEntry o1, NetStackRouteTableEntry o2) {
                    return Integer.compare(o2.prefixLength, o1.prefixLength);
                }
            });
        }
        return routeTableEntries;
    }

    private boolean hasVnicWithIpv4Settings(VirtualNic[] vnics) {
        if (vnics == null) {
            return false;
        }
        for (VirtualNic vnic : vnics) {
            if (vnic == null || vnic.spec == null || !IpUtil.hasAnyIpv4Settings(vnic.spec.ip)) continue;
            return true;
        }
        return false;
    }

    private boolean hasVnicWithIpv6Settings(VirtualNic[] vnics) {
        if (vnics == null) {
            return false;
        }
        for (VirtualNic vnic : vnics) {
            if (vnic == null || vnic.spec == null || !IpUtil.hasAnyIpv6Settings(vnic.spec.ip)) continue;
            return true;
        }
        return false;
    }

    private String convertSearchDomain(String[] searchDomains) {
        if (searchDomains == null) {
            return "";
        }
        StringBuilder domains = new StringBuilder();
        for (int i = 0; i < searchDomains.length; ++i) {
            if (i != 0) {
                domains.append(" ");
            }
            domains.append(searchDomains[i]);
        }
        return domains.toString();
    }

    private String getPreferredDnsAddress(String[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        return addresses[0];
    }

    private String getAlternateDnsAddress(String[] addresses) {
        if (addresses == null || addresses.length < 2) {
            return "";
        }
        return addresses[1];
    }

    private static VirtualNic[] filterNetStackVnics(String netStackKey, VirtualNic[] vnics) {
        if (vnics == null) {
            return new VirtualNic[0];
        }
        LinkedList<VirtualNic> vnicsList = new LinkedList<VirtualNic>();
        for (VirtualNic vnic : vnics) {
            if (vnic == null || vnic.spec == null || vnic.spec.netStackInstanceKey == null || !vnic.spec.netStackInstanceKey.equals(netStackKey)) continue;
            vnicsList.add(vnic);
        }
        return vnicsList.toArray(new VirtualNic[vnicsList.size()]);
    }

    private static void populateGatewayInfo(NetStackItem netStackItem, IpRouteConfig ipRouteConfig) {
        if (ipRouteConfig != null) {
            netStackItem.ipv4GatewayAddress = ipRouteConfig.defaultGateway;
            netStackItem.ipv6GatewayAddress = ipRouteConfig.ipV6DefaultGateway;
        }
        netStackItem.ipv4GatewayAddress = NetworkStringUtil.returnNaIfEmpty(netStackItem.ipv4GatewayAddress);
        netStackItem.ipv6GatewayAddress = NetworkStringUtil.returnNaIfEmpty(netStackItem.ipv6GatewayAddress);
    }

    private static void populateDnsInfo(NetStackItem netStackItem, DnsConfig dnsConfig) {
        if (dnsConfig != null && !ArrayUtil.isNullOrEmpty((Object[])dnsConfig.address)) {
            netStackItem.preferredDnsServer = dnsConfig.address[0];
            if (dnsConfig.address.length > 1) {
                netStackItem.alternateDnsServer = dnsConfig.address[1];
            }
        }
        netStackItem.preferredDnsServer = NetworkStringUtil.returnNaIfEmpty(netStackItem.preferredDnsServer);
        netStackItem.alternateDnsServer = NetworkStringUtil.returnNaIfEmpty(netStackItem.alternateDnsServer);
    }

    private static int getVnicCount(RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo) {
        if (runtimeInfo != null && runtimeInfo.vmknicKeys != null) {
            return runtimeInfo.vmknicKeys.length;
        }
        return 0;
    }

    private static Map<String, RuntimeInfo.NetStackInstanceRuntimeInfo> buildNetStackInstRuntimeInfoMap(RuntimeInfo.NetStackInstanceRuntimeInfo[] runtimeInfos) {
        HashMap<String, RuntimeInfo.NetStackInstanceRuntimeInfo> netStackInstanceRuntimeInfoMap = new HashMap<String, RuntimeInfo.NetStackInstanceRuntimeInfo>();
        if (runtimeInfos != null) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo runtimeInfo : runtimeInfos) {
                netStackInstanceRuntimeInfoMap.put(runtimeInfo.netStackInstanceKey, runtimeInfo);
            }
        }
        return netStackInstanceRuntimeInfoMap;
    }

    private static String[] getDhcpEnabledVnics(VirtualNic[] virtualNics) {
        if (ArrayUtil.isNullOrEmpty((Object[])virtualNics)) {
            return new String[0];
        }
        LinkedList<String> vnicsList = new LinkedList<String>();
        for (VirtualNic vnic : virtualNics) {
            boolean hasIpv6DhcpEnabled;
            boolean hasIpv4DhcpEnabled = vnic != null && vnic.spec != null && vnic.spec.ip != null && vnic.spec.ip.dhcp;
            boolean bl = hasIpv6DhcpEnabled = vnic != null && vnic.spec != null && vnic.spec.ip != null && vnic.spec.ip.ipV6Config != null && vnic.spec.ip.ipV6Config.dhcpV6Enabled != null && vnic.spec.ip.ipV6Config.dhcpV6Enabled != false;
            if (!hasIpv4DhcpEnabled && !hasIpv6DhcpEnabled || vnic.device == null) continue;
            vnicsList.add(vnic.device);
        }
        return vnicsList.toArray(new String[vnicsList.size()]);
    }
}

