/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.netstack;

import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class NetStackUtil {
    private NetStackUtil() {
    }

    public static String getNetStackInstanceName(NetStackInstance netStackInstance) {
        if (netStackInstance == null) {
            return null;
        }
        if (netStackInstance.key == null) {
            return NetworkStringUtil.getString("NetStackInstance.defaultStackName");
        }
        String name = "";
        if (NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) {
            name = NetworkStringUtil.getString("NetStackInstance.defaultStackName");
        } else if (NetStackUtil.isDedicatedNetStackInstance(netStackInstance.key)) {
            switch (NetStackInstance.SystemStackKey.valueOf((String)netStackInstance.key)) {
                case vmotion: {
                    name = NetworkStringUtil.getString("NetStackInstance.vmotionStackName");
                    break;
                }
                case vSphereProvisioning: {
                    name = NetworkStringUtil.getString("NetStackInstance.provisioningStackName");
                }
            }
        } else {
            name = netStackInstance.name != null ? netStackInstance.name : null;
        }
        return name;
    }

    public static NetStackInstance getNetStackInstanceByKey(String key, NetStackInstance[] instanceArray) {
        if (instanceArray == null || key == null) {
            return null;
        }
        for (NetStackInstance netStackInstance : instanceArray) {
            if (!key.equals(netStackInstance.key)) continue;
            return netStackInstance;
        }
        return null;
    }

    public static boolean isDefaultNetStackInstance(String netStackInstanceKey) {
        return NetStackInstance.SystemStackKey.defaultTcpipStack.toString().equals(netStackInstanceKey);
    }

    public static boolean isDedicatedNetStackInstance(String netStackInstanceKey) {
        return NetStackUtil.isSystemStackKeyValue(netStackInstanceKey) && !NetStackUtil.isDefaultNetStackInstance(netStackInstanceKey);
    }

    public static boolean isSystemStackKeyValue(String netStackInstanceKey) {
        for (NetStackInstance.SystemStackKey systemStackKey : NetStackInstance.SystemStackKey.values()) {
            if (!systemStackKey.toString().equals(netStackInstanceKey)) continue;
            return true;
        }
        return false;
    }

    public static String[] createDnsAddresses(String updatedPreferredDns, String updatedAlternateDns, String[] addressesInitial) {
        ArrayList<String> list = new ArrayList<String>();
        if (addressesInitial != null) {
            for (String address : addressesInitial) {
                list.add(address);
            }
        }
        while (list.size() < 2) {
            list.add("");
        }
        if (updatedPreferredDns != null) {
            list.set(0, updatedPreferredDns);
        }
        if (updatedAlternateDns != null) {
            list.set(1, updatedAlternateDns);
        }
        LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
        for (String address : list) {
            if ("".equals(address)) continue;
            queue.add(address);
        }
        return queue.isEmpty() ? null : queue.toArray(new String[queue.size()]);
    }

    public static String[] buildSearchDomains(String domains) {
        String trimmed = domains.trim();
        if ("".equals(trimmed)) {
            return null;
        }
        return trimmed.split("\\s+");
    }
}

