/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.portgroup;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.EditPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.PortgroupDetailsData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPortGroupData;
import com.vmware.vsphere.client.h5.network.util.NetworkPolicyUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.h5.network.util.VlanUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.StandardNetworkSpec;
import org.apache.commons.lang.Validate;

public class PortGroupParser {
    public static HostNetworkDetailsData getPortGroupDetails(HostVirtualSwitchPortGroupData portGroupsData, String portGroupKey) {
        PortGroup portGroup = PortGroupParser.getPortGroupByKey(portGroupKey, portGroupsData.portGroups);
        if (portGroup != null) {
            return PortGroupParser.buildPortGroupDetailsData(portGroupsData, portGroup);
        }
        throw new IllegalStateException(NetworkStringUtil.getString("PortGroupParser.missingPortGroupMessage", portGroupKey));
    }

    public static HostNetworkDetailsData getPortGroupDetailsByName(HostVirtualSwitchPortGroupData portGroupsData, String portGroupName) {
        PortGroup portGroup = PortGroupParser.getPortGroupByName(portGroupsData.portGroups, portGroupName);
        if (portGroup != null) {
            return PortGroupParser.buildPortGroupDetailsData(portGroupsData, portGroup);
        }
        throw new IllegalStateException(NetworkStringUtil.getString("PortGroupParser.missingPortGroupMessage", portGroupName));
    }

    public static PortGroup getPortGroupByName(PortGroup[] portGroups, String portGroupName) {
        if (portGroups != null) {
            for (PortGroup portGroup : portGroups) {
                if (!portGroup.spec.name.equals(portGroupName)) continue;
                return portGroup;
            }
        }
        return null;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(PortGroup portGroup, NetworkInfo networkInfo) {
        if (portGroup == null || networkInfo == null) {
            return null;
        }
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(portGroup.spec.vswitchName, networkInfo.vswitch);
        return PortGroupParser.getPortPolicy(portGroup, virtualSwitch, networkInfo.pnic);
    }

    public static EditPortgroupDialogData createEditPortgroupDialogData(String portgroupKey, PortgroupDetailsData portgroupDetailsData) {
        PortGroup portgroup = null;
        VirtualSwitch vSwitch = null;
        if (portgroupDetailsData != null) {
            portgroup = NetworkUtil.getPortgroupByKey(portgroupKey, portgroupDetailsData.portgroups);
        }
        if (portgroup == null) {
            return null;
        }
        if (portgroupDetailsData.hostPnicDetailsData != null) {
            vSwitch = NetworkUtil.getVswitchByName(portgroup.spec.vswitchName, portgroupDetailsData.hostPnicDetailsData.vSwitches);
        }
        PortGroupParser.validatePortgroupRequiredFields(portgroup);
        EditPortgroupDialogData result = new EditPortgroupDialogData();
        result.properties = PortGroupParser.buildEditPortgroupDialogPropertiesData(portgroup, portgroupDetailsData.portgroups, portgroupDetailsData.standardNetworkSpec);
        result.securityPolicies = NetworkPolicyUtil.getSecurityPolicies(portgroup.computedPolicy, portgroup.spec.policy);
        result.trafficShapingPolicies = NetworkPolicyUtil.getTrafficShapingPolicies(portgroup.computedPolicy, portgroup.spec.policy);
        result.teamingAndFailover = NetworkPolicyUtil.getTeamingAndFailoverPolicies(portgroup.computedPolicy, portgroup.spec.policy, vSwitch, portgroupDetailsData.nicTeamingPolicy, portgroupDetailsData.hostPnicDetailsData);
        return result;
    }

    private static HostNetworkDetailsData buildPortGroupDetailsData(HostVirtualSwitchPortGroupData portGroupsData, PortGroup portGroup) {
        HostNetworkDetailsData portGroupData = new HostNetworkDetailsData();
        portGroupData.networkLabel = portGroup.spec.name;
        portGroupData.vlanId = portGroup.spec.vlanId;
        portGroupData.showVlanId = true;
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(portGroup.spec.vswitchName, portGroupsData.standardSwitches);
        portGroupData.portPolicy = PortGroupParser.getPortPolicy(portGroup, virtualSwitch, portGroupsData.pnics);
        return portGroupData;
    }

    private static void validatePortgroupRequiredFields(PortGroup portgroup) {
        Validate.notNull((Object)portgroup);
        Validate.notNull((Object)portgroup.spec);
        Validate.notNull((Object)portgroup.spec.policy);
        Validate.notNull((Object)portgroup.computedPolicy);
    }

    private static EditPortgroupDialogData.Properties buildEditPortgroupDialogPropertiesData(PortGroup portgroup, PortGroup[] portgroups, StandardNetworkSpec[] standardNetworkSpecs) {
        EditPortgroupDialogData.Properties properties = new EditPortgroupDialogData.Properties();
        properties.portgroupName = portgroup.spec.name;
        properties.oldPortgroupName = portgroup.spec.name;
        properties.vswitchName = portgroup.spec.vswitchName;
        properties.portgroupVlanId = portgroup.spec.vlanId;
        properties.hostVlanIds = VlanUtil.getAvailableVlanIds(portgroups);
        properties.vmCount = PortGroupParser.getNetworkVmsCount(portgroup.spec.name, standardNetworkSpecs);
        return properties;
    }

    private static int getNetworkVmsCount(String portgroupName, StandardNetworkSpec[] standardNetworkSpecs) {
        int vmCount = 0;
        if (portgroupName == null || ArrayUtil.isNullOrEmpty((Object[])standardNetworkSpecs)) {
            return vmCount;
        }
        for (StandardNetworkSpec networkSpec : standardNetworkSpecs) {
            if (!portgroupName.equals(networkSpec.name)) continue;
            vmCount = networkSpec.vmCount;
        }
        return vmCount;
    }

    private static PortGroup getPortGroupByKey(String portGroupKey, PortGroup[] portGroups) {
        if (!ArrayUtil.isNullOrEmpty((Object[])portGroups) && portGroupKey != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup == null || !portGroupKey.equals(portGroup.key)) continue;
                return portGroup;
            }
        }
        return null;
    }

    private static HostNetworkDetailsData.PortPolicy getPortPolicy(PortGroup portGroup, VirtualSwitch vSwitch, PhysicalNic[] pnics) {
        NetworkPolicy specPolicy = portGroup.spec.policy;
        NetworkPolicy computedPolicy = portGroup.computedPolicy;
        return NetworkUtil.getPortPolicy(vSwitch, pnics, specPolicy, computedPolicy);
    }
}

