/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.proxyswitch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.HostNetworkingService;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.UplinkPortMapping;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.spec.UpdateProxySwitchUplinkMappingSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class ProxySwitchMutationProvider
implements MutationProvider {
    private static final String PROXY_SWITCH_PROPERTY = "config.network.proxySwitch";
    private static final String CONFIG_NETWORK = "config.network";
    private static final String HOST_NAME_PROPERTY = "name";
    private final QueryExecutor queryExecutor;
    private final HostNetworkingService hostNetworkingService;

    public ProxySwitchMutationProvider(QueryExecutor queryExecutor, HostNetworkingService hostNetworkingService) {
        this.queryExecutor = queryExecutor;
        this.hostNetworkingService = hostNetworkingService;
    }

    public ValidationResult validate(ManagedObjectReference host, UpdateProxySwitchUplinkMappingSpec spec) throws Exception {
        Validate.notNull((Object)spec);
        Validate.notNull((Object)spec.proxySwitchKey);
        ValidationResult validationResult = new ValidationResult();
        NetworkInfo networkInfo = (NetworkInfo)this.queryExecutor.getProperty((Object)host, CONFIG_NETWORK);
        final HostProxySwitch hostProxySwitch = this.getProxySwitchByKey(spec.proxySwitchKey, networkInfo.proxySwitch);
        VirtualNic[] defaultNetStackVnics = NetworkUtil.getDefaultNetStackVnics(networkInfo);
        boolean areAllVnicsBelongingToProxySwitch = Iterables.all(Arrays.asList(defaultNetStackVnics), (Predicate)new Predicate<VirtualNic>(){

            public boolean apply(VirtualNic virtualNic) {
                return virtualNic.spec != null && virtualNic.spec.distributedVirtualPort != null && hostProxySwitch.dvsUuid.equals(virtualNic.spec.distributedVirtualPort.switchUuid);
            }
        });
        if (areAllVnicsBelongingToProxySwitch) {
            String hostname = (String)this.queryExecutor.getProperty((Object)host, HOST_NAME_PROPERTY);
            validationResult.result = NetworkStringUtil.getString("ProxySwitchMutationProvider.error.vmkernelBacking", hostProxySwitch.dvsName, hostname);
        }
        return validationResult;
    }

    public OperationResult apply(ManagedObjectReference host, UpdateProxySwitchUplinkMappingSpec spec) throws Exception {
        Validate.notNull((Object)spec);
        Validate.notNull((Object)spec.proxySwitchKey);
        Validate.notNull(spec.uplinkPortMappings);
        OperationResult result = new OperationResult();
        result.entity = host;
        HostProxySwitch[] hostProxySwitches = (HostProxySwitch[])this.queryExecutor.getProperty((Object)host, PROXY_SWITCH_PROPERTY);
        HostProxySwitch hostProxySwitch = this.getProxySwitchByKey(spec.proxySwitchKey, hostProxySwitches);
        if (hostProxySwitch == null) {
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        HostProxySwitch.Config updateProxySwitch = new HostProxySwitch.Config();
        updateProxySwitch.uuid = hostProxySwitch.dvsUuid;
        updateProxySwitch.spec = this.getProxySwitchSpec(spec);
        updateProxySwitch.changeOperation = ConfigChange.Operation.edit.toString();
        NetworkConfig newConfig = new NetworkConfig();
        newConfig.proxySwitch = new HostProxySwitch.Config[]{updateProxySwitch};
        NetworkSystem networkSystem = this.hostNetworkingService.getNetworkSystem(host);
        try {
            networkSystem.updateNetworkConfig(newConfig, ConfigChange.Mode.modify.name());
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    private HostProxySwitch.Specification getProxySwitchSpec(UpdateProxySwitchUplinkMappingSpec spec) {
        HostProxySwitch.Specification proxySwitchSpec = new HostProxySwitch.Specification();
        HostMember.PnicBacking pnicBacking = new HostMember.PnicBacking();
        ArrayList<HostMember.PnicSpec> pnicSpecs = new ArrayList<HostMember.PnicSpec>();
        for (UplinkPortMapping uplinkPortMapping : spec.uplinkPortMappings) {
            Validate.notNull((Object)uplinkPortMapping.uplinkPort.key);
            if (uplinkPortMapping.pnicName == null) continue;
            pnicSpecs.add(this.createPnicSpec(uplinkPortMapping));
        }
        pnicBacking.pnicSpec = (HostMember.PnicSpec[])Iterables.toArray(pnicSpecs, HostMember.PnicSpec.class);
        proxySwitchSpec.backing = pnicBacking;
        return proxySwitchSpec;
    }

    private HostMember.PnicSpec createPnicSpec(UplinkPortMapping uplinkPortMapping) {
        HostMember.PnicSpec pnicSpec = new HostMember.PnicSpec();
        pnicSpec.uplinkPortKey = uplinkPortMapping.uplinkPort.key;
        pnicSpec.pnicDevice = uplinkPortMapping.pnicName;
        if (uplinkPortMapping.uplinkPortgroup != null) {
            pnicSpec.uplinkPortgroupKey = uplinkPortMapping.uplinkPortgroup.key;
        }
        return pnicSpec;
    }

    private HostProxySwitch getProxySwitchByKey(String proxySwitchKey, HostProxySwitch[] proxySwitches) {
        for (HostProxySwitch hps : proxySwitches) {
            if (!hps.key.equals(proxySwitchKey)) continue;
            return hps;
        }
        return null;
    }
}

