/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditBindToPnicPageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditHostVnicModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditHostVnicModelAdapter;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditHostVnicQueryBinding;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv4PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv6PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditPortPropertiesPageModel;
import org.apache.commons.lang.Validate;

public class EditHostVnicPropertyProvider
implements PropertyProviderBean {
    private QueryBindingService _queryBindingService;

    public EditHostVnicPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="editHostVnicModel")
    public EditHostVnicModel getEditHostVnicModel(ManagedObjectReference hostRef, String vnicDevice) {
        Validate.notNull((Object)vnicDevice, (String)"vnicDevice is null");
        EditHostVnicQueryBinding editHostVnicQueryBinding = (EditHostVnicQueryBinding)((Object)this._queryBindingService.prepare(EditHostVnicQueryBinding.class).fetch((Object)hostRef));
        VirtualNic virtualNic = EditHostVnicModelAdapter.findVirtualNicOrThrow(editHostVnicQueryBinding, vnicDevice);
        EditPortPropertiesPageModel editPortPropertiesPageModel = EditHostVnicModelAdapter.createEditPortPropertiesPageModel(editHostVnicQueryBinding, virtualNic);
        EditIpv4PageModel editIpv4PageModel = EditHostVnicModelAdapter.createIpv4PageModel(editHostVnicQueryBinding, virtualNic);
        EditIpv6PageModel editIpv6PageModel = EditHostVnicModelAdapter.createIpv6PageModel(editHostVnicQueryBinding, virtualNic);
        EditBindToPnicPageModel editBindToPnicPageModel = EditHostVnicModelAdapter.createBindToPnicPageModel(virtualNic);
        EditHostVnicModel editHostVnicModel = new EditHostVnicModel();
        editHostVnicModel.editPortPropertiesPageModel = editPortPropertiesPageModel;
        editHostVnicModel.editIpv4PageModel = editIpv4PageModel;
        editHostVnicModel.editIpv6PageModel = editIpv6PageModel;
        editHostVnicModel.editBindToPnicPageModel = editBindToPnicPageModel;
        return editHostVnicModel;
    }
}

