/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostPnicAddSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PnicSettingsMutationProvider
implements MutationProvider {
    private static final String NETWORK_SYSTEM = "networkSystem";
    private static final Log _logger = LogFactory.getLog(PnicSettingsMutationProvider.class);
    private final QueryExecutor _queryExecutor;

    public PnicSettingsMutationProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public OperationResult apply(ManagedObjectReference host, HostPnicAddSpec spec) throws Exception {
        OperationResult opResult = new OperationResult();
        opResult.entity = host;
        if (spec == null) {
            _logger.error((Object)"HostPnicAddSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        ManagedObjectReference networkSystemRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)host, NETWORK_SYSTEM);
        NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemRef);
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(spec.vSwitchName, networkSystem.getNetworkInfo().vswitch);
        if (virtualSwitch == null) {
            _logger.error((Object)String.format("Virtual switch with name '%s' does not exist", spec.vSwitchName));
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        NetworkConfig networkConfig = this.buildVSwitchNetworkConfig(spec, virtualSwitch);
        try {
            networkSystem.updateNetworkConfig(networkConfig, ConfigChange.Mode.modify.name());
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when adding host networking: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    private NetworkConfig buildVSwitchNetworkConfig(HostPnicAddSpec spec, VirtualSwitch virtualSwitch) {
        NetworkConfig networkConfig = new NetworkConfig();
        VirtualSwitch.Config vSwitchConfig = new VirtualSwitch.Config();
        vSwitchConfig.changeOperation = ConfigChange.Operation.edit.name();
        vSwitchConfig.spec = virtualSwitch.spec;
        networkConfig.vswitch = new VirtualSwitch.Config[]{vSwitchConfig};
        if (vSwitchConfig.spec == null) {
            vSwitchConfig.spec = new VirtualSwitch.Specification();
        }
        if (vSwitchConfig.spec.policy == null) {
            vSwitchConfig.spec.policy = new NetworkPolicy();
        }
        if (vSwitchConfig.spec.policy.nicTeaming == null) {
            vSwitchConfig.spec.policy.nicTeaming = new NetworkPolicy.NicTeamingPolicy();
        }
        if (vSwitchConfig.spec.policy.nicTeaming.nicOrder == null) {
            vSwitchConfig.spec.policy.nicTeaming.nicOrder = new NetworkPolicy.NicOrderPolicy();
        }
        vSwitchConfig.name = spec.vSwitchName;
        vSwitchConfig.spec.policy.nicTeaming.nicOrder.activeNic = spec.activeNic;
        vSwitchConfig.spec.policy.nicTeaming.nicOrder.standbyNic = spec.standbyNic;
        vSwitchConfig.spec.bridge = spec.bridge;
        return networkConfig;
    }
}

