/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.moveto;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveService {
    private static final String DC_PROPERTY = "dc";
    private final MutationService mutationService;
    private static Log _logger = LogFactory.getLog(MoveService.class);

    public MoveService(MutationService mutationService) {
        this.mutationService = mutationService;
    }

    public OperationResult moveEntities(ManagedObjectReference[] entitiesToMove, ManagedObjectReference targetLocation) {
        OperationResult opResult = new OperationResult();
        ManagedEntityMoveSpec spec = new ManagedEntityMoveSpec();
        spec.entities = entitiesToMove;
        try {
            opResult = this.mutationService.apply((Object)targetLocation, (Object)spec);
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)String.format("Error moving the dvs: %s", e.toString()));
        }
        return opResult;
    }

    public boolean areObjectsFromOneDc(List<ResourceItem> resourceItems) {
        if (!CollectionUtil.isNullOrEmpty(resourceItems)) {
            ManagedObjectReference firstElementDatacenter = (ManagedObjectReference)resourceItems.get(0).get(DC_PROPERTY);
            if (firstElementDatacenter == null) {
                return false;
            }
            for (ResourceItem item : resourceItems) {
                if (firstElementDatacenter.equals(item.get(DC_PROPERTY))) continue;
                return false;
            }
        }
        return true;
    }
}

