/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.GraphRelation;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PhysicalAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.VswitchDiagramModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.VswitchType;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.OvsDiagramBuilder;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.OpaqueNetworkSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.OvsDiagramSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OvsDiagramBuilderImpl
implements OvsDiagramBuilder {
    private OvsDiagramSpec ovsDiagramSpec;
    private Map<String, PhysicalNic> pnicsByKey = new HashMap<String, PhysicalNic>();
    private Map<String, PhysicalNic> pnicsByName = new HashMap<String, PhysicalNic>();
    private Map<String, List<VirtualNic>> vnicsByOpaqueNetworkId = new HashMap<String, List<VirtualNic>>();
    private Map<String, OpaqueNetworkSpec> networkSpecsByName = new HashMap<String, OpaqueNetworkSpec>();

    public OvsDiagramBuilderImpl(OvsDiagramSpec ovsDiagramSpec) {
        if (ovsDiagramSpec == null) {
            throw new IllegalArgumentException("ovsDiagramSpec cannot be null");
        }
        this.ovsDiagramSpec = ovsDiagramSpec;
        this.initPnicsMaps();
        this.initVnicsMap();
        this.initNetworkSpecsMap();
    }

    public VswitchDiagramModel buildDiagramModel(OpaqueSwitch opaqueSwitch) {
        VswitchDiagramModel diagramModel = new VswitchDiagramModel();
        diagramModel.switchType = VswitchType.OVS.toString();
        diagramModel.switchKey = opaqueSwitch.key;
        this.addNetworksToDiagramModel(diagramModel, opaqueSwitch);
        this.addPnicsToDiagramModel(diagramModel, opaqueSwitch);
        return diagramModel;
    }

    private void addNetworksToDiagramModel(VswitchDiagramModel diagramModel, OpaqueSwitch opaqueSwitch) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.ovsDiagramSpec.opaqueNetworks)) {
            Map<String, OpaqueSwitch.PhysicalNicZone> pnicZonesByKey = this.getPnicZoneByKey(opaqueSwitch);
            for (OpaqueNetworkInfo network : this.ovsDiagramSpec.opaqueNetworks) {
                if (!this.isNetworkAssociatedWithSwitch(pnicZonesByKey.keySet(), network)) continue;
                PortGroupModel networkModel = new PortGroupModel();
                networkModel.id = network.opaqueNetworkId;
                networkModel.title = network.opaqueNetworkName;
                OpaqueNetworkSpec opaqueNetworkSpec = this.networkSpecsByName.get(network.opaqueNetworkName);
                if (opaqueNetworkSpec != null) {
                    networkModel.virtualMachinesCount = opaqueNetworkSpec.vmCount;
                    if (opaqueNetworkSpec.provider != null) {
                        networkModel.portgroupValue = opaqueNetworkSpec.provider.getValue();
                    }
                }
                this.addVnicsToNetworkModel(networkModel);
                this.sortVmkernelAdapters(networkModel.vmkernelAdapters);
                diagramModel.portGroups.add(networkModel);
            }
            this.buildRelations(pnicZonesByKey, diagramModel, opaqueSwitch);
            this.sortNetworks(diagramModel.portGroups);
        }
    }

    private void addPnicsToDiagramModel(VswitchDiagramModel diagramModel, OpaqueSwitch opaqueSwitch) {
        if (!ArrayUtil.isNullOrEmpty((Object[])opaqueSwitch.pnic)) {
            for (String pnicKey : opaqueSwitch.pnic) {
                PhysicalNic physicalNic = this.pnicsByKey.get(pnicKey);
                if (physicalNic == null) continue;
                PhysicalAdapterModel adapterModel = new PhysicalAdapterModel();
                adapterModel.id = pnicKey;
                adapterModel.hostValue = this.ovsDiagramSpec.hostValue;
                adapterModel.title = physicalNic.device;
                adapterModel.portStatus = PortStatus.DISCONNECTED;
                adapterModel.pNicLinkUp = false;
                if (physicalNic.linkSpeed != null) {
                    adapterModel.pNicLinkUp = true;
                    adapterModel.linkSpeed = Integer.toString(physicalNic.linkSpeed.speedMb);
                    adapterModel.duplex = SwitchDiagramUtil.getDuplexString(physicalNic.linkSpeed.duplex);
                    adapterModel.portStatus = PortStatus.CONNECTED;
                }
                diagramModel.pnics.add(adapterModel);
            }
            this.sortPhysicalAdapters(diagramModel.pnics);
        }
    }

    private void addVnicsToNetworkModel(PortGroupModel networkModel) {
        List<VirtualNic> vnicsForNetwork = this.vnicsByOpaqueNetworkId.get(networkModel.id);
        if (vnicsForNetwork != null) {
            for (VirtualNic virtualNic : vnicsForNetwork) {
                PortModel portModel = new PortModel();
                portModel.id = virtualNic.key;
                portModel.hostValue = this.ovsDiagramSpec.hostValue;
                portModel.vmkDevice = virtualNic.device;
                portModel.portStatus = PortStatus.CONNECTED;
                if (virtualNic.spec != null && virtualNic.spec.ip != null) {
                    portModel.title = String.format("%s : %s", virtualNic.device, virtualNic.spec.ip.ipAddress);
                }
                networkModel.vmkernelAdapters.add(portModel);
            }
        }
    }

    private void buildRelations(Map<String, OpaqueSwitch.PhysicalNicZone> pnicZonesByKey, VswitchDiagramModel diagramModel, OpaqueSwitch opaqueSwitch) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.ovsDiagramSpec.opaqueNetworks)) {
            for (OpaqueNetworkInfo opaqueNetworkInfo : this.ovsDiagramSpec.opaqueNetworks) {
                if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworkInfo.pnicZone)) continue;
                for (String pnicZoneKey : opaqueNetworkInfo.pnicZone) {
                    OpaqueSwitch.PhysicalNicZone zone = pnicZonesByKey.get(pnicZoneKey);
                    if (zone == null) continue;
                    Object[] associatedPnics = zone.pnicDevice != null ? zone.pnicDevice : opaqueSwitch.pnic;
                    List<VirtualNic> vnicsForOpaqueNetwork = this.vnicsByOpaqueNetworkId.get(opaqueNetworkInfo.opaqueNetworkId);
                    ArrayList<VirtualNic> unpinnedVnics = new ArrayList<VirtualNic>();
                    if (!CollectionUtil.isNullOrEmpty(vnicsForOpaqueNetwork)) {
                        for (VirtualNic vnic : vnicsForOpaqueNetwork) {
                            if (vnic != null && vnic.spec != null && vnic.spec.pinnedPnic != null) {
                                PhysicalNic pinnedPnic = this.pnicsByName.get(vnic.spec.pinnedPnic);
                                if (pinnedPnic == null) continue;
                                diagramModel.relations.add(new GraphRelation(vnic.key, pinnedPnic.key));
                                continue;
                            }
                            unpinnedVnics.add(vnic);
                        }
                    }
                    if (ArrayUtil.isNullOrEmpty((Object[])associatedPnics)) continue;
                    for (Object pnicKey : associatedPnics) {
                        diagramModel.relations.add(new GraphRelation(opaqueNetworkInfo.opaqueNetworkId, (String)pnicKey));
                        if (CollectionUtil.isNullOrEmpty(unpinnedVnics)) continue;
                        for (VirtualNic vnic : unpinnedVnics) {
                            diagramModel.relations.add(new GraphRelation(vnic.key, (String)pnicKey));
                        }
                    }
                }
            }
        }
    }

    private void initPnicsMaps() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.ovsDiagramSpec.pnics)) {
            for (PhysicalNic pnic : this.ovsDiagramSpec.pnics) {
                if (pnic == null) continue;
                this.pnicsByKey.put(pnic.key, pnic);
                this.pnicsByName.put(pnic.device, pnic);
            }
        }
    }

    private void initVnicsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.ovsDiagramSpec.vnics)) {
            for (VirtualNic vnic : this.ovsDiagramSpec.vnics) {
                if (vnic == null || vnic.spec == null || vnic.spec.opaqueNetwork == null || StringUtil.isNullOrEmpty((String)vnic.spec.opaqueNetwork.opaqueNetworkId)) continue;
                List<VirtualNic> vnics = this.vnicsByOpaqueNetworkId.get(vnic.spec.opaqueNetwork.opaqueNetworkId);
                if (vnics == null) {
                    vnics = new ArrayList<VirtualNic>();
                    this.vnicsByOpaqueNetworkId.put(vnic.spec.opaqueNetwork.opaqueNetworkId, vnics);
                }
                vnics.add(vnic);
            }
        }
    }

    private void initNetworkSpecsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.ovsDiagramSpec.opaqueNetworkSpecs)) {
            for (OpaqueNetworkSpec spec : this.ovsDiagramSpec.opaqueNetworkSpecs) {
                if (spec == null || StringUtil.isNullOrEmpty((String)spec.name)) continue;
                this.networkSpecsByName.put(spec.name, spec);
            }
        }
    }

    private boolean isNetworkAssociatedWithSwitch(Set<String> switchPnicZones, OpaqueNetworkInfo opaqueNetworkInfo) {
        if (opaqueNetworkInfo != null && !ArrayUtil.isNullOrEmpty((Object[])opaqueNetworkInfo.pnicZone)) {
            for (String opaqueNetworkZoneId : opaqueNetworkInfo.pnicZone) {
                if (switchPnicZones.contains(opaqueNetworkZoneId)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, OpaqueSwitch.PhysicalNicZone> getPnicZoneByKey(OpaqueSwitch opaqueSwitch) {
        HashMap<String, OpaqueSwitch.PhysicalNicZone> pnicZonesByKey = new HashMap<String, OpaqueSwitch.PhysicalNicZone>();
        if (!ArrayUtil.isNullOrEmpty((Object[])opaqueSwitch.pnicZone)) {
            for (OpaqueSwitch.PhysicalNicZone pnicZone : opaqueSwitch.pnicZone) {
                if (StringUtil.isNullOrEmpty((String)pnicZone.key)) continue;
                pnicZonesByKey.put(pnicZone.key, pnicZone);
            }
        }
        return pnicZonesByKey;
    }

    private void sortNetworks(List<PortGroupModel> opaqueNetworkModels) {
        Collections.sort(opaqueNetworkModels, new Comparator<PortGroupModel>(){

            @Override
            public int compare(PortGroupModel o1, PortGroupModel o2) {
                if (o1.title == null && o2.title == null) {
                    return 0;
                }
                if (o1.title == null) {
                    return -1;
                }
                if (o2.title == null) {
                    return 1;
                }
                return o1.title.compareTo(o2.title);
            }
        });
    }

    private void sortVmkernelAdapters(List<PortModel> vmkNics) {
        Collections.sort(vmkNics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vmk1, PortModel vmk2) {
                return NetworkUtil.compareNicDevices(vmk1.vmkDevice, vmk2.vmkDevice, "vmk");
            }
        });
    }

    private void sortPhysicalAdapters(List<PhysicalAdapterModel> physicalNics) {
        Collections.sort(physicalNics, new Comparator<PhysicalAdapterModel>(){

            @Override
            public int compare(PhysicalAdapterModel adapter1, PhysicalAdapterModel adapter2) {
                return NetworkUtil.compareNicDevices(adapter1.title, adapter2.title, "vmnic");
            }
        });
    }
}

