/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.GraphRelation;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PhysicalAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.VswitchDiagramModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.VswitchType;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.VlanType;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.VssDiagramBuilder;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.StandardNetworkSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.VssDiagramSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VssDiagramBuilderImpl
implements VssDiagramBuilder {
    private VssDiagramSpec vssDiagramSpec;
    private Map<String, PortGroup> portgroupsByKey = new HashMap<String, PortGroup>();
    private Map<String, VirtualNic> vnicsByKey = new HashMap<String, VirtualNic>();
    private Map<String, String> vnicKeyByPortgroup = new HashMap<String, String>();
    private Map<String, PhysicalNic> pnicsByKey = new HashMap<String, PhysicalNic>();
    private Map<String, PhysicalNic> pnicsByDevice = new HashMap<String, PhysicalNic>();
    private Set<String> sriovDeviceIds = new HashSet<String>();
    private Map<String, StandardNetworkSpec> networkSpecByName = new HashMap<String, StandardNetworkSpec>();
    private List<PortGroup> portGroupsOnSwitch = new ArrayList<PortGroup>();

    public VssDiagramBuilderImpl(VssDiagramSpec vssDiagramSpec) {
        if (vssDiagramSpec == null) {
            throw new IllegalArgumentException("vssDiagramSpec cannot be null");
        }
        this.vssDiagramSpec = vssDiagramSpec;
        this.initPortgroupsMap();
        this.initVnicsMap();
        this.initPnicsMap();
        this.initNetworkSpecMap();
        this.initSriovDevicesSet();
    }

    public VswitchDiagramModel buildDiagramModel(VirtualSwitch vswitch) {
        VswitchDiagramModel diagramModel = new VswitchDiagramModel();
        diagramModel.switchType = VswitchType.VSS.toString();
        if (vswitch != null) {
            diagramModel.switchKey = vswitch.key;
        }
        this.addPortgroupsToDiagramModel(diagramModel, vswitch);
        this.addPnicsToDiagramModel(diagramModel, vswitch);
        this.buildTeamingRelations(diagramModel);
        return diagramModel;
    }

    private void initPortgroupsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.vssDiagramSpec.portGroups)) {
            for (PortGroup portGroup : this.vssDiagramSpec.portGroups) {
                if (portGroup == null) continue;
                this.portgroupsByKey.put(portGroup.key, portGroup);
            }
        }
    }

    private void initVnicsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.vssDiagramSpec.vnics)) {
            for (VirtualNic vnic : this.vssDiagramSpec.vnics) {
                if (vnic == null) continue;
                this.vnicsByKey.put(vnic.port, vnic);
            }
        }
    }

    private void initPnicsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.vssDiagramSpec.pnics)) {
            for (PhysicalNic pnic : this.vssDiagramSpec.pnics) {
                if (pnic == null) continue;
                this.pnicsByKey.put(pnic.key, pnic);
                this.pnicsByDevice.put(pnic.device, pnic);
            }
        }
    }

    private void initNetworkSpecMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.vssDiagramSpec.stdNetworkSpecs)) {
            for (StandardNetworkSpec stdNetworkSpec : this.vssDiagramSpec.stdNetworkSpecs) {
                if (stdNetworkSpec == null) continue;
                this.networkSpecByName.put(stdNetworkSpec.name, stdNetworkSpec);
            }
        }
    }

    private void initSriovDevicesSet() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.vssDiagramSpec.sriovInfos)) {
            for (SriovInfo sriovInfo : this.vssDiagramSpec.sriovInfos) {
                if (sriovInfo == null || !sriovInfo.sriovActive || StringUtil.isNullOrEmpty((String)sriovInfo.id)) continue;
                this.sriovDeviceIds.add(sriovInfo.id);
            }
        }
    }

    private void addPortgroupsToDiagramModel(VswitchDiagramModel model, VirtualSwitch vswitch) {
        if (vswitch != null && !ArrayUtil.isNullOrEmpty((Object[])vswitch.portgroup)) {
            for (String pgKey : vswitch.portgroup) {
                PortGroup portGroup = this.portgroupsByKey.get(pgKey);
                if (portGroup == null) continue;
                this.portGroupsOnSwitch.add(portGroup);
                if (portGroup.spec == null) continue;
                PortGroupModel portGroupModel = new PortGroupModel();
                portGroupModel.id = portGroup.spec.name;
                portGroupModel.title = portGroup.spec.name;
                portGroupModel.portgroupKey = pgKey;
                String vlanText = SwitchDiagramUtil.getVlanString(VlanType.VLAN);
                portGroupModel.vlan = vlanText = String.format("%s %s", vlanText, portGroup.spec.vlanId > 0 ? Integer.valueOf(portGroup.spec.vlanId) : NetworkStringUtil.getString("na"));
                StandardNetworkSpec networkSpec = this.networkSpecByName.get(portGroup.spec.name);
                if (networkSpec != null) {
                    portGroupModel.virtualMachinesCount = networkSpec.vmCount;
                    if (networkSpec.provider != null) {
                        portGroupModel.portgroupValue = networkSpec.provider.getValue();
                    }
                }
                this.addPortsToPortgroupModel(portGroupModel, portGroup);
                model.portGroups.add(portGroupModel);
            }
            this.sortPortgroups(model.portGroups);
        }
    }

    private void addPnicsToDiagramModel(VswitchDiagramModel model, VirtualSwitch vswitch) {
        if (vswitch != null && !ArrayUtil.isNullOrEmpty((Object[])vswitch.pnic)) {
            for (String pnicKey : vswitch.pnic) {
                PhysicalNic physicalNic = this.pnicsByKey.get(pnicKey);
                if (physicalNic == null) continue;
                PhysicalAdapterModel adapterModel = new PhysicalAdapterModel();
                if (this.sriovDeviceIds.contains(physicalNic.pci)) {
                    adapterModel = new SriovAdapterModel();
                    ((SriovAdapterModel)adapterModel).physicalFunctionId = physicalNic.pci;
                }
                adapterModel.id = pnicKey;
                adapterModel.hostValue = this.vssDiagramSpec.hostValue;
                adapterModel.title = physicalNic.device;
                adapterModel.portStatus = PortStatus.DISCONNECTED;
                adapterModel.pNicLinkUp = false;
                if (physicalNic.linkSpeed != null) {
                    adapterModel.pNicLinkUp = true;
                    adapterModel.linkSpeed = Integer.toString(physicalNic.linkSpeed.speedMb);
                    adapterModel.duplex = SwitchDiagramUtil.getDuplexString(physicalNic.linkSpeed.duplex);
                    adapterModel.portStatus = PortStatus.CONNECTED;
                }
                model.pnics.add(adapterModel);
            }
            this.sortPhysicalAdapters(model.pnics);
        }
    }

    private void addPortsToPortgroupModel(PortGroupModel portGroupModel, PortGroup portGroup) {
        if (!ArrayUtil.isNullOrEmpty((Object[])portGroup.port)) {
            for (PortGroup.Port port : portGroup.port) {
                VirtualNic virtualNic;
                if (!PortGroup.PortConnecteeType.host.toString().equals(port.type) || (virtualNic = this.vnicsByKey.get(port.key)) == null) continue;
                PortModel portModel = new PortModel();
                portModel.id = virtualNic.port;
                portModel.hostValue = this.vssDiagramSpec.hostValue;
                portModel.vmkDevice = virtualNic.device;
                portModel.portStatus = PortStatus.CONNECTED;
                if (virtualNic.spec != null && virtualNic.spec.ip != null) {
                    portModel.title = String.format("%s : %s", virtualNic.device, virtualNic.spec.ip.ipAddress);
                }
                portGroupModel.vmkernelAdapters.add(portModel);
                this.vnicKeyByPortgroup.put(portGroup.key, virtualNic.port);
            }
            this.sortVmkernelAdapters(portGroupModel.vmkernelAdapters);
        }
    }

    private void buildTeamingRelations(VswitchDiagramModel diagramModel) {
        if (!ArrayUtil.isNullOrEmpty(this.portGroupsOnSwitch)) {
            for (PortGroup portGroup : this.portGroupsOnSwitch) {
                Object[] pnicDevices;
                if (portGroup == null || portGroup.computedPolicy == null || portGroup.computedPolicy.nicTeaming == null || portGroup.computedPolicy.nicTeaming.nicOrder == null || ArrayUtil.isNullOrEmpty((Object[])(pnicDevices = portGroup.computedPolicy.nicTeaming.nicOrder.activeNic))) continue;
                for (Object pnicDevice : pnicDevices) {
                    String vnicKey;
                    PhysicalNic pnic = this.pnicsByDevice.get(pnicDevice);
                    if (pnic == null) continue;
                    if (portGroup.spec != null && !StringUtil.isNullOrEmpty((String)portGroup.spec.name)) {
                        diagramModel.relations.add(new GraphRelation(portGroup.spec.name, pnic.key));
                    }
                    if ((vnicKey = this.vnicKeyByPortgroup.get(portGroup.key)) == null) continue;
                    diagramModel.relations.add(new GraphRelation(vnicKey, pnic.key));
                }
            }
        }
    }

    private void sortPortgroups(List<PortGroupModel> portGroupModels) {
        Collections.sort(portGroupModels, new Comparator<PortGroupModel>(){

            @Override
            public int compare(PortGroupModel pg1, PortGroupModel pg2) {
                if (pg1.title == null && pg2.title == null) {
                    return 0;
                }
                if (pg1.title == null) {
                    return -1;
                }
                if (pg2.title == null) {
                    return 1;
                }
                return pg1.title.compareTo(pg2.title);
            }
        });
    }

    private void sortVmkernelAdapters(List<PortModel> vmkNics) {
        Collections.sort(vmkNics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vmk1, PortModel vmk2) {
                return NetworkUtil.compareNicDevices(vmk1.vmkDevice, vmk2.vmkDevice, "vmk");
            }
        });
    }

    private void sortPhysicalAdapters(List<PhysicalAdapterModel> physicalNics) {
        Collections.sort(physicalNics, new Comparator<PhysicalAdapterModel>(){

            @Override
            public int compare(PhysicalAdapterModel adapter1, PhysicalAdapterModel adapter2) {
                return NetworkUtil.compareNicDevices(adapter1.title, adapter2.title, "vmnic");
            }
        });
    }
}

