/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram.model.internal;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramHostSpec;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HostMemberModel {
    public SwitchDiagramHostSpec switchDiagramHostSpec;
    public HostProxySwitch hostProxySwitch;
    public List<DistributedVirtualPort> uplinkPorts = new LinkedList<DistributedVirtualPort>();
    private Map<String, VirtualNic> _virtualNicsMap = new HashMap<String, VirtualNic>();

    public HostMemberModel(SwitchDiagramHostSpec switchDiagramHostSpec, String dvsUuid) {
        if (switchDiagramHostSpec == null) {
            throw new IllegalArgumentException("switchDiagramHostSpec cannot be null");
        }
        if (dvsUuid == null) {
            throw new IllegalArgumentException("dvsUuid cannot be null");
        }
        if (switchDiagramHostSpec.network == null) {
            throw new IllegalArgumentException("networkInfo cannot be null");
        }
        this.switchDiagramHostSpec = switchDiagramHostSpec;
        this.initializeProxySwitch(dvsUuid);
        this.initializeVirtualNicsMap(dvsUuid);
    }

    public VirtualNic getVirtualNicForKey(String nicKey) {
        return this._virtualNicsMap.get(nicKey);
    }

    public Map<String, VirtualNic> getVirtualNicsMap() {
        return this._virtualNicsMap;
    }

    private void initializeProxySwitch(String dvsUuid) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.switchDiagramHostSpec.network.proxySwitch)) {
            for (HostProxySwitch proxySwitch : this.switchDiagramHostSpec.network.proxySwitch) {
                if (!dvsUuid.equals(proxySwitch.dvsUuid)) continue;
                this.hostProxySwitch = proxySwitch;
                break;
            }
        }
    }

    private void initializeVirtualNicsMap(String dvsUuid) {
        if (!ArrayUtil.isNullOrEmpty((Object[])this.switchDiagramHostSpec.network.vnic)) {
            for (VirtualNic vnic : this.switchDiagramHostSpec.network.vnic) {
                if (vnic == null || vnic.spec == null || vnic.spec.distributedVirtualPort == null || !dvsUuid.equals(vnic.spec.distributedVirtualPort.switchUuid) || StringUtil.isNullOrEmpty((String)vnic.device)) continue;
                this._virtualNicsMap.put(vnic.device, vnic);
            }
        }
    }

    public PhysicalNic getPhysicalNic(String device) {
        PhysicalNic result = null;
        for (PhysicalNic physicalNic : this.switchDiagramHostSpec.network.pnic) {
            if (physicalNic == null || physicalNic.device == null || !Objects.equals(device, physicalNic.device)) continue;
            result = physicalNic;
        }
        return result;
    }

    public PhysicalNic getPhysicalNicForProxySwitchPnicKey(String key) {
        PhysicalNic pnic = null;
        if (this.switchDiagramHostSpec != null && this.switchDiagramHostSpec.network != null && !ArrayUtil.isNullOrEmpty((Object[])this.switchDiagramHostSpec.network.pnic)) {
            for (PhysicalNic physicalNic : this.switchDiagramHostSpec.network.pnic) {
                if (!key.endsWith(physicalNic.key)) continue;
                pnic = physicalNic;
                break;
            }
        }
        return pnic;
    }
}

