/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpUtil {
    private static final String IPV6_LINK_LOCAL_PREFIX = "FE80";
    private static final int IPV6_LINK_LOCAL_PREFIX_LENGTH = 64;
    private static final String IPV4_LINK_LOCAL_PREFIX = "169.254";
    private static final String IPV4_LINK_LOCAL_MASK = "255.255.0.0";
    private static final int IPV4_MIN_PREFIX_LENGTH = 0;
    private static final int IPV4_MAX_PREFIX_LENGTH = 32;
    private static final String IPV4_OCTET = "(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])";
    private static final String IPV4_REGEXP = "^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$";

    public static boolean isIpV6LinkLocal(IpConfig.IpV6Address ipV6Address) {
        if (ipV6Address == null || ipV6Address.ipAddress == null) {
            return false;
        }
        return ipV6Address.ipAddress.trim().toUpperCase().indexOf(IPV6_LINK_LOCAL_PREFIX) == 0 && ipV6Address.prefixLength == 64;
    }

    public static boolean isIpV4LinkLocal(String address, String subnetMask) {
        return address != null && address.trim().indexOf(IPV4_LINK_LOCAL_PREFIX) == 0 && subnetMask.trim().equals(IPV4_LINK_LOCAL_MASK);
    }

    public static String ipv6AddressToString(IpConfig.IpV6Address ipv6Address) {
        if (ipv6Address == null || ipv6Address.ipAddress == null) {
            return "";
        }
        return ipv6Address.ipAddress + "/" + ipv6Address.prefixLength;
    }

    private static IpConfig.IpV6Address[] reorderIpv6Addresses(IpConfig.IpV6Address[] ipv6Addresses) {
        if (ipv6Addresses == null) {
            return null;
        }
        IpConfig.IpV6Address[] reorderedAddresses = new IpConfig.IpV6Address[ipv6Addresses.length];
        ArrayList<IpConfig.IpV6Address> linkLocalAddresses = new ArrayList<IpConfig.IpV6Address>();
        int addressCount = 0;
        for (IpConfig.IpV6Address address : ipv6Addresses) {
            if (IpUtil.isIpV6LinkLocal(address)) {
                linkLocalAddresses.add(address);
                continue;
            }
            reorderedAddresses[addressCount] = address;
            ++addressCount;
        }
        Iterator iterator = linkLocalAddresses.iterator();
        while (iterator.hasNext()) {
            IpConfig.IpV6Address linkLocal;
            reorderedAddresses[addressCount] = linkLocal = (IpConfig.IpV6Address)iterator.next();
            ++addressCount;
        }
        return reorderedAddresses;
    }

    public static String getLocalizedIPv6AddrConfigType(String type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.equals(IpConfig.IpV6AddressConfigType.dhcp.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrDhcpTypeFormat");
        }
        if (type2.equals(IpConfig.IpV6AddressConfigType.manual.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrStaticTypeFormat");
        }
        if (type2.equals(IpConfig.IpV6AddressConfigType.linklayer.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrLinkLayerTypeFormat");
        }
        if (type2.equals(IpConfig.IpV6AddressConfigType.random.toString())) {
            return NetworkStringUtil.getString("IpV6AddressConfigType.ipAddrRandomTypeFormat");
        }
        return null;
    }

    public static String[] formatIpv6Addresses(IpConfig.IpV6Address[] addresses) {
        IpConfig.IpV6Address[] reorderedAddress = IpUtil.reorderIpv6Addresses(addresses);
        if (reorderedAddress == null) {
            return null;
        }
        String[] formattedAddresses = new String[reorderedAddress.length];
        for (int i = 0; i < formattedAddresses.length; ++i) {
            String localizedAddressConfigType = IpUtil.getLocalizedIPv6AddrConfigType(reorderedAddress[i].origin);
            String localizedIpAddress = IpUtil.ipv6AddressToString(reorderedAddress[i]);
            formattedAddresses[i] = !StringUtil.isNullOrEmpty((String)localizedAddressConfigType) ? NetworkStringUtil.getString("IpV6Address.ipAddressTypeFormat", localizedIpAddress, localizedAddressConfigType) : localizedIpAddress;
        }
        return formattedAddresses;
    }

    public static boolean hasAnyIpv6Addresses(IpConfig ipConfig) {
        return ipConfig != null && ipConfig.ipV6Config != null && !ArrayUtil.isNullOrEmpty((Object[])ipConfig.ipV6Config.ipV6Address);
    }

    public static boolean hasAnyIpv4Settings(IpConfig ipConfig) {
        return ipConfig != null && (ipConfig.dhcp || !StringUtil.isNullOrEmpty((String)ipConfig.ipAddress));
    }

    public static boolean isIpv4Valid(String value) {
        if (value == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(IPV4_REGEXP);
        Matcher matcher = pattern.matcher(value.trim());
        return matcher.find();
    }

    public static boolean hasAnyIpv6Settings(IpConfig ipConfig) {
        if (ipConfig == null || ipConfig.ipV6Config == null) {
            return false;
        }
        boolean isAutoConfigurationEnabled = ipConfig.ipV6Config.autoConfigurationEnabled != null && ipConfig.ipV6Config.autoConfigurationEnabled != false;
        boolean isDhcpV6Enabled = ipConfig.ipV6Config.dhcpV6Enabled != null && ipConfig.ipV6Config.dhcpV6Enabled != false;
        return isAutoConfigurationEnabled || isDhcpV6Enabled || IpUtil.hasManuallyConfiguredIpv6Address(ipConfig.ipV6Config.ipV6Address);
    }

    public static String getIpv4SubnetMask(String prefixLength) {
        if (Integer.valueOf(prefixLength) < 0 || Integer.valueOf(prefixLength) > 32) {
            throw new IllegalArgumentException("Prefix length is not in the expected range");
        }
        int bits = 32 - Integer.parseInt(prefixLength);
        int mask = bits == 32 ? 0 : -1 - ((1 << bits) - 1);
        return Integer.toString(mask >> 24 & 0xFF, 10) + "." + Integer.toString(mask >> 16 & 0xFF, 10) + "." + Integer.toString(mask >> 8 & 0xFF, 10) + "." + Integer.toString(mask >> 0 & 0xFF, 10);
    }

    public static String extractIpAddress(VirtualNic rawVnic) {
        IpConfig.IpV6Address[] ipV6Addresses;
        String subnetMask;
        if (rawVnic == null || rawVnic.spec == null || rawVnic.spec.ip == null) {
            return "";
        }
        IpConfig ipConfig = rawVnic.spec.ip;
        String ipv4 = ipConfig.getIpAddress();
        if (!IpUtil.isIpV4LinkLocal(ipv4, subnetMask = ipConfig.getSubnetMask()) && !StringUtil.isNullOrEmpty((String)ipv4)) {
            return ipv4;
        }
        IpConfig.IpV6Address[] ipV6AddressArray = ipV6Addresses = ipConfig.ipV6Config != null ? ipConfig.ipV6Config.getIpV6Address() : new IpConfig.IpV6Address[]{};
        if (ipV6Addresses != null) {
            for (IpConfig.IpV6Address ipV6Address : ipV6Addresses) {
                if (StringUtil.isNullOrEmpty((String)ipV6Address.getIpAddress()) || IpUtil.isIpV6LinkLocal(ipV6Address)) continue;
                return ipV6Address.getIpAddress();
            }
        }
        if (!StringUtil.isNullOrEmpty((String)ipv4)) {
            return ipv4;
        }
        if (ipV6Addresses != null) {
            for (IpConfig.IpV6Address ipV6Address : ipV6Addresses) {
                if (StringUtil.isNullOrEmpty((String)ipV6Address.getIpAddress())) continue;
                return ipV6Address.getIpAddress();
            }
        }
        return "";
    }

    private static boolean hasManuallyConfiguredIpv6Address(IpConfig.IpV6Address[] ipv6Addresses) {
        if (ArrayUtil.isNullOrEmpty((Object[])ipv6Addresses)) {
            return false;
        }
        for (IpConfig.IpV6Address ipv6Address : ipv6Addresses) {
            if (ipv6Address == null || ipv6Address.origin == null || !ipv6Address.origin.equals(IpConfig.IpV6AddressConfigType.manual.name())) continue;
            return true;
        }
        return false;
    }
}

